/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

public class CrashReporter {
    public static void onCrashReport(b crashReport, c category) {
        try {
            Throwable throwable = crashReport.b();
            if (throwable == null) {
                return;
            }
            if (throwable.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            if (throwable.getClass() == Throwable.class) {
                return;
            }
            CrashReporter.extendCrashReport(category);
            avh gamesettings = Config.getGameSettings();
            if (gamesettings == null) {
                return;
            }
            if (!gamesettings.r) {
                return;
            }
            String s2 = "http://optifine.net/crashReport";
            String s1 = CrashReporter.makeReport(crashReport);
            byte[] abyte = s1.getBytes("ASCII");
            IFileUploadListener ifileuploadlistener = new IFileUploadListener(){

                public void fileUploadFinished(String url, byte[] content, Throwable exception) {
                }
            };
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("OF-Version", Config.getVersion());
            map.put("OF-Summary", CrashReporter.makeSummary(crashReport));
            FileUploadThread fileuploadthread = new FileUploadThread(s2, map, abyte, ifileuploadlistener);
            fileuploadthread.setPriority(10);
            fileuploadthread.start();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            Config.dbg(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    private static String makeReport(b crashReport) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("OptiFineVersion: " + Config.getVersion() + "\n");
        stringbuffer.append("Summary: " + CrashReporter.makeSummary(crashReport) + "\n");
        stringbuffer.append("\n");
        stringbuffer.append(crashReport.e());
        stringbuffer.append("\n");
        return stringbuffer.toString();
    }

    private static String makeSummary(b crashReport) {
        Throwable throwable = crashReport.b();
        if (throwable == null) {
            return "Unknown";
        }
        StackTraceElement[] astacktraceelement = throwable.getStackTrace();
        String s2 = "unknown";
        if (astacktraceelement.length > 0) {
            s2 = astacktraceelement[0].toString().trim();
        }
        String s1 = throwable.getClass().getName() + ": " + throwable.getMessage() + " (" + crashReport.a() + ") [" + s2 + "]";
        return s1;
    }

    public static void extendCrashReport(c cat) {
        cat.a("OptiFine Version", Config.getVersion());
        cat.a("OptiFine Build", Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat.a("Render Distance Chunks", "" + Config.getChunkViewDistance());
            cat.a("Mipmaps", "" + Config.getMipmapLevels());
            cat.a("Anisotropic Filtering", "" + Config.getAnisotropicFilterLevel());
            cat.a("Antialiasing", "" + Config.getAntialiasingLevel());
            cat.a("Multitexture", "" + Config.isMultiTexture());
        }
        cat.a("Shaders", "" + Shaders.getShaderPackName());
        cat.a("OpenGlVersion", "" + Config.openGlVersion);
        cat.a("OpenGlRenderer", "" + Config.openGlRenderer);
        cat.a("OpenGlVendor", "" + Config.openGlVendor);
        cat.a("CpuCount", "" + Config.getAvailableProcessors());
    }
}

