/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.internal.PlatformDependent;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinecraftServer
implements Runnable,
m,
od,
os {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private static MinecraftServer l;
    private final atr m;
    private final or n = new or("server", this, MinecraftServer.az());
    private final File o;
    private final List<km> p = Lists.newArrayList();
    protected final l b;
    public final nt c = new nt();
    private final ll q;
    private final js r = new js();
    private final Random s = new Random();
    private int u = -1;
    public le[] d;
    private lx v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G = 0;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private long X = 0L;
    private final GameProfileRepository Y;
    private final lt Z;
    protected final Queue<FutureTask<?>> j = PlatformDependent.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.az();

    public MinecraftServer(Proxy proxy, File workDir) {
        this.e = proxy;
        l = this;
        this.o = null;
        this.q = null;
        this.Z = new lt(this, workDir);
        this.b = null;
        this.m = null;
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    public MinecraftServer(File workDir, Proxy proxy, File profileCacheDir) {
        this.e = proxy;
        l = this;
        this.o = workDir;
        this.q = new ll(this);
        this.Z = new lt(this, profileCacheDir);
        this.b = this.h();
        this.m = new atk(workDir);
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    protected bd h() {
        return new bd();
    }

    protected abstract boolean i() throws IOException;

    protected void a(String worldNameIn) {
        if (this.Y().b(worldNameIn)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.Y().a(worldNameIn, new nu(){
                private long b = System.currentTimeMillis();

                public void a(String message) {
                }

                public void b(String message) {
                }

                public void a(int progress) {
                    if (System.currentTimeMillis() - this.b >= 1000L) {
                        this.b = System.currentTimeMillis();
                        k.info("Converting... " + progress + "%");
                    }
                }

                public void a() {
                }

                public void c(String message) {
                }
            });
        }
    }

    protected synchronized void b(String message) {
        this.S = message;
    }

    public synchronized String j() {
        return this.S;
    }

    protected void a(String p_71247_1_, String p_71247_2_, long seed, adr type, String p_71247_6_) {
        adp worldsettings;
        this.a(p_71247_1_);
        this.b("menu.loadingLevel");
        this.d = new le[3];
        this.i = new long[this.d.length][100];
        atp isavehandler = this.m.a(p_71247_1_, true);
        this.a(this.U(), isavehandler);
        ato worldinfo = isavehandler.d();
        if (worldinfo == null) {
            if (this.X()) {
                worldsettings = kx.a;
            } else {
                worldsettings = new adp(seed, this.m(), this.l(), this.o(), type);
                worldsettings.a(p_71247_6_);
                if (this.M) {
                    worldsettings.a();
                }
            }
            worldinfo = new ato(worldsettings, p_71247_2_);
        } else {
            worldinfo.a(p_71247_2_);
            worldsettings = new adp(worldinfo);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            int j2 = 0;
            if (i2 == 1) {
                j2 = -1;
            }
            if (i2 == 2) {
                j2 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.X() ? (le)new kx(this, isavehandler, worldinfo, j2, this.c).b() : (le)new le(this, isavehandler, worldinfo, j2, this.c).b();
                this.d[i2].a(worldsettings);
            } else {
                this.d[i2] = (le)new kz(this, isavehandler, j2, this.d[0], this.c).b();
            }
            this.d[i2].a(new lb(this, this.d[i2]));
            if (this.T()) continue;
            this.d[i2].P().a(this.m());
        }
        this.v.a(this.d);
        this.a(this.n());
        this.k();
    }

    protected void k() {
        int i2 = 16;
        int j2 = 4;
        int k2 = 192;
        int l2 = 625;
        int i1 = 0;
        this.b("menu.generatingTerrain");
        int j1 = 0;
        k.info("Preparing start region for level " + j1);
        le worldserver = this.d[j1];
        cj blockpos = worldserver.M();
        long k1 = MinecraftServer.az();
        for (int l1 = -192; l1 <= 192 && this.v(); l1 += 16) {
            for (int i22 = -192; i22 <= 192 && this.v(); i22 += 16) {
                long j22 = MinecraftServer.az();
                if (j22 - k1 > 1000L) {
                    this.a_("Preparing spawn area", i1 * 100 / 625);
                    k1 = j22;
                }
                ++i1;
                worldserver.b.c(blockpos.n() + l1 >> 4, blockpos.p() + i22 >> 4);
            }
        }
        this.s();
    }

    protected void a(String worldNameIn, atp saveHandlerIn) {
        File file1 = new File(saveHandlerIn.b(), "resources.zip");
        if (file1.isFile()) {
            this.a_("level://" + worldNameIn + "/" + file1.getName(), "");
        }
    }

    public abstract boolean l();

    public abstract adp.a m();

    public abstract oj n();

    public abstract boolean o();

    public abstract int p();

    public abstract boolean q();

    public abstract boolean r();

    protected void a_(String message, int percent) {
        this.f = message;
        this.g = percent;
        k.info(message + ": " + percent + "%");
    }

    protected void s() {
        this.f = null;
        this.g = 0;
    }

    protected void a(boolean dontLog) {
        if (!this.N) {
            for (le worldserver : this.d) {
                if (worldserver == null) continue;
                if (!dontLog) {
                    k.info("Saving chunks for level '" + worldserver.P().k() + "'/" + worldserver.t.k());
                }
                try {
                    worldserver.a(true, (nu)null);
                }
                catch (adn minecraftexception) {
                    k.warn(minecraftexception.getMessage());
                }
            }
        }
    }

    public void t() {
        if (!this.N) {
            k.info("Stopping server");
            if (this.aq() != null) {
                this.aq().b();
            }
            if (this.v != null) {
                k.info("Saving players");
                this.v.j();
                this.v.u();
            }
            if (this.d != null) {
                k.info("Saving worlds");
                this.a(false);
                for (int i2 = 0; i2 < this.d.length; ++i2) {
                    le worldserver = this.d[i2];
                    worldserver.o();
                }
            }
            if (this.n.d()) {
                this.n.e();
            }
        }
    }

    public boolean v() {
        return this.w;
    }

    public void w() {
        this.w = false;
    }

    protected void x() {
        l = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.i()) {
                this.ab = MinecraftServer.az();
                long i2 = 0L;
                this.r.a(new fa(this.E));
                this.r.a(new js.c("1.8.9", 47));
                this.a(this.r);
                while (this.w) {
                    long k2 = MinecraftServer.az();
                    long j2 = k2 - this.ab;
                    if (j2 > 2000L && this.ab - this.R >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{j2, j2 / 50L});
                        j2 = 2000L;
                        this.R = this.ab;
                    }
                    if (j2 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        j2 = 0L;
                    }
                    i2 += j2;
                    this.ab = k2;
                    if (this.d[0].f()) {
                        this.A();
                        i2 = 0L;
                    } else {
                        while (i2 > 50L) {
                            i2 -= 50L;
                            this.A();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - i2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable1) {
            k.error("Encountered an unexpected exception", throwable1);
            b crashreport = null;
            crashreport = throwable1 instanceof e ? this.b(((e)throwable1).a()) : this.b(new b("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.y(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.a(file1)) {
                k.error("This crash report has been saved to: " + file1.getAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
        }
        finally {
            try {
                this.x = true;
                this.t();
            }
            catch (Throwable throwable) {
                k.error("Exception stopping the server", throwable);
            }
            finally {
                this.z();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(js response) {
        File file1 = this.d("server-icon.png");
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuf bytebuf1 = Base64.encode((ByteBuf)bytebuf);
                response.a("data:image/png;base64," + bytebuf1.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    public File y() {
        return new File(".");
    }

    protected void a(b report) {
    }

    protected void z() {
    }

    public void A() {
        long i2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.B();
        if (i2 - this.X >= 5000000000L) {
            this.X = i2;
            this.r.a(new js.a(this.J(), this.I()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.I(), 12)];
            int j2 = ns.a(this.s, 0, this.I() - agameprofile.length);
            for (int k2 = 0; k2 < agameprofile.length; ++k2) {
                agameprofile[k2] = this.v.v().get(j2 + k2).cd();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.r.b().a(agameprofile);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - i2;
        this.c.b();
        this.c.a("snooper");
        if (!this.n.d() && this.y > 100) {
            this.n.a();
        }
        if (this.y % 6000 == 0) {
            this.n.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void B() {
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                g.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (int j2 = 0; j2 < this.d.length; ++j2) {
            long i2 = System.nanoTime();
            if (j2 == 0 || this.C()) {
                le worldserver = this.d[j2];
                this.c.a(worldserver.P().k());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new hu(worldserver.K(), worldserver.L(), worldserver.Q().b("doDaylightCycle")), worldserver.t.q());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    worldserver.c();
                }
                catch (Throwable throwable1) {
                    b crashreport = b.a(throwable1, "Exception ticking world");
                    worldserver.a(crashreport);
                    throw new e(crashreport);
                }
                try {
                    worldserver.i();
                }
                catch (Throwable throwable) {
                    b crashreport1 = b.a(throwable, "Exception ticking world entities");
                    worldserver.a(crashreport1);
                    throw new e(crashreport1);
                }
                this.c.b();
                this.c.a("tracker");
                worldserver.s().a();
                this.c.b();
                this.c.b();
            }
            this.i[j2][this.y % 100] = System.nanoTime() - i2;
        }
        this.c.c("connection");
        this.aq().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (int k2 = 0; k2 < this.p.size(); ++k2) {
            this.p.get(k2).c();
        }
        this.c.b();
    }

    public boolean C() {
        return true;
    }

    public void D() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String fileName) {
        return new File(this.y(), fileName);
    }

    public void f(String msg) {
        k.warn(msg);
    }

    public le a(int dimension) {
        return dimension == -1 ? this.d[1] : (dimension == 1 ? this.d[2] : this.d[0]);
    }

    public String H() {
        return "1.8.9";
    }

    public int I() {
        return this.v.o();
    }

    public int J() {
        return this.v.p();
    }

    public String[] K() {
        return this.v.f();
    }

    public GameProfile[] L() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b report) {
        report.g().a("Profiler Position", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }
        });
        if (this.v != null) {
            report.g().a("Player Count", new Callable<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }
            });
        }
        return report;
    }

    public List<String> a(m sender, String input, cj pos) {
        ArrayList list = Lists.newArrayList();
        if (input.startsWith("/")) {
            boolean flag = !(input = input.substring(1)).contains(" ");
            List<String> list1 = this.b.a(sender, input, pos);
            if (list1 != null) {
                for (String s2 : list1) {
                    if (flag) {
                        list.add("/" + s2);
                        continue;
                    }
                    list.add(s2);
                }
            }
            return list;
        }
        String[] astring = input.split(" ", -1);
        String s2 = astring[astring.length - 1];
        for (String s1 : this.v.f()) {
            if (!i.a(s2, s1)) continue;
            list.add(s1);
        }
        return list;
    }

    public static MinecraftServer N() {
        return l;
    }

    public boolean O() {
        return this.o != null;
    }

    @Override
    public String e_() {
        return "Server";
    }

    @Override
    public void a(eu component) {
        k.info(component.c());
    }

    @Override
    public boolean a(int permLevel, String commandName) {
        return true;
    }

    public l P() {
        return this.b;
    }

    public KeyPair Q() {
        return this.H;
    }

    public String S() {
        return this.I;
    }

    public void i(String owner) {
        this.I = owner;
    }

    public boolean T() {
        return this.I != null;
    }

    public String U() {
        return this.J;
    }

    public void j(String name) {
        this.J = name;
    }

    public void k(String p_71246_1_) {
        this.K = p_71246_1_;
    }

    public String V() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(oj difficulty) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            le world = this.d[i2];
            if (world == null) continue;
            if (world.P().t()) {
                world.P().a(oj.d);
                world.a(true, true);
                continue;
            }
            if (this.T()) {
                world.P().a(difficulty);
                world.a(world.aa() != oj.a, true);
                continue;
            }
            world.P().a(difficulty);
            world.a(this.W(), this.A);
        }
    }

    protected boolean W() {
        return true;
    }

    public boolean X() {
        return this.L;
    }

    public void b(boolean demo) {
        this.L = demo;
    }

    public void c(boolean enable) {
        this.M = enable;
    }

    public atr Y() {
        return this.m;
    }

    public void aa() {
        this.N = true;
        this.Y().d();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            le worldserver = this.d[i2];
            if (worldserver == null) continue;
            worldserver.o();
        }
        this.Y().e(this.d[0].O().g());
        this.w();
    }

    public String ab() {
        return this.O;
    }

    public String ac() {
        return this.P;
    }

    public void a_(String url, String hash) {
        this.O = url;
        this.P = hash;
    }

    @Override
    public void a(or playerSnooper) {
        playerSnooper.a("whitelist_enabled", false);
        playerSnooper.a("whitelist_count", 0);
        if (this.v != null) {
            playerSnooper.a("players_current", this.I());
            playerSnooper.a("players_max", this.J());
            playerSnooper.a("players_seen", this.v.q().length);
        }
        playerSnooper.a("uses_auth", this.z);
        playerSnooper.a("gui_state", this.as() ? "enabled" : "disabled");
        playerSnooper.a("run_time", (MinecraftServer.az() - playerSnooper.g()) / 60L * 1000L);
        playerSnooper.a("avg_tick_ms", (int)(ns.a(this.h) * 1.0E-6));
        int i2 = 0;
        if (this.d != null) {
            for (int j2 = 0; j2 < this.d.length; ++j2) {
                if (this.d[j2] == null) continue;
                le worldserver = this.d[j2];
                ato worldinfo = worldserver.P();
                playerSnooper.a("world[" + i2 + "][dimension]", worldserver.t.q());
                playerSnooper.a("world[" + i2 + "][mode]", (Object)worldinfo.r());
                playerSnooper.a("world[" + i2 + "][difficulty]", (Object)worldserver.aa());
                playerSnooper.a("world[" + i2 + "][hardcore]", worldinfo.t());
                playerSnooper.a("world[" + i2 + "][generator_name]", worldinfo.u().a());
                playerSnooper.a("world[" + i2 + "][generator_version]", worldinfo.u().d());
                playerSnooper.a("world[" + i2 + "][height]", this.F);
                playerSnooper.a("world[" + i2 + "][chunks_loaded]", worldserver.N().g());
                ++i2;
            }
        }
        playerSnooper.a("worlds", i2);
    }

    @Override
    public void b(or playerSnooper) {
        playerSnooper.b("singleplayer", this.T());
        playerSnooper.b("server_brand", this.getServerModName());
        playerSnooper.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        playerSnooper.b("dedicated", this.ae());
    }

    @Override
    public boolean ad() {
        return true;
    }

    public abstract boolean ae();

    public boolean af() {
        return this.z;
    }

    public void d(boolean online) {
        this.z = online;
    }

    public boolean ag() {
        return this.A;
    }

    public void e(boolean spawnAnimals) {
        this.A = spawnAnimals;
    }

    public boolean ah() {
        return this.B;
    }

    public abstract boolean ai();

    public void f(boolean spawnNpcs) {
        this.B = spawnNpcs;
    }

    public boolean aj() {
        return this.C;
    }

    public void g(boolean allowPvp) {
        this.C = allowPvp;
    }

    public boolean ak() {
        return this.D;
    }

    public void h(boolean allow) {
        this.D = allow;
    }

    public abstract boolean al();

    public String am() {
        return this.E;
    }

    public void l(String motdIn) {
        this.E = motdIn;
    }

    public int an() {
        return this.F;
    }

    public void c(int maxBuildHeight) {
        this.F = maxBuildHeight;
    }

    public boolean ao() {
        return this.x;
    }

    public lx ap() {
        return this.v;
    }

    public void a(lx configManager) {
        this.v = configManager;
    }

    public void a(adp.a gameMode) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            MinecraftServer.N().d[i2].P().a(gameMode);
        }
    }

    public ll aq() {
        return this.q;
    }

    public boolean ar() {
        return this.Q;
    }

    public boolean as() {
        return false;
    }

    public abstract String a(adp.a var1, boolean var2);

    public int at() {
        return this.y;
    }

    public void au() {
        this.T = true;
    }

    public or av() {
        return this.n;
    }

    @Override
    public cj c() {
        return cj.a;
    }

    @Override
    public aui d() {
        return new aui(0.0, 0.0, 0.0);
    }

    @Override
    public adm e() {
        return this.d[0];
    }

    @Override
    public pk f() {
        return null;
    }

    public int aw() {
        return 16;
    }

    public boolean a(adm worldIn, cj pos, wn playerIn) {
        return false;
    }

    public boolean ax() {
        return this.U;
    }

    public Proxy ay() {
        return this.e;
    }

    public static long az() {
        return System.currentTimeMillis();
    }

    public int aA() {
        return this.G;
    }

    public void d(int idleTimeout) {
        this.G = idleTimeout;
    }

    @Override
    public eu f_() {
        return new fa(this.e_());
    }

    public boolean aB() {
        return true;
    }

    public MinecraftSessionService aD() {
        return this.W;
    }

    public GameProfileRepository aE() {
        return this.Y;
    }

    public lt aF() {
        return this.Z;
    }

    public js aG() {
        return this.r;
    }

    public void aH() {
        this.X = 0L;
    }

    public pk a(UUID uuid) {
        for (le worldserver : this.d) {
            pk entity;
            if (worldserver == null || (entity = worldserver.a(uuid)) == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    public boolean u_() {
        return MinecraftServer.N().d[0].Q().b("sendCommandFeedback");
    }

    @Override
    public void a(n.a type, int amount) {
    }

    public int aI() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable) {
        Validate.notNull(callable);
        if (!this.aJ() && !this.ao()) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callable);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenablefuturetask);
                return listenablefuturetask;
            }
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return this.a(Executors.callable(runnableToSchedule));
    }

    @Override
    public boolean aJ() {
        return Thread.currentThread() == this.aa;
    }

    public int aK() {
        return 256;
    }
}

