#pragma once
#include "StationSearchWindow.h"
#include <Window.h>
#include <Button.h>
#include <CheckBox.h>
#include <ListView.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <FilePanel.h>
#include <app/MessageRunner.h>
#include <ScrollView.h>
#include <Slider.h>
#include <media/SoundPlayer.h>
#include <StringView.h>
#include <TextControl.h>
#include <View.h>

#include <atomic>
#include <mutex>
#include <string>
#include <thread>
#include <vector>

#include "PandoraAPI.h"
#include "WinampSkin.h"

static constexpr uint32 MSG_LOAD_SKIN      = 'Skin';
static constexpr uint32 MSG_CLEAR_SKIN     = 'SkCl';
static constexpr uint32 MSG_SKIN_DOUBLE_SZ = 'Sk2x';
static constexpr uint32 MSG_SKIN_SMOOTH    = 'SkSm';
#include "SkinWindow.h"

// Msg consts
enum {
    MSG_LOGIN           = 'Lgin',
    MSG_LOGOUT          = 'Lgot',
    MSG_AUTH_DONE       = 'Auth',
    MSG_STATION_SELECT  = 'Stnx',
    MSG_STATIONS_LOADED = 'StLd',
    MSG_PLAYLIST_LOADED = 'PlLd',
    MSG_DECODE_DONE     = 'Dcod',
    MSG_PLAY_PAUSE      = 'PlPs',
    MSG_NEXT            = 'Next',
    MSG_THUMB_UP        = 'ThUp',
    MSG_THUMB_DOWN      = 'ThDn',
    MSG_TIRED           = 'Tire',
    MSG_VOLUME          = 'Volm',
    MSG_TICK            = 'Tick',
    MSG_ART_LOADED      = 'ArtL',
    MSG_ERROR           = 'Err_',
    MSG_SKIN_LOADED     = 'SkLd',
    MSG_DUMMY_LAST_     = 0
};

struct TrackInfo {
    std::string songName, artistName, albumName;
    std::string albumArtUrl, audioUrl, trackToken;
    int         rating       = 0;
    int         durationSecs = 0;
    bool        allowSkip    = true;
};

class LoginView;
class NowPlayingView;

class MainWindow : public BWindow {
public:
                 MainWindow();
                ~MainWindow() override;
    bool         QuitRequested() override;
    void         MessageReceived(BMessage*) override;

private:
    // UI
    void         BuildUI();
    void         ShowLogin();
    void         ShowPlayer();
    void         SetStatus(const char*);

    // Async API calls (fire-and-forget threads → PostMessage back)
    void         AsyncLogin(const std::string& email, const std::string& pass);
    void         AsyncGetStations();
    void         AsyncGetPlaylist(const std::string& token);
    void         AsyncFeedback(const std::string& token, bool up, bool tired);
    void         AsyncLoadArt(const std::string& url);

    // Playback
    void         StartNextTrack();   // picks from queue, starts decode thread
    void         BeginPlayback();    // called after MSG_DECODE_DONE
    void         StopPlayback();

    LoginView*      fLoginView;
    BView*          fPlayerView;
    NowPlayingView* fNowPlaying;
    BListView*      fStationList;
    BStringView*    fStatusBar;
    BButton*        fPlayPauseBtn;
    BButton*        fNextBtn;
    BButton*        fThumbUpBtn;
    BButton*        fThumbDownBtn;
    BButton*        fTiredBtn;
    BSlider*        fProgress;
    BSlider*        fVolume;
    BStringView*    fTimeLabel;

    // State
    PandoraAPI                  fAPI;
    std::vector<PandoraStation> fStations;
    std::vector<TrackInfo>      fQueue;
    std::mutex                  fQueueMtx;
    std::string                 fCurrentStation;
    TrackInfo                   fCurrent;

    // Audio
    BSoundPlayer*               fSoundPlayer;
    std::thread                 fDecodeThread;
    std::atomic<bool>           fDecodeRunning;
    std::atomic<bool>           fPlaying;
    std::atomic<bool>           fPaused;
    std::atomic<int>            fElapsed;      // seconds
    BMessageRunner*             fTickRunner;

    // Skin
    void         LoadSkin(const char* path);
    void         ClearSkin();
    void         UpdateSkinView();
    void         SyncSkinState();

    WinampSkin      fSkin;
    SkinWindow*     fSkinWindow;
    PlaylistWindow* fPlaylistWindow;
    EqWindow*       fEqWindow;
    SkinDock        fDock;
    int             fSkinScale  = 1;
    bool            fSkinSmooth = false;
    BFilePanel*     fSkinPanel;
};
