/*++

Copyright (c) 1995  Digital Equipment Corporation

Module Name:

    setjmp.h

Abstract:

    This header defines the jmp_buf, and declares the setjmp() and
    longjmp() functions used to bypass the normal function call
    discipine.

Author:

    Dave Richards [DEC] 7-Sep-95

Revision History:

--*/

#ifndef _SETJMP_H_
#define _SETJMP_H_

#ifdef _LANGUAGE_ASSEMBLY

#define jb_s0   0x00
#define jb_s1   0x08
#define jb_s2   0x10
#define jb_s3   0x18
#define jb_s4   0x20
#define jb_s5   0x28

#define jb_f2   0x30
#define jb_f3   0x38
#define jb_f4   0x40
#define jb_f5   0x48
#define jb_f6   0x50
#define jb_f7   0x58
#define jb_f8   0x60
#define jb_f9   0x68

#define jb_fp   0x70
#define jb_sp   0x78
#define jb_ra   0x80

#else

typedef double jmp_buf[17];

int setjmp(jmp_buf);
void longjmp(jmp_buf, int);

#endif

#endif
