/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.core;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import portalgun.common.PortalGun;
import portalgun.common.packet.PacketWorldProps;

public class Settings {
    public static Map map = new HashMap();
    public static Map<String, String> mapInfo = new HashMap<String, String>();
    public static Map<Integer, String> lootOptions = new HashMap<Integer, String>();
    public static Map<Integer, int[]> modBlockIds = new HashMap<Integer, int[]>();
    public static Map<Integer, int[]> grabBlockIds = new HashMap<Integer, int[]>();
    public static Map<Integer, int[]> portalBlockIds = new HashMap<Integer, int[]>();
    public static String[] clientOnly;
    public static String[] settingsGlobal;
    public static String[] settingsMap;
    public static ArrayList<Class> turretExceptions;
    public static ArrayList<String> failedSettings;
    public static ArrayList<Integer> enabledChestLoot;
    public static boolean firstMapLoad;

    public static void setInt(String s, int i) {
        map.put(s, i);
    }

    public static void setBlockIdsToMap(Map map, String s, boolean clear) {
        if (clear) {
            map.clear();
        }
        if (s.equalsIgnoreCase("")) {
            return;
        }
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            int[] list = new int[split.length];
            for (int i1 = 0; i1 < split.length; ++i1) {
                String[] split1 = split[i1].split(": *");
                if (split1.length <= 0 || split1[0].equalsIgnoreCase("")) continue;
                if (split1.length == 1) {
                    try {
                        if (Integer.parseInt(split1[0].trim()) == 0) continue;
                        map.put(Integer.parseInt(split1[0].trim()), new int[]{-1});
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (split1[1].equalsIgnoreCase("null")) {
                    try {
                        if (Integer.parseInt(split1[0].trim()) == 0) continue;
                        map.remove(Integer.parseInt(split1[0].trim()));
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                int[] list1 = new int[split1.length - 1];
                for (int j = 1; j < split1.length; ++j) {
                    try {
                        list1[j - 1] = Integer.parseInt(split1[j].trim());
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    map.put(Integer.parseInt(split1[0].trim()), list1);
                    continue;
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void setTurretExceptions(String s1) {
        turretExceptions.clear();
        String[] split = s1.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            for (int i = 0; i < split.length; ++i) {
                try {
                    if (turretExceptions.contains(Class.forName(split[i]))) continue;
                    turretExceptions.add(Class.forName(split[i]));
                    PortalGun.console("Added " + split[i] + " to turret exceptions.");
                    continue;
                }
                catch (Exception e) {
                    PortalGun.console("Failed to add " + split[i] + " to turret exceptions.");
                }
            }
        }
    }

    public static void setDisabledModParts(String s) {
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            int[] list = new int[split.length];
            for (int i1 = 0; i1 < split.length; ++i1) {
                try {
                    list[i1] = Integer.parseInt(split[i1].trim());
                    continue;
                }
                catch (NumberFormatException e1) {
                    PortalGun.console("Error parsing disabled mod part: " + split[i1] + ". If you put a letter, they should be numbers!", true);
                    e1.printStackTrace();
                    list[i1] = 0;
                }
            }
            map.put("modPartsDisabled", list);
        } else {
            map.put("modPartsDisabled", new int[]{-1});
        }
    }

    public static void parseLootOptions(String s) {
        if (s.equalsIgnoreCase("")) {
            return;
        }
        enabledChestLoot.clear();
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            int[] list = new int[split.length];
            for (int i1 = 0; i1 < split.length; ++i1) {
                try {
                    int num = Integer.parseInt(split[i1].trim());
                    if (num == 0 || enabledChestLoot.contains(num)) continue;
                    enabledChestLoot.add(num);
                    continue;
                }
                catch (NumberFormatException e1) {
                    PortalGun.console("Error parsing int value for loot options: " + split[i1], true);
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void mapIntToLootOption() {
        String[] lootList = new String[]{"", "dungeonChest", "bonusChest", "villageBlacksmith", "strongholdCrossing", "strongholdLibrary", "strongholdCorridor", "pyramidJungleDispenser", "pyramidJungleChest", "pyramidDesertyChest", "mineshaftCorridor"};
        for (int i = 0; i < lootList.length; ++i) {
            lootOptions.put(i, lootList[i]);
        }
    }

    public static String getLootOption(int i) {
        String s = lootOptions.get(i);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public static int getSettings(String s) {
        try {
            return Integer.parseInt(map.get(s.trim()).toString());
        }
        catch (NumberFormatException e) {
            if (!failedSettings.contains(s)) {
                PortalGun.console("Failed to read settings [NaN]: " + s);
                failedSettings.add(s);
            }
            return -2;
        }
        catch (NullPointerException e) {
            if (!failedSettings.contains(s)) {
                PortalGun.console("Failed to read settings [Null]: " + s);
                failedSettings.add(s);
            }
            return -2;
        }
    }

    public static int[] getSettingsInt(String s) {
        try {
            int[] setting = (int[])map.get(s);
            if (setting == null) {
                if (!failedSettings.contains(s)) {
                    PortalGun.console("Failed to read settings: " + s);
                    failedSettings.add(s);
                }
                setting = new int[]{};
            }
            return setting;
        }
        catch (NullPointerException e) {
            if (!failedSettings.contains(s)) {
                PortalGun.console("Failed to read settings: " + s);
                failedSettings.add(s);
            }
            int[] empty = new int[]{};
            return empty;
        }
    }

    public static int[] getBlockMetaInMap(Map map, Block i) {
        return (int[])map.get(Block.func_149682_b((Block)i));
    }

    public static boolean isModPartEnabled(int i1) {
        int[] list1 = Settings.getSettingsInt("modPartsDisabled");
        for (int i = 0; i < list1.length; ++i) {
            if (list1[i] != i1 || i1 == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityTurretException(EntityLivingBase ent) {
        for (int i = 0; i < turretExceptions.size(); ++i) {
            if (!turretExceptions.get(i).isInstance(ent)) continue;
            return true;
        }
        return false;
    }

    public static String intArrayToString(int[] list) {
        StringBuilder sb = new StringBuilder();
        for (int i1 = 0; i1 < list.length; ++i1) {
            sb.append(list[i1]);
            if (i1 == list.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getSettingsInfo(String s) {
        try {
            return mapInfo.get(s).trim();
        }
        catch (NullPointerException e) {
            PortalGun.console("Settings has no info mapped: " + s);
            return "";
        }
    }

    public static String getTurretExceptionsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < turretExceptions.size(); ++i) {
            sb.append(turretExceptions.get(i).getName());
            if (i >= turretExceptions.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String mapToString(Map<Integer, int[]> map) {
        StringBuilder sb = new StringBuilder();
        if (!map.isEmpty()) {
            for (Map.Entry<Integer, int[]> e : map.entrySet()) {
                if (!sb.toString().equalsIgnoreCase("")) {
                    sb.append(", ");
                }
                sb.append(e.getKey());
                int[] metaList = e.getValue();
                if (metaList.length != 0 && metaList[0] == -1) continue;
                for (int j = 0; j < metaList.length; ++j) {
                    sb.append(": ").append(metaList[j]);
                }
            }
        } else {
            sb.append(0);
        }
        return sb.toString();
    }

    public static PacketWorldProps getWorldPropsAsPacket() {
        return new PacketWorldProps();
    }

    public static int addCommentAndReturnInt(Configuration config, String cat, String s, int i) {
        String comment = Settings.getSettingsInfo(s);
        Property prop = config.get(cat, s, i);
        if (!firstMapLoad) {
            prop.set(Integer.toString(Settings.getSettings(s)));
        }
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getInt();
    }

    public static int addCommentAndReturnInt(Configuration config, String cat, String s, String value) {
        String comment = Settings.getSettingsInfo(s);
        Property prop = config.get(cat, s, value);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        int val = 0xFFFFFF;
        try {
            val = Integer.decode(prop.getString());
        }
        catch (NumberFormatException e) {
            PortalGun.console("Cannot decode colour index: " + s);
            e.printStackTrace();
        }
        return val;
    }

    public static String addCommentAndReturnString(Configuration config, String cat, String s, String value) {
        String comment = Settings.getSettingsInfo(s);
        Property prop = config.get(cat, s, value);
        if (!firstMapLoad) {
            if (s.equalsIgnoreCase("portalListIDs")) {
                prop.set(Settings.mapToString(portalBlockIds));
            } else if (s.equalsIgnoreCase("grabBlockListIDs")) {
                prop.set(Settings.mapToString(grabBlockIds));
            } else if (s.equalsIgnoreCase("turretExceptions")) {
                prop.set(Settings.getTurretExceptionsString());
            }
        }
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public static void handlePortalGunRecipe(boolean easyMode) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = recipes.size() - 1; i >= 0; --i) {
            if (!(recipes.get(i) instanceof ShapedRecipes)) continue;
            ShapedRecipes recipe = (ShapedRecipes)recipes.get(i);
            if (recipe.func_77571_b().func_77969_a(new ItemStack(PortalGun.itemPGBlue, 1, 0))) {
                recipes.remove(i);
            }
            if (!recipe.func_77571_b().func_77969_a(new ItemStack(PortalGun.itemPortalSpawner, 2))) continue;
            recipes.remove(i);
        }
        ItemStack is = new ItemStack(PortalGun.itemPortalSpawner, 2);
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            is.func_77982_d(tag);
        }
        tag.func_74757_a("closeWhenNoRedstone", false);
        tag.func_74778_a("owner", "def");
        tag.func_74768_a("colour", 1);
        if (PortalGun.getSettings("hardModePortalGun") != 1) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(PortalGun.itemPGBlue, 1, 0), (Object[])new Object[]{"X##", "DC#", "#X#", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('X'), Blocks.field_150343_Z, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('C'), easyMode ? Items.field_151079_bi : PortalGun.itemMiniBlackHole});
            GameRegistry.addRecipe((ItemStack)is, (Object[])new Object[]{"# #", "DRD", "# #", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('R'), PortalGun.itemMiniBlackHole, Character.valueOf('D'), Items.field_151045_i});
        } else {
            for (int i = 0; i < enabledChestLoot.size(); ++i) {
                String s = Settings.getLootOption(enabledChestLoot.get(i));
                if (s.equalsIgnoreCase("")) continue;
                ChestGenHooks.getInfo((String)s).removeItem(new ItemStack(PortalGun.itemPGBlue, 1, Short.MAX_VALUE));
                ChestGenHooks.getInfo((String)s).removeItem(new ItemStack(PortalGun.itemPortalSpawner, 1, Short.MAX_VALUE));
            }
            GameRegistry.addRecipe((ItemStack)is, (Object[])new Object[]{"# #", "DRD", "# #", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('R'), new ItemStack(PortalGun.itemPGBlue, 1, 0), Character.valueOf('D'), Items.field_151045_i});
        }
    }

    public static void handleLFBRecipe(boolean easyMode) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = recipes.size() - 1; i >= 0; --i) {
            ShapedRecipes recipe;
            if (!(recipes.get(i) instanceof ShapedRecipes) || !(recipe = (ShapedRecipes)recipes.get(i)).func_77571_b().func_77969_a(new ItemStack(PortalGun.itemLFB, 1))) continue;
            recipes.remove(i);
            break;
        }
        if (easyMode) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(PortalGun.itemLFB, 1), (Object[])new Object[]{"# #", "#O#", "#O#", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('O'), Blocks.field_150343_Z});
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack(PortalGun.itemLFB, 1), (Object[])new Object[]{"#O#", "#D#", "#D#", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('D'), Items.field_151045_i});
        }
    }

    public static void loadProperties(boolean isClient, boolean isMap, File dir) {
        Settings.loadProperties(isClient, isMap, dir, true);
    }

    public static void loadProperties(boolean isClient, boolean isMap, File dir, boolean firstLoad) {
        File file = new File(dir, isMap ? "PortalGun_world.cfg" : "PortalGun.cfg");
        if (file.exists()) {
            PortalGun.console("Loading " + (isMap ? "world " : "") + "properties.");
        } else {
            PortalGun.console((isMap ? "World c" : "C") + "onfig does not exist, generating.");
        }
        Configuration config = new Configuration(file);
        config.load();
        settingsMap = new String[]{"canShootPortalsThroughGlass", "autoMergeGuns", "canEditSpawners", "portalWhitelist", "portalRange", "hardModePortalGun", "enableMoonPortals", "moonPortalGrabsPlayers", "moonPortalGrabsBlocks", "moonPortalUsesGrabList", "moonPortalRange", "grabablePlayers", "grabBlockMode", "grabEntityMode", "grabBlockWhitelist", "grabChestTypeAllowed", "customFuel", "customFuelId", "customFuelMetadata", "customFuelAmount", "potatosSpeech", "potatosSpeechCooldown", "apgSingleUse", "apgDrops", "apgIsInvincible", "apgGiveMode", "cubeIsInvincible", "cubeBreaksGlassPanes", "radioIsInvincible", "radioCanBeTurnedOff", "differentChance", "turretRange", "turretDamage", "turretIsInvincible", "turretExplosionMag", "turretSeesThroughPortals", "turretSeesThroughGlass", "turretMode", "turretDrops", "turretBulletsBreakGlass", "turretIgnoresOwner", "turretIgnoresInvisibleTargets", "serenadeWhenSeen", "serenadeRange", "hepMode", "hepCanBeReleased", "afpCanBeEdited", "afpLocksKeys"};
        if (isMap) {
            firstMapLoad = firstLoad;
            String cat = "portalgun";
            config.addCustomCategoryComment(cat, "Portalgun options.\nCan be changed in-game.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("canShootPortalsThroughGlass", Settings.addCommentAndReturnInt(config, cat, "canShootPortalsThroughGlass", 0));
            Settings.setInt("autoMergeGuns", Settings.addCommentAndReturnInt(config, cat, "autoMergeGuns", 2));
            Settings.setInt("canEditSpawners", Settings.addCommentAndReturnInt(config, cat, "canEditSpawners", 1));
            Settings.setInt("canResetPortals", Settings.addCommentAndReturnInt(config, cat, "canResetPortals", 1));
            Settings.setInt("portalWhitelist", Settings.addCommentAndReturnInt(config, cat, "portalWhitelist", 0));
            Settings.setInt("portalRange", Settings.addCommentAndReturnInt(config, cat, "portalRange", 10000));
            Settings.setInt("hardModePortalGun", Settings.addCommentAndReturnInt(config, cat, "hardModePortalGun", 0));
            Settings.setBlockIdsToMap(portalBlockIds, Settings.addCommentAndReturnString(config, cat, "portalListIDs", ""), true);
            cat = "portalgun.moonportals";
            config.addCustomCategoryComment(cat, "Moon Portal options.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("enableMoonPortals", Settings.addCommentAndReturnInt(config, cat, "enableMoonPortals", 1));
            Settings.setInt("moonPortalGrabsPlayers", Settings.addCommentAndReturnInt(config, cat, "moonPortalGrabsPlayers", 2));
            Settings.setInt("moonPortalGrabsBlocks", Settings.addCommentAndReturnInt(config, cat, "moonPortalGrabsBlocks", 1));
            Settings.setInt("moonPortalUsesGrabList", Settings.addCommentAndReturnInt(config, cat, "moonPortalUsesGrabList", 0));
            Settings.setInt("moonPortalRange", Settings.addCommentAndReturnInt(config, cat, "moonPortalRange", 8));
            cat = "portalgun.graboptions";
            config.addCustomCategoryComment(cat, "Portalgun grabbing options.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("grabablePlayers", Settings.addCommentAndReturnInt(config, cat, "grabablePlayers", 0));
            Settings.setInt("grabBlockMode", Settings.addCommentAndReturnInt(config, cat, "grabBlockMode", 1));
            Settings.setInt("grabEntityMode", Settings.addCommentAndReturnInt(config, cat, "grabEntityMode", 1));
            Settings.setInt("grabBlockWhitelist", Settings.addCommentAndReturnInt(config, cat, "grabBlockWhitelist", 0));
            Settings.setInt("grabChestTypeAllowed", Settings.addCommentAndReturnInt(config, cat, "grabChestTypeAllowed", 1));
            Settings.setBlockIdsToMap(grabBlockIds, Settings.addCommentAndReturnString(config, cat, "grabBlockListIDs", ""), true);
            cat = "portalgun.fuel";
            config.addCustomCategoryComment(cat, "Portalgun fuel options (If enabled).\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("customFuel", Settings.addCommentAndReturnInt(config, cat, "customFuel", 0));
            Settings.setInt("customFuelId", Settings.addCommentAndReturnInt(config, cat, "customFuelId", 0));
            Settings.setInt("customFuelMetadata", Settings.addCommentAndReturnInt(config, cat, "customFuelMetadata", 0));
            Settings.setInt("customFuelAmount", Settings.addCommentAndReturnInt(config, cat, "customFuelAmount", 1));
            cat = "portalgun.potatogun";
            config.addCustomCategoryComment(cat, "Potatogun options.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("potatosSpeech", Settings.addCommentAndReturnInt(config, cat, "potatosSpeech", 1));
            Settings.setInt("potatosSpeechCooldown", Settings.addCommentAndReturnInt(config, cat, "potatosSpeechCooldown", 900));
            cat = "portalgun.pedestal";
            config.addCustomCategoryComment(cat, "PortalGun pedestal options\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("apgSingleUse", Settings.addCommentAndReturnInt(config, cat, "apgSingleUse", 0));
            Settings.setInt("apgDrops", Settings.addCommentAndReturnInt(config, cat, "apgDrops", 1));
            Settings.setInt("apgIsInvincible", Settings.addCommentAndReturnInt(config, cat, "apgIsInvincible", 0));
            Settings.setInt("apgGiveMode", Settings.addCommentAndReturnInt(config, cat, "apgGiveMode", 2));
            cat = "weightedcubes";
            config.addCustomCategoryComment(cat, "Weighted cube Mod Part options.\nThis also includes the redirection cube from TDBs\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("cubeIsInvincible", Settings.addCommentAndReturnInt(config, cat, "cubeIsInvincible", 0));
            Settings.setInt("cubeBreaksGlassPanes", Settings.addCommentAndReturnInt(config, cat, "cubeBreaksGlassPanes", 1));
            Settings.setInt("radioIsInvincible", Settings.addCommentAndReturnInt(config, cat, "radioIsInvincible", 0));
            Settings.setInt("radioCanBeTurnedOff", Settings.addCommentAndReturnInt(config, cat, "radioCanBeTurnedOff", 1));
            cat = "turrets";
            config.addCustomCategoryComment(cat, "Sentry Turret options\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("differentChance", Settings.addCommentAndReturnInt(config, cat, "differentChance", 20));
            Settings.setInt("turretRange", Settings.addCommentAndReturnInt(config, cat, "turretRange", 20));
            Settings.setInt("turretDamage", Settings.addCommentAndReturnInt(config, cat, "turretDamage", 2));
            Settings.setInt("turretIsInvincible", Settings.addCommentAndReturnInt(config, cat, "turretIsInvincible", 0));
            Settings.setInt("turretExplosionMag", Settings.addCommentAndReturnInt(config, cat, "turretExplosionMag", 15));
            Settings.setInt("turretSeesThroughPortals", Settings.addCommentAndReturnInt(config, cat, "turretSeesThroughPortals", 1));
            Settings.setInt("turretSeesThroughGlass", Settings.addCommentAndReturnInt(config, cat, "turretSeesThroughGlass", 0));
            Settings.setInt("turretMode", Settings.addCommentAndReturnInt(config, cat, "turretMode", 1));
            Settings.setInt("turretDrops", Settings.addCommentAndReturnInt(config, cat, "turretDrops", 1));
            Settings.setInt("turretBulletsBreakGlass", Settings.addCommentAndReturnInt(config, cat, "turretBulletsBreakGlass", 1));
            Settings.setInt("turretIgnoresOwner", Settings.addCommentAndReturnInt(config, cat, "turretIgnoresOwner", 1));
            Settings.setInt("turretIgnoresInvisibleTargets", Settings.addCommentAndReturnInt(config, cat, "turretIgnoresInvisibleTargets", 0));
            Settings.setInt("serenadeWhenSeen", Settings.addCommentAndReturnInt(config, cat, "serenadeWhenSeen", 0));
            Settings.setInt("serenadeRange", Settings.addCommentAndReturnInt(config, cat, "serenadeRange", 64));
            Settings.setTurretExceptions(Settings.addCommentAndReturnString(config, cat, "turretExceptions", ""));
            cat = "highenergypellet";
            config.addCustomCategoryComment(cat, "High Energy Pellet options\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("hepMode", Settings.addCommentAndReturnInt(config, cat, "hepMode", 1));
            Settings.setInt("hepCanBeReleased", Settings.addCommentAndReturnInt(config, cat, "hepCanBeReleased", 1));
            cat = "aerialfaithplates";
            config.addCustomCategoryComment(cat, "Aerial Faith Plate options\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("afpCanBeEdited", Settings.addCommentAndReturnInt(config, cat, "afpCanBeEdited", 1));
            Settings.setInt("afpLocksKeys", Settings.addCommentAndReturnInt(config, cat, "afpLocksKeys", 0));
            Settings.handlePortalGunRecipe(Settings.getSettings("recipeEasyPortalGun") == 1);
            Settings.handleLFBRecipe(Settings.getSettings("recipeEasyLongFallBoots") == 1);
        } else {
            String cat;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            map.put("modPartsDisabled", new int[]{-1});
            if (isClient) {
                cat = "client.clientspecific";
                config.addCustomCategoryComment(cat, "These settings only affect the client which loads it.\n\nFor Booleans\n   1 means Yes\n   0 means No");
                Settings.setInt("enableSounds", Settings.addCommentAndReturnInt(config, cat, "enableSounds", 1));
                Settings.setInt("portalGunModel", Settings.addCommentAndReturnInt(config, cat, "portalGunModel", 1));
                Settings.setInt("equipPortalGunSound", Settings.addCommentAndReturnInt(config, cat, "equipPortalGunSound", 1));
                Settings.setInt("christmasPotatOS", Settings.addCommentAndReturnInt(config, cat, "christmasPotatOS", calendar.get(2) + 1 == 12 ? 1 : 0));
                Settings.setInt("customBaconGunColour", Settings.addCommentAndReturnInt(config, cat, "customBaconGunColour", 0));
                Settings.setInt("customPotatoGunColour", Settings.addCommentAndReturnInt(config, cat, "customPotatoGunColour", 0));
                Settings.setInt("colourBaconGun1", Settings.addCommentAndReturnInt(config, cat, "colourBaconGun1", "#ffffff"));
                Settings.setInt("colourBaconGun2", Settings.addCommentAndReturnInt(config, cat, "colourBaconGun2", "#ffffff"));
                Settings.setInt("colourPotatoGun1", Settings.addCommentAndReturnInt(config, cat, "colourPotatoGun1", "#ffffff"));
                Settings.setInt("colourPotatoGun2", Settings.addCommentAndReturnInt(config, cat, "colourPotatoGun2", "#ffffff"));
                Settings.setInt("renderTurretLaser", Settings.addCommentAndReturnInt(config, cat, "renderTurretLaser", 1));
                cat = "client.keybinds";
                config.addCustomCategoryComment(cat, "These settings are keybindings for the mod.\nMouse binds are possible, starting from -100 and higher.\nFor info on Key codes, check here: http://www.minecraftwiki.net/wiki/Key_codes");
                Settings.setInt("shootBluePortalKey", Settings.addCommentAndReturnInt(config, cat, "shootBluePortalKey", -100));
                Settings.setInt("shootOrangePortalKey", Settings.addCommentAndReturnInt(config, cat, "shootOrangePortalKey", -99));
                Settings.setInt("zoomKey", Settings.addCommentAndReturnInt(config, cat, "zoomKey", -98));
                Settings.setInt("resetPortalsKey", Settings.addCommentAndReturnInt(config, cat, "resetPortalsKey", 19));
                Settings.setInt("grabKey", Settings.addCommentAndReturnInt(config, cat, "grabKey", 34));
                cat = "client.others";
                if (PortalGun.isChristmas || PortalGun.isAFDay) {
                    Settings.setInt("easterEgg", Settings.addCommentAndReturnInt(config, cat, "easterEgg", 1));
                }
            }
            cat = "general";
            config.addCustomCategoryComment(cat, "General settings for the mod.");
            Settings.setDisabledModParts(Settings.addCommentAndReturnString(config, cat, "modPartsDisabled", "-1"));
            Settings.setInt("recipeEasyPortalGun", Settings.addCommentAndReturnInt(config, cat, "recipeEasyPortalGun", 0));
            Settings.setInt("recipeEasyLongFallBoots", Settings.addCommentAndReturnInt(config, cat, "recipeEasyLongFallBoots", 0));
            cat = "portalgun";
            config.addCustomCategoryComment(cat, "Portalgun options.\nThese cannot be changed in-game. Look in the world folder for many more options.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("portalGunFuel", Settings.addCommentAndReturnInt(config, cat, "portalGunFuel", 0));
            Settings.setInt("dustMaceration", Settings.addCommentAndReturnInt(config, cat, "dustMaceration", 1));
            cat = "chestloot";
            config.addCustomCategoryComment(cat, "Chest Loot options.\nChanges will only take effect on newly generated loot chests.\n\nFor Booleans\n   1 means Yes\n   0 means No");
            Settings.setInt("enableLootPortalGun", Settings.addCommentAndReturnInt(config, cat, "enableLootPortalGun", 1));
            Settings.setInt("enableLootPortalSpawner", Settings.addCommentAndReturnInt(config, cat, "enableLootPortalSpawner", 1));
            Settings.setInt("enableLootDust", Settings.addCommentAndReturnInt(config, cat, "enableLootDust", 1));
            Settings.setInt("enableLootFizzler", Settings.addCommentAndReturnInt(config, cat, "enableLootFizzler", 1));
            Settings.setInt("lootRarityPortalGun", Settings.addCommentAndReturnInt(config, cat, "lootRarityPortalGun", 2));
            Settings.setInt("lootRarityPortalSpawner", Settings.addCommentAndReturnInt(config, cat, "lootRarityPortalSpawner", 2));
            Settings.setInt("lootRarityDust", Settings.addCommentAndReturnInt(config, cat, "lootRarityDust", 10));
            Settings.setInt("lootRarityFizzler", Settings.addCommentAndReturnInt(config, cat, "lootRarityFizzler", 2));
            Settings.parseLootOptions(Settings.addCommentAndReturnString(config, cat, "enabledLootOptions", "1"));
            Settings.mapIntToLootOption();
        }
        config.save();
    }

    private static void mapInfo() {
        mapInfo.put("grabablePlayers", "Can players be grabbed by the portalgun?\n0 = No\n1 = Yes\n2 = Yes, but not command executers.");
        mapInfo.put("grabBlockMode", "Block grabbing mode (How a grabbed block turns into a block again)\n1 = Blocks snap to surroundings\n2 = Blocks fall to the ground\n3 = Blocks float when released");
        mapInfo.put("grabEntityMode", "Entity grabbing mode\n1 = Most entities\n2 = Living entities and Portal entities only\n3 = Portal entities only");
        mapInfo.put("grabBlockWhitelist", "Boolean:\nBlock grabbing whitelist enabled?");
        mapInfo.put("grabBlockListIDs", "Block grabbing black/whitelist IDs + metadata\nFormat: id: meta: meta, id: meta, id, id ...\nExample: You don't want ID 1, 2, 3 and 4 to be grabbed, but only metadata 5 and 7 for ID 1, and only metadata 9 for ID 2.\nExample: grabBlockListIDs = 1: 5: 7, 2: 9, 3, 4\nIf you need a more proper explanation visit: http://www.minecraftforum.net/topic/199391-/page__view__findpost__p__13392100");
        mapInfo.put("grabChestTypeAllowed", "Boolean:\nAllow grabbing of chest-like blocks (Render ID 22)?\nWarning! I am not responsible for any loss of items due to invalid block placement, griefing, etc.");
        mapInfo.put("portalListIDs", "Portal placement black/whitelist IDs\nFormat: Refer block grabbing black/whitelist IDs + metadata above.");
        mapInfo.put("portalRange", "Range of which you can shoot portals.\nRounded off to nearest 5.");
        mapInfo.put("enableSounds", "Boolean:\nEnable mod sounds?");
        mapInfo.put("portalGunModel", "Boolean:\nUse the 3D model for the portalgun?");
        mapInfo.put("equipPortalGunSound", "Boolean:\nDoes the a sound play when you equip the portal gun?");
        mapInfo.put("customBaconGunColour", "Boolean:\nDoes the bacon gun's portals have a custom colour?");
        mapInfo.put("customPotatoGunColour", "Boolean:\nDoes the potato gun's portals have a custom colour?");
        mapInfo.put("colourBaconGun1", "colour(Bacon/Potato)GunX\nCustom bacon gun colour indexes (Google \"hex color codes\" if you don't understand)\nFormat: #<colour index> or 0x<colour index>\nEg: #ffffff or 0xffffff for white");
        mapInfo.put("colourBaconGun2", "");
        mapInfo.put("colourPotatoGun1", "");
        mapInfo.put("colourPotatoGun2", "");
        mapInfo.put("christmasPotatOS", "Boolean:\n'Tis the season to be jolly!");
        mapInfo.put("shootBluePortalKey", "Key to shoot your left portal.\nDef: -100");
        mapInfo.put("shootOrangePortalKey", "Key to shoot your right portal.\nDef: -99");
        mapInfo.put("zoomKey", "Key to zoom in the camera.\nDef: -98");
        mapInfo.put("resetPortalsKey", "Key to reset portals.\nDef: 19");
        mapInfo.put("grabKey", "Key to grab stuff.\nDef: 34");
        mapInfo.put("modPartsDisabled", "Disabled mod parts.\nMod parts in this mod can be disabled to free up Block/Item IDs, etc.\nMore info can be found here:\nhttp://ichun.us/mods/portalgun/mod-content/\n\nBy default, all mod parts are enabled, so this setting is set to -1.\nTo disable parts, list them as so, with letters A, B, C, D representing a number of a mod part:\nEG: A, B, C, D. (They should be numbers!)\nAt this moment, not all of the previous mod content have been added. They will be in the future.\n\n0 = Portals (Including the pedestal)\n1 = Long fall boots\n2 = Weighted Storage Cubes, including the records and the radio.\n3 = Material Emancipation Grid(Not yet implemented)\n4 = Turrets\n5 = Aerial Faith Plates\n6 = High Energy Pellets\n7 = Thermal Discouragement Beams(Not yet implemented)\n8 = Checkpoint Blocks(Not yet implemented)\n9 = Decorative items.");
        mapInfo.put("recipeEasyPortalGun", "Boolean:\nEnable easy Default PortalGun and Portal Spawner recipe?");
        mapInfo.put("recipeEasyLongFallBoots", "Boolean:\nEnable easy Long Fall Boots recipe?");
        mapInfo.put("hardModePortalGun", "Boolean:\nEnable Hard Mode for PortalGun?\nMore info here: http://www.youtube.com/watch?v=gJyslSqrF0c");
        mapInfo.put("idPortal", "Portals");
        mapInfo.put("idMulti", "Almost every other block in the mod.");
        mapInfo.put("itemIdIndex", "Item ID base\nMod items (Excluding records) will start using this ID and increment.\nDefault: 13200");
        mapInfo.put("recordIdIndex", "Record ID base\nMod records will start using this ID and increment.\nDefault: 13400");
        mapInfo.put("portalGunFuel", "Boolean:\nEnable Fuel (ender pearl dust) for the portalgun?\nCustom fuel is possible in the WORLD config.");
        mapInfo.put("portalWhitelist", "Boolean:\nPortal placement whitelist enabled?");
        mapInfo.put("canResetPortals", "Boolean:\nCan the reset key of portal guns be used?");
        mapInfo.put("dustMaceration", "Boolean:\nCan you macerate the ender pearl to get ender pearl dust (For IndustrialCraft 2 mod only)?");
        mapInfo.put("enableLootPortalGun", "Boolean:\nIs chest loot enabled for Portal Guns?");
        mapInfo.put("enableLootPortalSpawner", "Boolean:\nIs chest loot enabled for Portal Spawners?");
        mapInfo.put("enableLootDust", "Boolean:\nIs chest loot enabled for Ender Pearl Dust?");
        mapInfo.put("enableLootFizzler", "Boolean:\nIs chest loot enabled for Fizzlers?");
        mapInfo.put("lootRarityPortalGun", "What is the rarity of Portal Guns?\n1 - 100");
        mapInfo.put("lootRarityPortalSpawner", "What is the rarity of Portal Spawners?\n1 - 100");
        mapInfo.put("lootRarityDust", "What is the rarity of Ender Pearl Dust?\n1 - 100");
        mapInfo.put("lootRarityFizzler", "What is the rarity of Fizzlers?\n1 - 100");
        mapInfo.put("enabledLootOptions", "Enabled chest loot spawns.\n0 = Disabled\n1 = Dungeon Chests\n2 = Bonus Chests\n3 = Village Blacksmith Chests\n4 = Stronghold Crossing Chests\n5 = Stronghold Library Chests\n6 = Stronghold Corridor Chests\n7 = Jungle Pyramid Dispensers\n8 = Jungle Pyramid Chests\n9 = Desert Pyramid Chests\n10 = Mineshaft Corridor Chests\nFormatting: 1, 2, 3, ... etc");
        mapInfo.put("enableMoonPortals", "Enable moon portals?\n0 = No.\n1 = Yes, for all players.\n2 = Yes, but only for command executers.");
        mapInfo.put("moonPortalGrabsPlayers", "Can moon portals grab players?\n0 = No.\n1 = Yes.\n2 = Yes, but non-creative players only.");
        mapInfo.put("moonPortalGrabsBlocks", "Boolean:\nCan moon portals grab blocks?");
        mapInfo.put("moonPortalUsesGrabList", "Boolean:\nDo moon portals use the block grabbing black/whitelist when grabbing blocks?");
        mapInfo.put("moonPortalRange", "Range (in blocks) of moon portals?");
        mapInfo.put("apgSingleUse", "Boolean:\nCan Pedestals be used only once?");
        mapInfo.put("apgDrops", "Boolean:\nDo Pedestals drop as an items if broken?");
        mapInfo.put("apgIsInvincible", "Boolean:\nAre Pedestals invincible? (Cannot change to item form.)");
        mapInfo.put("apgGiveMode", "How do Pedestals give players portalguns?\n0 = Disabled\n1 = Collision and right clicking\n2 = Right clicking\n3 = Collision");
        mapInfo.put("cubeIsInvincible", "Boolean:\nAre Weighted Cubes invincible? (Cannot change to item form. Cubes from deployers are intentionally invincible)");
        mapInfo.put("cubeBreaksGlassPanes", "Boolean:\nCan Weighted Cubes break glass panes on collision?");
        mapInfo.put("radioIsInvincible", "Boolean:\nCan the radio take damage?");
        mapInfo.put("radioCanBeTurnedOff", "Boolean:\nCan the radio be turned off?");
        mapInfo.put("differentChance", "Chance of a sentry turret to change into an oracle turret.\n0 = Every time.\n1 = 50% chance\n2 = 33% chance... etc\nSet to -1 to disable.");
        mapInfo.put("turretRange", "Turret's range of fire (in blocks)");
        mapInfo.put("turretDamage", "Turret's Damage\nDefault: 2");
        mapInfo.put("turretIsInvincible", "Boolean:\nAre turrets invincible?");
        mapInfo.put("turretExplosionMag", "Turret's explosion magnitude when on fire\nDefault: 15");
        mapInfo.put("turretSeesThroughGlass", "Can turrets see through glass?\n0 = No.\n1 = Yes, but it doesn't fire.\n2 = Yes, and it fires at target.");
        mapInfo.put("turretMode", "Turret Exception modes. (Larger number = more exceptions)\nTurrets will not attack players on peaceful.\n1 = Attacks everything\n2 = Ignores players and tamed pets\n3 = Ignores animals and villagers\n4 = Ignores mobs");
        mapInfo.put("turretDrops", "Boolean:\nDoes a turret drop an item when it dies?");
        mapInfo.put("turretSeesThroughPortals", "Boolean:\nCan turrets see through (only) wall portals?");
        mapInfo.put("turretBulletsBreakGlass", "Can turret bullets break glass?\n0 = No.\n1 = Yes, glass panes only\n2 = Yes, glass panes and blocks");
        mapInfo.put("turretIgnoresOwner", "Boolean:\nDo turrets ignore players (as a target) who placed them?");
        mapInfo.put("turretIgnoresInvisibleTargets", "Boolean:\nDo turrets ignore invisible targetable entities?");
        mapInfo.put("serenadeWhenSeen", "Boolean:\nDo oracle turrets only serenade when they see the player?");
        mapInfo.put("serenadeRange", "What is the range of the turret's serenade? (in blocks)\nSetting this higher than 64 is useless.");
        mapInfo.put("turretExceptions", "Additional turret exceptions\nWritten in string form of the class (including package).\nNote that using net.minecraft.src will not actually work.\nFormat: <classname>, <classname>, <classname>\nEg: thaumcraft.world.EntityThaumSlime, thaumcraft.world.EntityWisp, net.minecraft.src.gb_EntityGibs");
        mapInfo.put("renderTurretLaser", "Boolean:\nRender turret lasers?");
        mapInfo.put("hepMode", "HEP Collision modes.\n1 = Kill every living thing.\n2 = Kill every living thing except players.\n3 = Knockback every living thing.\n4 = Knockback every living thing except players.");
        mapInfo.put("hepCanBeReleased", "Boolean:\nCan the High Energy Pellet be released from its catcher (For use in maps)");
        mapInfo.put("afpCanBeEdited", "Boolean:\nCan the Aerial Faith Plate's power be modified when you right click it? (For use in maps)");
        mapInfo.put("afpLocksKeys", "Boolean:\nDoes getting launched by an Aerial Faith Plate lock your keys? (Until you hit something)");
        mapInfo.put("customFuel", "Boolean:\nEnable custom portal gun fuel?");
        mapInfo.put("customFuelId", "Block/Item ID (after shifting) to use as fuel.");
        mapInfo.put("customFuelMetadata", "Damage/Metadata to use for the fuel.");
        mapInfo.put("customFuelAmount", "Amount of items used.");
        mapInfo.put("potatosSpeech", "Boolean:\nAllow the PotatOS to speak?");
        mapInfo.put("potatosSpeechCooldown", "Cooldown time for PotatoOS speech (in ticks)");
        mapInfo.put("autoMergeGuns", "Do two single coloured portal guns automatically merge into a dual portal gun?\n0 = No.\n1 = Yes.\n2= Yes, but from the pedestal only.");
        mapInfo.put("canShootPortalsThroughGlass", "Boolean:\nCan you shoot portals through glass?");
        mapInfo.put("canEditSpawners", "Boolean:\nCan you edit placed spawners?");
        mapInfo.put("easterEgg", "Oh wouldn't you like to know?");
    }

    static {
        turretExceptions = new ArrayList();
        failedSettings = new ArrayList();
        enabledChestLoot = new ArrayList();
        firstMapLoad = true;
        Settings.mapInfo();
    }
}

