/*
 * Decompiled with CFR 0.152.
 */
package train.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import train.common.api.LiquidManager;
import train.common.blocks.BlockDistil;
import train.common.library.BlockIDs;
import train.common.recipes.DistilRecipes;
import train.common.tile.TileTraincraft;

public class TileEntityDistil
extends TileTraincraft
implements IFluidHandler {
    private ForgeDirection facing;
    public int distilBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int distilCookTime = 0;
    private int cookDuration = 400;
    private Random random = new Random();
    private int updateTicks;
    private int maxTank = 30000;
    private LiquidManager.StandardTank theTank;
    public int amount;
    public int liquidItemID;

    public TileEntityDistil() {
        super(5, "Distillation tower");
        LiquidManager liquidManager = LiquidManager.getInstance();
        liquidManager.getClass();
        LiquidManager.getInstance();
        this.theTank = new LiquidManager.FilteredTank(liquidManager, this.maxTank, LiquidManager.dieselFilter(), 1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquid() {
        return this.amount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquidItemID() {
        return this.liquidItemID;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.readFromNBT(nbtTag, forSyncing);
        this.facing = ForgeDirection.getOrientation((int)nbtTag.func_74762_e("Orientation"));
        this.distilBurnTime = nbtTag.func_74765_d("BurnTime");
        this.distilCookTime = nbtTag.func_74765_d("CookTime");
        this.currentItemBurnTime = nbtTag.func_74765_d("CurrentItemBurn");
        this.amount = nbtTag.func_74762_e("Amount");
        this.liquidItemID = nbtTag.func_74762_e("LiquidID");
        this.theTank.readFromNBT(nbtTag);
    }

    public int getTankCapacity() {
        return this.maxTank;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.writeToNBT(nbtTag, forSyncing);
        nbtTag.func_74768_a("Orientation", this.getFacing().ordinal());
        nbtTag.func_74777_a("BurnTime", (short)this.distilBurnTime);
        nbtTag.func_74777_a("CookTime", (short)this.distilCookTime);
        nbtTag.func_74768_a("Amount", this.amount);
        nbtTag.func_74768_a("LiquidID", this.liquidItemID);
        nbtTag.func_74777_a("CurrentItemBurn", (short)this.currentItemBurnTime);
        this.theTank.writeToNBT(nbtTag);
        return nbtTag;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.distilCookTime * i / this.cookDuration;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookDuration;
        }
        return this.distilBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.distilBurnTime > 0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            ++this.updateTicks;
            boolean flag = this.distilBurnTime > 0;
            boolean flag1 = false;
            if (this.distilBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.distilBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]);
                if (this.distilBurnTime > 0) {
                    flag1 = true;
                    if (this.slots[1] != null) {
                        if (this.slots[1].func_77973_b().hasContainerItem(this.slots[1])) {
                            this.slots[1] = new ItemStack(this.slots[1].func_77973_b().func_77668_q());
                        } else {
                            --this.slots[1].field_77994_a;
                        }
                        if (this.slots[1].field_77994_a == 0) {
                            this.slots[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.distilCookTime;
                if (this.distilCookTime == this.cookDuration) {
                    this.distilCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.distilCookTime = 0;
            }
            if (flag != this.distilBurnTime > 0) {
                flag1 = true;
                BlockDistil.updateDistilBlockState(this.distilBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                flag1 = false;
                BlockDistil.updateDistilBlockState(this.distilBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.slots[2] != null && this.updateTicks % 8 == 0 && (result = LiquidManager.getInstance().processContainer((IInventory)this, 2, this, this.slots[2])) != null && this.placeInInvent(result, 4, false)) {
                this.placeInInvent(result, 4, true);
                this.amount = this.theTank.getFluid() != null ? this.theTank.getFluid().amount : 0;
                this.liquidItemID = this.theTank.getFluid() != null ? this.theTank.getFluid().getFluidID() : 0;
                flag1 = true;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.amount = this.theTank.getFluid() != null ? this.theTank.getFluid().amount : 0;
            this.liquidItemID = this.theTank.getFluid() != null ? this.theTank.getFluid().getFluidID() : 0;
            if (this.updateTicks % 8 == 0) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.distilBurnTime > 0) {
                --this.distilBurnTime;
            }
            if (flag1) {
                this.syncTileEntity();
                this.func_70296_d();
            }
        }
    }

    private boolean placeInInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.slots[i] == null) {
            if (doAdd) {
                this.slots[i] = itemstack1;
            }
            return true;
        }
        if (this.slots[i] != null && Item.func_150891_b((Item)this.slots[i].func_77973_b()) == Item.func_150891_b((Item)itemstack1.func_77973_b()) && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.slots[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.slots[i], (ItemStack)itemstack1)) {
            int var9 = this.slots[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.slots[i].field_77994_a = var9;
                }
            } else if (this.slots[i].field_77994_a < itemstack1.func_77976_d() && doAdd) {
                ++this.slots[i].field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean canSmelt() {
        if (this.slots[0] == null || this.slots[3] != null && this.slots[3].field_77994_a == 64 || this.slots[4] != null && this.slots[4].field_77994_a == 64) {
            return false;
        }
        ItemStack itemstack = DistilRecipes.smelting().getSmeltingResult(this.slots[0].func_77973_b());
        if (itemstack == null) {
            return false;
        }
        if (Block.func_149634_a((Item)this.slots[0].func_77973_b()) == BlockIDs.oreTC.block && this.slots[0].func_77960_j() != 1 && this.slots[0].func_77960_j() != 2) {
            return false;
        }
        FluidStack resultLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
        if (resultLiquid == null) {
            return false;
        }
        int used = this.getTank().fill(resultLiquid, false);
        return used >= resultLiquid.amount;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = DistilRecipes.smelting().getSmeltingResult(this.slots[0].func_77973_b());
        ItemStack plasticStack = DistilRecipes.smelting().getPlasticResult(this.slots[0].func_77973_b());
        int plasticChance = DistilRecipes.smelting().getPlasticChance(this.slots[0].func_77973_b());
        FluidStack resultLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
        if (resultLiquid == null) {
            return;
        }
        int used = this.getTank().fill(resultLiquid, false);
        if (used >= resultLiquid.amount) {
            this.getTank().fill(resultLiquid, true);
            if (this.random.nextInt(plasticChance) == 0) {
                this.outputPlastic(plasticStack);
            }
            if (this.theTank.getFluid() != null) {
                this.amount = this.theTank.getFluid().amount;
            }
            if (this.theTank.getFluid() != null) {
                this.liquidItemID = this.theTank.getFluid().getFluidID();
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.slots[0].func_77973_b().hasContainerItem(this.slots[0])) {
            this.slots[0] = new ItemStack(this.slots[0].func_77973_b().func_77668_q());
        } else {
            --this.slots[0].field_77994_a;
        }
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
        this.syncTileEntity();
    }

    private void outputPlastic(ItemStack plasticStack) {
        if (this.slots[3] == null) {
            this.slots[3] = plasticStack.func_77946_l();
        } else if (Item.func_150891_b((Item)this.slots[3].func_77973_b()) == Item.func_150891_b((Item)plasticStack.func_77973_b())) {
            this.slots[3].field_77994_a += plasticStack.field_77994_a;
        }
        this.func_70296_d();
    }

    public ForgeDirection getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return ForgeDirection.NORTH;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (side == 0) {
            return false;
        }
        if (side == 1) {
            return slot == 0;
        }
        return slot == 1;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side != 1 && slot == 3;
    }
}

