/*
 * Decompiled with CFR 0.152.
 */
package train.common.entity.rollingStock;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.adminbook.ServerLogger;
import train.common.api.EntityRollingStock;
import train.common.core.CommonProxy;
import train.common.core.util.MP3Player;

public class EntityJukeBoxCart
extends EntityRollingStock {
    public boolean isPlaying = false;
    public boolean isInvalid = false;
    public String streamURL = "";
    private Side side;
    public float volume = 1.0f;
    public MP3Player player;

    public EntityJukeBoxCart(World world) {
        super(world);
        this.field_70180_af.func_75682_a(22, (Object)this.streamURL);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.side = FMLCommonHandler.instance().getEffectiveSide();
    }

    public EntityJukeBoxCart(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            ServerLogger.deleteWagon(this);
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
            }
        }
        return true;
    }

    @Override
    public void func_70106_y() {
        this.stopStream();
        super.func_70106_y();
        this.field_70128_L = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            this.field_70180_af.func_75692_b(22, (Object)this.streamURL);
            if (this.isPlaying) {
                this.field_70180_af.func_75692_b(23, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(23, (Object)0);
            }
        }
        if (this.side == Side.CLIENT) {
            if (this.field_70173_aa % 10 == 0 && !this.isPlaying() && this.field_70180_af.func_75679_c(23) != 0) {
                this.streamURL = this.field_70180_af.func_75681_e(22);
                this.startStream();
            }
            if (Minecraft.func_71410_x().field_71439_g != null && this.player != null && !this.isInvalid) {
                float vol = (float)this.func_70092_e(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
                if (vol >= this.volume * 1000.0f) {
                    this.player.setVolume(0.0f);
                } else {
                    float v2 = 10000.0f / vol / 100.0f;
                    if (v2 > 1.0f) {
                        this.player.setVolume(this.volume);
                    } else {
                        float v1 = 1.0f - this.volume;
                        v2 = v2 - v1 > 0.0f ? (v2 -= v1) : 0.0f;
                        this.player.setVolume(v2);
                    }
                }
                if (vol == 0.0f) {
                    this.invalidate();
                }
                if (this.isPlaying && this.field_70146_Z.nextInt(5) == 0 && this.player != null && this.player.isPlaying()) {
                    int random2 = this.field_70146_Z.nextInt(24) + 1;
                    this.field_70170_p.func_72869_a("note", this.field_70165_t, this.field_70163_u + 1.2, this.field_70161_v, (double)random2 / 24.0, 0.0, 0.0);
                }
            }
        }
    }

    public void recievePacket(String url, boolean playing) {
        this.streamURL = url;
        this.isPlaying = playing;
    }

    @SideOnly(value=Side.CLIENT)
    public void invalidate() {
        this.isInvalid = true;
        this.stopStream();
    }

    public void startStream() {
        if (!this.isPlaying) {
            this.isPlaying = true;
            if (this.side == Side.CLIENT) {
                this.player = new MP3Player(this.streamURL, this.field_70170_p, this.func_145782_y());
                this.player.setVolume(0.0f);
                CommonProxy.playerList.add(this.player);
            }
        }
    }

    public void stopStream() {
        if (this.isPlaying) {
            this.isPlaying = false;
            if (this.side == Side.CLIENT && this.player != null) {
                this.player.stop();
                CommonProxy.playerList.remove(this.player);
            }
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        this.playerEntity = entityplayer;
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (this.locked && !entityplayer.getDisplayName().toLowerCase().equals(this.trainOwner.toLowerCase())) {
            if (!this.field_70170_p.field_72995_K) {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentText("this train is locked"));
            }
            return true;
        }
        entityplayer.openGui((Object)Traincraft.instance, 102, this.field_70170_p, this.func_145782_y(), -1, (int)this.field_70161_v);
        return true;
    }

    @Override
    public boolean isStorageCart() {
        return false;
    }

    @Override
    public boolean isPoweredCart() {
        return false;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 1.85f;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74778_a("StreamUrl", this.streamURL);
        nbttagcompound.func_74757_a("isPlaying", this.isPlaying());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.streamURL = nbttagcompound.func_74779_i("StreamUrl");
        this.isPlaying = nbttagcompound.func_74767_n("isPlaying");
        this.field_70180_af.func_75692_b(22, (Object)this.streamURL);
        if (this.isPlaying) {
            this.field_70180_af.func_75692_b(23, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(23, (Object)0);
        }
    }
}

