/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.util;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.tile.TileTraincraft;

public class Energy
extends TileTraincraft
implements IEnergyProvider {
    public EnergyStorage energy = new EnergyStorage(3000, 80);
    private ForgeDirection[] sides = new ForgeDirection[0];

    public Energy(int inventorySlots, String name, int maxEnergy, int maxTransfer) {
        super(inventorySlots, name);
        this.energy.setCapacity(maxEnergy);
        this.energy.setMaxTransfer(maxTransfer);
    }

    public Energy() {
    }

    public void pushEnergy(World world, int x, int y, int z, EnergyStorage storage) {
        for (ForgeDirection side : this.getSides()) {
            TileEntity tile = world.func_147438_o(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
            if (tile == null || !(tile instanceof IEnergyReceiver) || storage.getEnergyStored() <= 0 || !((IEnergyReceiver)tile).canConnectEnergy(side.getOpposite())) continue;
            int receive = ((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), Math.min(storage.getMaxExtract(), storage.getEnergyStored()), false);
            storage.extractEnergy(receive, false);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.readFromNBT(nbtTag, forSyncing);
        this.energy.readFromNBT(nbtTag);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.writeToNBT(nbtTag, forSyncing);
        this.energy.writeToNBT(nbtTag);
        return nbtTag;
    }

    public void setSides(ForgeDirection[] listOfSides) {
        this.sides = listOfSides;
    }

    public ForgeDirection[] getSides() {
        return this.sides;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return Arrays.asList(this.sides).contains(dir);
    }

    @Override
    public int extractEnergy(ForgeDirection dir, int amount, boolean simulate) {
        return this.energy.extractEnergy(amount, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection dir) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection dir) {
        return this.energy.getMaxEnergyStored();
    }
}

