/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackEmitter;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import train.common.api.DieselTrain;
import train.common.api.ElectricTrain;
import train.common.api.Locomotive;
import train.common.api.SteamTrain;
import train.common.blocks.tracks.BlockDetectorTrack;
import train.common.library.Tracks;

public class BlockDetectorAllLocomotiveTrack
extends BlockDetectorTrack
implements ITrackEmitter {
    private int ThingToSet = 0;

    @Override
    public Tracks getTrackType() {
        return Tracks.DETECTOR_ALL_LOCOMOTIVES;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.ThingToSet = nbttagcompound.func_74762_e("state");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("state", this.ThingToSet);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.ThingToSet = data.readInt();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.ThingToSet);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.ThingToSet = this.ThingToSet == 9 ? 0 : (this.ThingToSet += 3);
            switch (this.ThingToSet) {
                case 0: {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Now set to emit a signal on all trains"));
                    break;
                }
                case 3: {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Now set to emit a signal on all steam trains"));
                    break;
                }
                case 6: {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Now set to emit a signal on all diesel trains"));
                    break;
                }
                case 9: {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Now set to emit a signal on all electric trains"));
                }
            }
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        switch (this.ThingToSet) {
            case 0: {
                if (!(cart instanceof Locomotive)) break;
                this.setTrackPowering();
                break;
            }
            case 3: {
                if (!(cart instanceof SteamTrain)) break;
                this.setTrackPowering();
                break;
            }
            case 6: {
                if (!(cart instanceof DieselTrain)) break;
                this.setTrackPowering();
                break;
            }
            case 9: {
                if (!(cart instanceof ElectricTrain)) break;
                this.setTrackPowering();
            }
        }
    }
}

