/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import train.common.api.Freight;
import train.common.api.LiquidManager;
import train.common.api.LiquidTank;
import train.common.entity.rollingStock.EntityBUnitDD35;
import train.common.entity.rollingStock.EntityBUnitEMDF3;
import train.common.entity.rollingStock.EntityBUnitEMDF7;

public abstract class Tender
extends Freight
implements IFluidHandler {
    public ItemStack[] tenderItems;
    private int maxTank;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];
    public TileEntity[] blocksToCheck;

    public Tender(World world, Fluid fluid, int quantity, int capacity) {
        this(new FluidStack(fluid, quantity), capacity, world, null);
    }

    public Tender(World world, Fluid fluid, int quantity, int capacity, FluidStack filter) {
        this(new FluidStack(fluid, quantity), capacity, world, filter);
    }

    private Tender(FluidStack fluid, int capacity, World world, FluidStack filter) {
        super(world);
        this.maxTank = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public abstract int func_70302_i_();

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().getFluidID());
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
    }

    @Override
    protected void handleMass() {
        if (this.field_70173_aa % 10 != 0) {
            return;
        }
        double preciseAmount = 0.0;
        this.mass = this.getDefaultMass();
        if (this.theTank != null && this.theTank.getFluid() != null && this.theTank.getFluid().amount > 0) {
            preciseAmount = this.theTank.getFluid().amount;
        }
        this.itemInsideCount = 0.0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null || itemstack.field_77994_a <= 0) continue;
            this.itemInsideCount += (double)itemstack.field_77994_a;
        }
        this.mass += this.itemInsideCount * 1.0E-4;
        this.mass += preciseAmount / 10000.0;
    }

    public int getWater() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    private void placeInInvent(ItemStack itemstack1, Tender tender) {
        for (int i = 1; i < tender.tenderItems.length; ++i) {
            if (tender.tenderItems[i] == null) {
                tender.tenderItems[i] = itemstack1;
                return;
            }
            if (tender.tenderItems[i] != null && tender.tenderItems[i].func_77973_b() == itemstack1.func_77973_b() && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || tender.tenderItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)tender.tenderItems[i], (ItemStack)itemstack1)) {
                int var9 = tender.tenderItems[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= tender.tenderItems[i].func_77976_d()) {
                    tender.tenderItems[i].field_77994_a = var9;
                    return;
                }
                if (tender.tenderItems[i].field_77994_a >= tender.tenderItems[i].func_77976_d()) continue;
                ++tender.tenderItems[i].field_77994_a;
                return;
            }
            if (i != tender.tenderItems.length - 1) continue;
            this.func_70099_a(itemstack1, 1.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack, Tender tender) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack)) != null) {
            this.placeInInvent(result, tender);
            this.func_70298_a(0, 1);
        }
    }

    protected void checkInvent(ItemStack tenderInvent, Tender loco) {
        if (tenderInvent != null) {
            this.liquidInSlot(tenderInvent, loco);
        }
        if (this.field_70173_aa % 5 == 0 && this.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), false) == 100) {
            FluidStack drain = null;
            for (TileEntity block : this.blocksToCheck = new TileEntity[]{this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 2.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 3.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 4.0)), MathHelper.func_76128_c((double)this.field_70161_v))}) {
                if (drain != null || !(block instanceof IFluidHandler)) continue;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (((IFluidHandler)block).drain(direction, 100, false) == null || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).fluid != FluidRegistry.WATER || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).amount != 100) continue;
                    drain = ((IFluidHandler)block).drain(direction, 100, true);
                }
            }
            if (drain == null && this.cartLinked1 instanceof LiquidTank && !(this.cartLinked1 instanceof EntityBUnitEMDF7) && !(this.cartLinked1 instanceof EntityBUnitEMDF3) && !(this.cartLinked1 instanceof EntityBUnitDD35)) {
                if (this.getFluid() == null) {
                    drain = ((LiquidTank)this.cartLinked1).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                } else if (this.getFluid().getFluid() == FluidRegistry.WATER) {
                    drain = ((LiquidTank)this.cartLinked1).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                }
            } else if (drain == null && this.cartLinked2 instanceof LiquidTank && !(this.cartLinked1 instanceof EntityBUnitEMDF7) && !(this.cartLinked1 instanceof EntityBUnitEMDF3) && !(this.cartLinked1 instanceof EntityBUnitDD35)) {
                if (this.getFluid() == null) {
                    drain = ((LiquidTank)this.cartLinked2).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                } else if (this.getFluid().getFluid() == FluidRegistry.WATER) {
                    drain = ((LiquidTank)this.cartLinked2).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                }
            }
            if (drain != null) {
                this.fill(ForgeDirection.UNKNOWN, drain, true);
            }
        }
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.tenderItems[i];
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.tenderItems[par1] != null) {
            ItemStack var2 = this.tenderItems[par1];
            this.tenderItems[par1] = null;
            return var2;
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.tenderItems[i] != null) {
            if (this.tenderItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.tenderItems[i];
                this.tenderItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.tenderItems[i].func_77979_a(j);
            if (this.tenderItems[i].field_77994_a == 0) {
                this.tenderItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.tenderItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setLiquid(FluidStack liquid) {
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }

    @Override
    public void dropCartAsItem(boolean isCreative) {
        if (!this.itemdropped) {
            super.dropCartAsItem(isCreative);
            for (ItemStack stack : this.tenderItems) {
                if (stack == null) continue;
                this.func_70099_a(stack, 0.0f);
            }
        }
    }
}

