/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import train.common.adminbook.ServerLogger;
import train.common.api.EntityRollingStock;
import train.common.api.LiquidManager;
import train.common.entity.rollingStock.EntityTankLava;

public abstract class LiquidTank
extends EntityRollingStock
implements IFluidHandler,
ISidedInventory {
    private int capacity;
    protected ItemStack[] cargoItems;
    private int update = 8;
    private FluidTank theTank;
    public TileEntity[] blocksToCheck;

    public LiquidTank(World world, Fluid fluid, int quantity, int capacity) {
        this(new FluidStack(fluid, quantity), capacity, world);
    }

    public LiquidTank(World world, int capacity) {
        this(null, capacity, world);
    }

    private LiquidTank(@Nullable FluidStack liquid, int capacity, World world) {
        super(world);
        this.capacity = capacity;
        this.theTank = new FluidTank(liquid, capacity);
        this.field_70180_af.func_75682_a(4, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)"");
    }

    public int getAmount() {
        return this.field_70180_af.func_75679_c(18);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public String getLiquidName() {
        return this.field_70180_af.func_75681_e(22);
    }

    public FluidTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 5 == 0 && this.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), false) == 100) {
            FluidStack drain = null;
            for (TileEntity block : this.blocksToCheck = new TileEntity[]{this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 2.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 3.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 4.0)), MathHelper.func_76128_c((double)this.field_70161_v))}) {
                if (drain != null || !(block instanceof IFluidHandler)) continue;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (((IFluidHandler)block).drain(direction, 100, false) == null || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).fluid != FluidRegistry.WATER || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).amount != 100) continue;
                    drain = ((IFluidHandler)block).drain(direction, 100, true);
                }
            }
            if (drain != null) {
                this.fill(ForgeDirection.UNKNOWN, drain, true);
            }
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(18, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().getFluidID());
            if (this.theTank.getFluid().getFluid() != null) {
                this.field_70180_af.func_75692_b(22, (Object)this.theTank.getFluid().getFluid().getUnlocalizedName());
            }
            this.handleMass();
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(18, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
            this.field_70180_af.func_75692_b(22, (Object)"");
        }
    }

    protected void handleMass() {
        if (this.field_70173_aa % 10 != 0 && this.theTank.getFluid().amount > 0) {
            this.mass = this.getDefaultMass();
            double preciseAmount = this.theTank.getFluid().amount;
            this.mass += preciseAmount / 10000.0;
        }
    }

    public ItemStack checkInvent(ItemStack itemstack) {
        ItemStack result = null;
        if (this.field_70170_p.field_72995_K) {
            return itemstack;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null) {
            ItemStack emptyItem = itemstack.func_77973_b().getContainerItem(itemstack);
            if (this.cargoItems[1] == null) {
                if (this.theTank.getFluidAmount() == 0) {
                    for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                        if (!LiquidManager.getInstance().containsFluid(itemstack, FluidRegistry.getFluidStack((String)FluidRegistry.getFluidName((Fluid)fluid), (int)0))) continue;
                        if (fluid.getTemperature() < 1000) {
                            if (this instanceof EntityTankLava) continue;
                            result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack);
                        } else {
                            if (!(this instanceof EntityTankLava)) continue;
                            result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack);
                        }
                        break;
                    }
                } else {
                    result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack);
                }
            } else if (emptyItem != null) {
                if (emptyItem.func_77973_b() == this.cargoItems[1].func_77973_b() && this.cargoItems[1].field_77994_a + 1 <= this.cargoItems[1].func_77976_d()) {
                    result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack);
                }
            } else if (itemstack.func_77973_b() == this.cargoItems[1].func_77973_b() && this.cargoItems[1].field_77994_a + 1 <= this.cargoItems[1].func_77976_d()) {
                result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack);
            }
            if (result != null) {
                if (this.cargoItems[1] == null) {
                    this.cargoItems[1] = result;
                } else if (this.cargoItems[1].func_77973_b() == result.func_77973_b()) {
                    ++this.cargoItems[1].field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public void setLiquid(FluidTank liquid) {
        this.theTank = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public ItemStack func_70301_a(int i) {
        return this.cargoItems[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.cargoItems[i] != null) {
            if (this.cargoItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.cargoItems[i];
                this.cargoItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i].func_77979_a(j);
            if (this.cargoItems[i].field_77994_a == 0) {
                this.cargoItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargoItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70296_d() {
    }

    public String func_145825_b() {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.cargoItems.length;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            ServerLogger.deleteWagon(this);
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
            }
        }
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }
}

