/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import train.common.blocks.BlockTraincraftFluid;
import train.common.items.ItemBlockFluid;
import train.common.library.BlockIDs;
import train.common.library.ItemIDs;

public class LiquidManager {
    public static final int BUCKET_VOLUME = 1000;
    private static LiquidManager instance;
    public static FluidStack WATER_FILTER;
    public static FluidStack LAVA_FILTER;
    public static Fluid oil;
    public static Fluid steam;
    public static Fluid fuel;
    public static Fluid biomass;
    public static Fluid biofuel;
    public static Fluid bioDiesel;
    public static Fluid bioethanol;
    public static final Fluid DIESEL;
    public static final Fluid REFINED_FUEL;

    public static LiquidManager getInstance() {
        if (instance == null) {
            instance = new LiquidManager();
        }
        return instance;
    }

    public static void registerFluidBlock(BlockTraincraftFluid block) {
        GameRegistry.registerBlock((Block)block, ItemBlockFluid.class, (String)("fluid." + block.getFluid().getName()));
    }

    public void registerLiquids() {
        FluidRegistry.registerFluid((Fluid)DIESEL);
        FluidRegistry.registerFluid((Fluid)REFINED_FUEL);
        BlockIDs.diesel.block = new BlockTraincraftFluid(DIESEL, Material.field_151586_h).setFlammable(true).setFlammability(5);
        DIESEL.setBlock(BlockIDs.diesel.block);
        BlockIDs.refinedFuel.block = new BlockTraincraftFluid(REFINED_FUEL, Material.field_151586_h).setFlammable(true).setFlammability(4);
        REFINED_FUEL.setBlock(BlockIDs.refinedFuel.block);
        FluidContainerRegistry.registerFluidContainer((Fluid)DIESEL, (ItemStack)new ItemStack(ItemIDs.diesel.item), (ItemStack)new ItemStack(ItemIDs.emptyCanister.item));
        FluidContainerRegistry.registerFluidContainer((Fluid)REFINED_FUEL, (ItemStack)new ItemStack(ItemIDs.refinedFuel.item), (ItemStack)new ItemStack(ItemIDs.emptyCanister.item));
        LiquidManager.dieselFilter();
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.addRCFluids();
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            this.addBCFluids();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        LiquidManager.registerFluidBlock((BlockTraincraftFluid)BlockIDs.diesel.block);
        LiquidManager.registerFluidBlock((BlockTraincraftFluid)BlockIDs.refinedFuel.block);
    }

    @Optional.Method(modid="BuildCraft|Energy")
    private void addBCFluids() {
        BuildcraftFuelRegistry.fuel.addFuel(DIESEL, 30, 200000);
        BuildcraftFuelRegistry.fuel.addFuel(REFINED_FUEL, 60, 100000);
    }

    @Optional.Method(modid="Railcraft")
    private void addRCFluids() {
        FuelManager.addBoilerFuel(DIESEL, 60000);
        FuelManager.addBoilerFuel(REFINED_FUEL, 96000);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            DIESEL.setIcons(BlockIDs.diesel.block.func_149733_h(1), BlockIDs.diesel.block.func_149733_h(2));
            REFINED_FUEL.setIcons(BlockIDs.refinedFuel.block.func_149733_h(1), BlockIDs.refinedFuel.block.func_149733_h(2));
        }
    }

    public static void getLiquidsFromDictionnary() {
        oil = FluidRegistry.getFluid((String)"oil");
        steam = FluidRegistry.getFluid((String)"steam");
        fuel = FluidRegistry.getFluid((String)"fuel");
        biomass = FluidRegistry.getFluid((String)"biomass");
        bioethanol = FluidRegistry.getFluid((String)"bioethanol");
        biofuel = FluidRegistry.getFluid((String)"biofuel");
        bioDiesel = FluidRegistry.getFluid((String)"biodiesel");
    }

    public boolean isDieselLocoFuel(ItemStack stack) {
        FluidStack bucketLiquid = this.getFluidInContainer(stack);
        LiquidManager.getInstance();
        FluidStack[] multiFilter = LiquidManager.dieselFilter();
        if (multiFilter != null) {
            for (FluidStack aMultiFilter : multiFilter) {
                if (aMultiFilter != null && bucketLiquid != null && aMultiFilter.isFluidEqual(bucketLiquid)) {
                    return true;
                }
                if (!this.isEmptyContainer(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static FluidStack[] dieselFilter() {
        FluidStack[] fuels = new FluidStack[4];
        if (DIESEL != null) {
            fuels[0] = new FluidStack(DIESEL, 1);
        }
        if (REFINED_FUEL != null) {
            fuels[1] = new FluidStack(REFINED_FUEL, 1);
        }
        if (biofuel != null) {
            fuels[2] = new FluidStack(biofuel, 1);
        }
        if (bioDiesel != null) {
            fuels[2] = new FluidStack(bioDiesel, 1);
        }
        if (fuel != null) {
            fuels[3] = new FluidStack(fuel, 1);
        }
        if (bioethanol != null) {
            fuels[2] = new FluidStack(bioethanol, 1);
        }
        return fuels;
    }

    public boolean isContainer(ItemStack stack) {
        return FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    public boolean isFilledContainer(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public boolean isEmptyContainer(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public ItemStack fillFluidContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public FluidStack getFluidInContainer(ItemStack stack) {
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public boolean containsFluid(ItemStack stack, FluidStack liquid) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)liquid);
    }

    public boolean isFluidEqual(FluidStack L1, FluidStack L2) {
        return L1 != null && L2 != null && L1.isFluidEqual(L2);
    }

    public ItemStack processContainer(IInventory inventory, IFluidTank tank, ItemStack itemstack, int tankIndex) {
        ItemStack filled;
        FluidStack bucketLiquid = this.getFluidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItem(itemstack);
        if (bucketLiquid != null && emptyItem == null) {
            int used = tank.fill(bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(bucketLiquid, true);
                inventory.func_70298_a(0, 1);
                return null;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillFluidContainer(tank.getFluid(), itemstack)) != null) {
            FluidStack liquid = this.getFluidInContainer(filled);
            FluidStack drain = tank.drain(liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(liquid.amount, true);
                inventory.func_70298_a(0, 1);
                return filled;
            }
        }
        return null;
    }

    public ItemStack processContainer(IInventory inventory, int inventoryIndex, IFluidHandler tank, ItemStack itemstack) {
        ItemStack filled;
        FluidStack bucketLiquid = this.getFluidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItem(itemstack);
        if (bucketLiquid != null) {
            int used = tank.fill(ForgeDirection.UNKNOWN, bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(ForgeDirection.UNKNOWN, bucketLiquid, true);
                if (itemstack.func_77973_b() == Items.field_151068_bn) {
                    return new ItemStack(Items.field_151069_bo, 1);
                }
                inventory.func_70298_a(inventoryIndex, 1);
                return emptyItem;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillFluidContainer(tank.drain(ForgeDirection.UNKNOWN, 1000, false), itemstack)) != null) {
            FluidStack liquid = this.getFluidInContainer(filled);
            FluidStack drain = tank.drain(ForgeDirection.UNKNOWN, liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                inventory.func_70298_a(inventoryIndex, 1);
                return filled;
            }
        }
        return null;
    }

    static {
        WATER_FILTER = new FluidStack(FluidRegistry.WATER, 1);
        LAVA_FILTER = new FluidStack(FluidRegistry.LAVA, 1);
        DIESEL = new Fluid("Diesel").setUnlocalizedName("diesel.name").setDensity(860);
        REFINED_FUEL = new Fluid("RefinedFuel").setDensity(820).setUnlocalizedName("refinedfuel.name");
    }

    public class ReverseFilteredTank
    extends StandardTank {
        private final FluidStack filter;
        private final FluidStack[] multiFilter;

        public ReverseFilteredTank(int capacity, FluidStack filter) {
            super(capacity);
            this.filter = filter;
            this.multiFilter = null;
        }

        public ReverseFilteredTank(int capacity, FluidStack filter, int pressure) {
            this(capacity, filter);
        }

        public ReverseFilteredTank(int capacity, FluidStack[] filter) {
            super(capacity);
            this.multiFilter = filter;
            this.filter = null;
        }

        public ReverseFilteredTank(int capacity, FluidStack[] filter, int pressure) {
            this(capacity, filter);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.multiFilter != null) {
                for (int i = 0; i < this.multiFilter.length; ++i) {
                    if (this.multiFilter[i] == null || resource.getFluidID() == this.multiFilter[i].getFluidID()) continue;
                    return super.fill(resource, doFill);
                }
            } else if (this.filter.getFluidID() != resource.getFluidID()) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack getFilter() {
            return this.filter.copy();
        }

        public boolean liquidMatchesFilter(FluidStack resource) {
            return resource != null && this.filter != null && this.filter.isFluidEqual(resource);
        }
    }

    public class FilteredTank
    extends StandardTank {
        private final FluidStack filter;
        private final FluidStack[] multiFilter;

        public FilteredTank(int capacity, FluidStack filter) {
            super(capacity);
            this.filter = filter;
            this.multiFilter = null;
        }

        public FilteredTank(int capacity, FluidStack filter, int pressure) {
            this(capacity, filter);
        }

        public FilteredTank(int capacity, FluidStack[] filter) {
            super(capacity);
            this.multiFilter = filter;
            this.filter = null;
        }

        public FilteredTank(int capacity, FluidStack[] filter, int pressure) {
            this(capacity, filter);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.multiFilter != null) {
                for (int i = 0; i < this.multiFilter.length; ++i) {
                    if (this.multiFilter[i] == null || !LiquidManager.this.isFluidEqual(this.multiFilter[i], resource)) continue;
                    return super.fill(resource, doFill);
                }
            } else if (this.filter.isFluidEqual(resource)) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack getFilter() {
            return this.filter.copy();
        }

        public boolean liquidMatchesFilter(FluidStack resource) {
            return resource != null && this.filter != null && this.filter.isFluidEqual(resource);
        }
    }

    public class StandardTank
    extends FluidTank {
        private int tankIndex;

        public StandardTank(int capacity) {
            super(capacity);
        }

        public void setTankIndex(int index) {
            this.tankIndex = index;
        }

        public int getTankIndex() {
            return this.tankIndex;
        }

        public boolean isEmpty() {
            return this.getFluid() == null || this.getFluid().amount <= 0;
        }
    }
}

