/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.api.Locomotive;

public abstract class ElectricTrain
extends Locomotive {
    private int timeSinceIgnited;
    private boolean Ignite;
    public int maxEnergy = 20000;

    public ElectricTrain(World world) {
        super(world);
        this.fuelTrain = 0;
        this.numCargoSlots = 5;
        this.numCargoSlots1 = 5;
        this.numCargoSlots2 = 5;
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1 + 1;
        this.locoInvent = new ItemStack[this.inventorySize];
        this.Ignite = false;
        this.timeSinceIgnited = 0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.setState("hot");
        if (this.field_70146_Z.nextInt(4) == 0 && this.Ignite) {
            ++this.timeSinceIgnited;
        }
        if (!this.canCheckInvent) {
            return;
        }
        if (this.getFuel() < this.maxEnergy && this.locoInvent[0] != null) {
            Item item = this.locoInvent[0].func_77973_b();
            if (item == Items.field_151137_ax && this.getFuel() + 2000 <= this.maxEnergy) {
                this.fuelTrain += 2000;
                this.func_70298_a(0, 1);
            } else if (item == Item.func_150898_a((Block)Blocks.field_150451_bX) && this.getFuel() + 18000 <= this.maxEnergy) {
                this.fuelTrain += 18000;
                this.func_70298_a(0, 1);
            } else if (item instanceof IEnergyContainerItem) {
                int draw = MathHelper.func_76128_c((double)((double)Math.min(200, this.maxEnergy - this.getFuel()) * 0.1));
                this.fuelTrain += ((IEnergyContainerItem)item).extractEnergy(this.locoInvent[0], draw, false) * 10;
            }
        }
        this.blocksToCheck = new TileEntity[]{this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 2.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 2.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 3.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 4.0)), MathHelper.func_76128_c((double)this.field_70161_v))};
        int draw = 0;
        for (TileEntity block : this.blocksToCheck) {
            if (block instanceof IEnergyHandler) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (draw != 0) break;
                    int max = ((IEnergyHandler)block).getEnergyStored(direction);
                    if (max <= 0) continue;
                    draw = ((IEnergyHandler)block).receiveEnergy(direction, Math.max(-MathHelper.func_76128_c((double)((double)Math.min(200, this.maxEnergy - this.getFuel()) * 0.1)), -max), false);
                }
                this.fuelTrain += -draw;
            }
            if (draw != 0) break;
        }
    }

    @Override
    protected void updateFuelTrain(int amount) {
        if (this.fuelTrain < 0) {
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        } else if (this.isLocoTurnedOn()) {
            this.fuelTrain -= amount;
            if (this.fuelTrain < 0) {
                this.fuelTrain = 0;
                this.setLocoTurnedOnFromPacket(false);
            }
        }
        if (this.Ignite && this.timeSinceIgnited == 100) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, true);
            this.Ignite = false;
            this.field_70128_L = true;
        }
    }

    @Override
    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / this.maxEnergy;
        }
        return this.fuelTrain * i / this.maxEnergy;
    }

    @Override
    public boolean canOverheat() {
        return false;
    }
}

