/*
 * Decompiled with CFR 0.152.
 */
package train.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import train.client.gui.GuiTCTextField;
import train.common.Traincraft;
import train.common.api.AbstractTrains;
import train.common.core.network.PacketSetJukeboxStreamingUrl;
import train.common.core.network.PacketSetTrainLockedToClient;
import train.common.entity.rollingStock.EntityJukeBoxCart;

public class GuiJukebox
extends GuiScreen {
    private GuiTCTextField streamTextBox;
    private EntityJukeBoxCart jukebox;
    private EntityPlayer player;
    public boolean exists = true;
    private GuiButton buttonLock;
    private int gui_width;
    private int gui_height;
    private int gui_inner_width;
    private int gui_inner_height;
    private int anim = 0;
    private String infoText;

    public GuiJukebox(EntityPlayer player, EntityJukeBoxCart jukebox) {
        this.jukebox = jukebox;
        this.player = player;
        this.gui_width = 352;
        this.gui_height = 120;
        this.gui_inner_width = this.gui_width - 40;
        this.gui_inner_height = 20;
        this.infoText = "Paste the link below. (Only .m3u and .pls radio streams)";
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 45, this.field_146295_m / 2 + 30, 90, 20, "Play/Pause"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 45 - 120, this.field_146295_m / 2 + 30, 90, 20, "Paste"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 45 + 120, this.field_146295_m / 2 + 30, 90, 20, "Clear"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 30, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 50, this.field_146295_m / 2 + 30, 20, 20, "-"));
        this.streamTextBox = new GuiTCTextField(this.field_146289_q, this.field_146294_l / 2 - this.gui_width / 2 + 10, this.field_146295_m / 2 - this.gui_height / 2 + 50, this.gui_width - 16, 16);
        this.streamTextBox.setMaxStringLength(1000);
        this.streamTextBox.setText(this.jukebox.streamURL);
        Keyboard.enableRepeatEvents((boolean)true);
        int var1 = (this.field_146294_l - this.gui_width) / 2;
        int var2 = (this.field_146295_m - this.gui_height) / 2;
        if (!this.jukebox.locked) {
            this.buttonLock = new GuiButton(3, var1 + this.gui_width - 350, var2 - 10, 51, 10, "Unlocked");
            this.field_146292_n.add(this.buttonLock);
        } else {
            this.buttonLock = new GuiButton(3, var1 + this.gui_width - 350, var2 - 10, 43, 10, "Locked");
            this.field_146292_n.add(this.buttonLock);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int var5 = this.field_146294_l / 2 - this.gui_width / 2;
        int var6 = this.field_146295_m / 2 - this.gui_height / 2;
        int var7 = this.field_146294_l / 2 + this.gui_width / 2;
        int var8 = this.field_146295_m / 2 + this.gui_height / 2;
        GuiJukebox.func_73734_a((int)(var5 + 2), (int)(var6 + 2), (int)(var7 + 2), (int)(var8 + 2), (int)-3750202);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        this.drawSquareCorners(2, 2, var5, var6, var7, var8, 0, 0);
        this.drawSquareCorners(-6, -20, var5, var6 + 26, var7, var8 - this.gui_height / 2 + 26, 10, 0);
        this.drawSquareSides(this.gui_width, this.gui_height, 2, 2, var5, var6, var7, var8, 0, 0);
        this.drawSquareSides(this.gui_width - 16, 16, 2, 2, var5 + 8, var6 + 22 + 26, var7 - 8, var8 - this.gui_height / 2 - 32 + 36, 10, 0);
        this.func_73729_b(var5 + 6, var6 + 6, 20, 0, 7, 10);
        this.func_73729_b(var5 + 13, var6 + 6, 0 + this.anim / 100, 12, 28 * (this.gui_width / 28) / 2, 10);
        this.func_73729_b(var5 + 13 + 28 * (this.gui_width / 28) / 2, var6 + 6, 0 + this.anim / 100, 12, 28 * (this.gui_width / 28) / 2, 10);
        if (this.jukebox.isPlaying) {
            this.anim += 10;
            if (this.anim == 2800) {
                this.anim = 0;
            }
        }
        if (Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid) {
            this.field_146289_q.func_78276_b("Volume: " + (int)Math.ceil(this.jukebox.volume * 100.0f), this.field_146294_l / 2 - 26, this.field_146295_m / 2 + 18, -15856114);
        } else {
            this.field_146289_q.func_78276_b("Volume: 0", this.field_146294_l / 2 - 26, this.field_146295_m / 2 + 18, -15856114);
        }
        this.setText(-15856114);
        super.func_73863_a(par1, par2, par3);
        this.streamTextBox.drawTextBox();
        if (this.intersectsWith(par1, par2)) {
            this.func_146279_a("When a jukebox is locked,", par1, par2);
        }
    }

    private void setText(int color) {
        this.field_146289_q.func_78276_b(this.infoText, this.field_146294_l / 2 - this.gui_width / 2 + 10, this.field_146295_m / 2 - 30, color);
    }

    public void drawSquareCorners(int x, int y, int x0y0, int x1y0, int x0y1, int x1y1, int u, int v) {
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        this.func_73729_b(x0y0 - x, x1y0 - y, u, v, 4, 4);
        this.func_73729_b(x0y1 + x, x1y0 - y, u + 5, v, 4, 4);
        this.func_73729_b(x0y0 - x, x1y1 + y, u, v + 5, 4, 4);
        this.func_73729_b(x0y1 + x, x1y1 + y, u + 5, v + 5, 4, 4);
    }

    public void drawSquareSides(int width, int height, int x, int y, int x0y0, int x1y0, int x0y1, int x1y1, int u, int v) {
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        int sides = width >= height ? width : height;
        for (int i = 0; i < sides; ++i) {
            if (width > height) {
                if (i < height) {
                    this.func_73729_b(x0y0 - x, x1y0 + y + i, u, v + 4, 4, 1);
                    this.func_73729_b(x0y1 + x, x1y0 + y + i, u + 5, v + 4, 4, 1);
                }
                this.func_73729_b(x0y0 + x + i, x1y0 - y, u + 4, v, 1, 4);
                this.func_73729_b(x0y0 + x + i, x1y1 + y, u + 4, v + 5, 1, 4);
                continue;
            }
            if (i < width) {
                this.func_73729_b(x0y0 + x + i, x1y0 - y, u + 4, v, 1, 4);
                this.func_73729_b(x0y0 + x + i, x1y1 + y, u + 4, v + 5, 1, 4);
            }
            this.func_73729_b(x0y0 - x, x1y0 + y + i, u, v + 4, 4, 1);
            this.func_73729_b(x0y1 + x, x1y0 + y + i, u + 5, v + 4, 4, 1);
        }
    }

    public void func_73876_c() {
        this.streamTextBox.updateCursorCounter();
        if (this.jukebox.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
        super.func_73876_c();
    }

    public void customStop() {
        this.jukebox.stopStream();
    }

    protected void func_73869_a(char par1, int par2) {
        this.streamTextBox.textboxKeyTyped(par1, par2);
        if (par1 == '\u001c') {
            this.func_146284_a((GuiButton)this.field_146292_n.get(1));
        }
        if (!(par2 != 1 && par2 != this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || this.streamTextBox.isFocused())) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        this.streamTextBox.mouseClicked(par1, par2, par3);
        super.func_73864_a(par1, par2, par3);
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            if (this.streamTextBox.getText() != null && this.streamTextBox.getText().length() > 0) {
                if (!this.jukebox.isPlaying()) {
                    this.jukebox.streamURL = this.streamTextBox.getText().toLowerCase().contains(".m3u") ? this.takeFirstEntryFromM3U(this.streamTextBox.getText()) : (this.streamTextBox.getText().toLowerCase().contains(".pls") ? this.parsePls(this.streamTextBox.getText()) : this.streamTextBox.getText());
                    Traincraft.modChannel.sendToServer((IMessage)new PacketSetJukeboxStreamingUrl(this.jukebox, this.jukebox.streamURL, true));
                    this.jukebox.startStream();
                } else {
                    Traincraft.modChannel.sendToServer((IMessage)new PacketSetJukeboxStreamingUrl(this.jukebox, this.jukebox.streamURL, false));
                    this.jukebox.stopStream();
                }
            } else if (this.jukebox.isPlaying) {
                Traincraft.modChannel.sendToServer((IMessage)new PacketSetJukeboxStreamingUrl(this.jukebox, this.jukebox.streamURL, false));
                this.jukebox.stopStream();
            }
        }
        if (button.field_146127_k == 1) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            try {
                String result = (String)clipboard.getData(DataFlavor.stringFlavor);
                this.streamTextBox.setText(result);
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        if (button.field_146127_k == 2) {
            this.streamTextBox.setText("");
            this.streamTextBox.setFocused(true);
        }
        if (button.field_146127_k == 4 && Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid && this.jukebox.volume < 1.0f) {
            this.jukebox.volume += 0.1f;
        }
        if (button.field_146127_k == 5 && Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid && this.jukebox.volume > 0.0f) {
            this.jukebox.volume -= 0.1f;
        }
        if (button.field_146127_k == 3) {
            if (this.player != null && this.player instanceof EntityPlayer && this.player.getDisplayName().equals(((AbstractTrains)this.jukebox).getTrainOwner())) {
                List lis3;
                AxisAlignedBB box;
                if (!this.jukebox.locked) {
                    box = this.jukebox.field_70121_D.func_72314_b(5.0, 5.0, 5.0);
                    lis3 = this.jukebox.field_70170_p.func_72839_b((Entity)this.jukebox, box);
                    if (lis3 != null && lis3.size() > 0) {
                        for (int j1 = 0; j1 < lis3.size(); ++j1) {
                            Entity entity = (Entity)lis3.get(j1);
                            if (!(entity instanceof EntityPlayer)) continue;
                            Traincraft.lockChannel.sendToServer((IMessage)new PacketSetTrainLockedToClient(true, this.jukebox.func_145782_y()));
                        }
                    }
                    this.jukebox.locked = true;
                    button.field_146126_j = "Locked";
                    this.func_73866_w_();
                } else {
                    box = this.jukebox.field_70121_D.func_72314_b(5.0, 5.0, 5.0);
                    lis3 = this.jukebox.field_70170_p.func_72839_b((Entity)this.jukebox, box);
                    if (lis3 != null && lis3.size() > 0) {
                        for (int j1 = 0; j1 < lis3.size(); ++j1) {
                            Entity entity = (Entity)lis3.get(j1);
                            if (!(entity instanceof EntityPlayer)) continue;
                            Traincraft.lockChannel.sendToServer((IMessage)new PacketSetTrainLockedToClient(true, this.jukebox.func_145782_y()));
                        }
                    }
                    this.jukebox.locked = false;
                    button.field_146126_j = "UnLocked";
                    this.func_73866_w_();
                }
            } else if (this.player != null && this.player instanceof EntityPlayer) {
                this.player.func_145747_a((IChatComponent)new ChatComponentText("You are not the owner"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getState() {
        return this.jukebox.isPlaying();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146279_a(String str, int t, int g) {
        String state = "";
        state = this.jukebox.locked ? "Locked" : "Unlocked";
        int textWidth = this.field_146289_q.func_78256_a("When a jukebox is unlocked,") + 2;
        int i4 = -267386864;
        this.func_73733_a(t + 15 - 3, g - 40 - 4, t + textWidth + 3, g + 8 + 4, i4, i4);
        this.func_73733_a(t + 15 - 4, g - 40 - 3, t + textWidth + 4, g + 8 + 3, i4, i4);
        int colour1 = 0x505000FF;
        int colour2 = (colour1 & 0xFEFEFE) >> 1 | colour1 & 0xFF000000;
        this.func_73733_a(t + 15 - 3, g - 40 - 3, t + textWidth + 3, g + 8 + 3, colour1, colour2);
        this.func_73733_a(t + 15 - 2, g - 40 - 2, t + textWidth + 2, g + 8 + 2, i4, i4);
        this.field_146289_q.func_78261_a(str, t + 15, g - 40, -1);
        this.field_146289_q.func_78261_a("only its owner can open", t + 15, g + 10 - 40, -1);
        this.field_146289_q.func_78261_a("the GUI and destroy it.", t + 15, g + 20 - 40, -1);
        this.field_146289_q.func_78261_a("Current state: " + state, t + 15, g + 30 - 40, -1);
        this.field_146289_q.func_78261_a("Owner: " + this.jukebox.getTrainOwner(), t + 15, g + 40 - 40, -1);
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        int j = (this.field_146294_l - this.gui_width) / 2;
        int k = (this.field_146295_m - this.gui_height) / 2;
        return mouseX >= j + this.gui_width - 350 && mouseX <= j + this.gui_width - 300 && mouseY >= k - 10 && mouseY <= k;
    }

    public String takeFirstEntryFromM3U(String m3uurl) {
        String out = "";
        try {
            String mp3;
            URL m3u = new URL(m3uurl);
            URLConnection con = m3u.openConnection();
            BufferedReader i = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((mp3 = i.readLine()) != null && mp3.startsWith("#")) {
            }
            out = mp3;
        }
        catch (IOException e) {
            this.infoText = "Not a valid stream, only .m3u and .pls";
        }
        return out;
    }

    public String parsePls(String plsurl) {
        String out = "";
        try {
            String mp3;
            URL pls = new URL(plsurl);
            URLConnection con = pls.openConnection();
            BufferedReader i = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((mp3 = i.readLine()) != null) {
                String f = mp3.trim();
                if (!f.contains("http://")) continue;
                out = f.substring(f.indexOf("http://"));
                break;
            }
        }
        catch (IOException e) {
            this.infoText = "Not a valid stream, only .m3u and .pls";
        }
        return out;
    }
}

