/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import java.util.ArrayList;
import tmt.PositionTransformVertex;
import tmt.Tessellator;
import tmt.Vec3f;

public class TexturedPolygon {
    private boolean invertNormal = false;
    private float[] normals = new float[0];
    private ArrayList<Vec3f> iNormals = new ArrayList();
    public PositionTransformVertex[] vertices;

    public TexturedPolygon(PositionTransformVertex[] apositionTexturevertex) {
        this.vertices = apositionTexturevertex;
    }

    public void setInvertNormal(boolean isSet) {
        this.invertNormal = isSet;
    }

    public void setNormals(float x, float y, float z) {
        this.normals = new float[]{x, y, z};
    }

    public void setNormals(ArrayList<Vec3f> iNormal) {
        this.iNormals = iNormal;
    }

    public void draw(Tessellator tessellator, float f) {
        if (this.vertices.length == 3) {
            tessellator.startDrawing(4);
        } else if (this.vertices.length == 4) {
            tessellator.startDrawing(7);
        } else {
            tessellator.startDrawing(9);
        }
        if (this.iNormals.size() == 0) {
            if (this.normals.length == 3) {
                if (this.invertNormal) {
                    tessellator.setNormal(-this.normals[0], -this.normals[1], -this.normals[2]);
                } else {
                    tessellator.setNormal(this.normals[0], this.normals[1], this.normals[2]);
                }
            } else if (this.vertices.length >= 3) {
                Vec3f Vec3d2 = this.vertices[1].vector3F.subtract(this.vertices[2].vector3F).crossProduct(this.vertices[1].vector3F.subtract(this.vertices[0].vector3F)).normalize();
                if (this.invertNormal) {
                    tessellator.setNormal(-Vec3d2.xCoord, -Vec3d2.yCoord, -Vec3d2.zCoord);
                } else {
                    tessellator.setNormal(Vec3d2.xCoord, Vec3d2.yCoord, Vec3d2.zCoord);
                }
            } else {
                return;
            }
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            PositionTransformVertex positionTexturevertex = this.vertices[i];
            if (i < this.iNormals.size()) {
                if (this.invertNormal) {
                    tessellator.setNormal(-this.iNormals.get((int)i).xCoord, -this.iNormals.get((int)i).yCoord, -this.iNormals.get((int)i).zCoord);
                } else {
                    tessellator.setNormal(this.iNormals.get((int)i).xCoord, this.iNormals.get((int)i).yCoord, this.iNormals.get((int)i).zCoord);
                }
            }
            tessellator.addVertexWithUV(positionTexturevertex.vector3F.xCoord * f, positionTexturevertex.vector3F.yCoord * f, positionTexturevertex.vector3F.zCoord * f, positionTexturevertex.textureX, positionTexturevertex.textureY);
        }
        tessellator.draw();
    }

    public void flipFace() {
        PositionTransformVertex[] apositiontexturevertex = new PositionTransformVertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            apositiontexturevertex[i] = this.vertices[this.vertices.length - i - 1];
        }
        this.vertices = apositiontexturevertex;
    }
}

