/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.main;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.packets.PacketSSyncTENBTTag;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Utils {
    public static String removeLastChar(String par1) {
        if (par1 == null || par1.isEmpty()) {
            return "";
        }
        return par1.substring(0, par1.length() - 1);
    }

    public static String getFormattedCoordinates(int par1, int par2, int par3) {
        return " X:" + par1 + " Y:" + par2 + " Z:" + par3;
    }

    public static boolean toggleBoolean(boolean par1) {
        return !par1;
    }

    public static void setISinTEAppropriately(World par1World, int par2, int par3, int par4, ItemStack[] contents, String type) {
        if (par1World.func_72805_g(par2, par3, par4) == 4 && par1World.func_147439_a(par2 - 2, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_147439_a(par2 - 1, par3, par4) == mod_SecurityCraft.inventoryScannerField && par1World.func_72805_g(par2 - 2, par3, par4) == 5) {
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2 - 2, par3, par4)).setContents(contents);
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2 - 2, par3, par4)).setType(type);
        } else if (par1World.func_72805_g(par2, par3, par4) == 5 && par1World.func_147439_a(par2 + 2, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_147439_a(par2 + 1, par3, par4) == mod_SecurityCraft.inventoryScannerField && par1World.func_72805_g(par2 + 2, par3, par4) == 4) {
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2 + 2, par3, par4)).setContents(contents);
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2 + 2, par3, par4)).setType(type);
        } else if (par1World.func_72805_g(par2, par3, par4) == 2 && par1World.func_147439_a(par2, par3, par4 - 2) == mod_SecurityCraft.inventoryScanner && par1World.func_147439_a(par2, par3, par4 - 1) == mod_SecurityCraft.inventoryScannerField && par1World.func_72805_g(par2, par3, par4 - 2) == 3) {
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 - 2)).setContents(contents);
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 - 2)).setType(type);
        } else if (par1World.func_72805_g(par2, par3, par4) == 3 && par1World.func_147439_a(par2, par3, par4 + 2) == mod_SecurityCraft.inventoryScanner && par1World.func_147439_a(par2, par3, par4 + 1) == mod_SecurityCraft.inventoryScannerField && par1World.func_72805_g(par2, par3, par4 + 2) == 2) {
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 + 2)).setContents(contents);
            ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 + 2)).setType(type);
        }
    }

    public static boolean hasInventoryScannerFacingBlock(World par1World, int par2, int par3, int par4) {
        if (par1World.func_147439_a(par2 + 1, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2 + 1, par3, par4) == 4 && par1World.func_147439_a(par2 - 1, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2 - 1, par3, par4) == 5) {
            return true;
        }
        if (par1World.func_147439_a(par2 - 1, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2 - 1, par3, par4) == 5 && par1World.func_147439_a(par2 + 1, par3, par4) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2 + 1, par3, par4) == 4) {
            return true;
        }
        if (par1World.func_147439_a(par2, par3, par4 + 1) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2, par3, par4 + 1) == 2 && par1World.func_147439_a(par2, par3, par4 - 1) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2, par3, par4 - 1) == 3) {
            return true;
        }
        return par1World.func_147439_a(par2, par3, par4 - 1) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2, par3, par4 - 1) == 3 && par1World.func_147439_a(par2, par3, par4 + 1) == mod_SecurityCraft.inventoryScanner && par1World.func_72805_g(par2, par3, par4 + 1) == 2;
    }

    public static class WorldUtils {
        public static boolean isPathObstructed(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
            return WorldUtils.isPathObstructed(world, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }

        public static boolean isPathObstructed(World world, double x1, double y1, double z1, double x2, double y2, double z2) {
            return world.func_72933_a(Vec3.func_72443_a((double)x1, (double)y1, (double)z1), Vec3.func_72443_a((double)x2, (double)y2, (double)z2)) != null;
        }
    }

    public static class ClientUtils {
        @SideOnly(value=Side.CLIENT)
        public static void closePlayerScreen() {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)null);
            Minecraft.func_71410_x().func_71381_h();
        }

        @SideOnly(value=Side.CLIENT)
        public static void setCameraZoom(double zoom) {
            if (zoom == 0.0) {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (Object)1.0, (int)46);
                return;
            }
            double tempZoom = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (int)46);
            ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (Object)(tempZoom + zoom), (int)46);
        }

        @SideOnly(value=Side.CLIENT)
        public static double getCameraZoom() {
            return (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (int)46);
        }

        @SideOnly(value=Side.CLIENT)
        public static void takeScreenshot() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(ScreenShotHelper.func_148260_a((File)Minecraft.func_71410_x().field_71412_D, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a()));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static String getFormattedMinecraftTime() {
            Long time = Minecraft.func_71410_x().field_71441_e.field_73011_w.getWorldTime();
            int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
            int hours = hours24 % 12;
            int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
            return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        }

        @SideOnly(value=Side.CLIENT)
        public static void syncTileEntity(TileEntity tileEntity) {
            NBTTagCompound tag = new NBTTagCompound();
            tileEntity.func_145841_b(tag);
            mod_SecurityCraft.network.sendToServer((IMessage)new PacketSSyncTENBTTag(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tag));
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean isInLANWorld() {
            return Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c();
        }
    }

    public static class EntityUtils {
        public static boolean doesMobHavePotionEffect(EntityLivingBase mob, Potion potion) {
            for (PotionEffect effect : mob.func_70651_bq()) {
                String eName = effect.func_76453_d();
                if (!eName.matches(potion.func_76393_a())) continue;
                return true;
            }
            return false;
        }
    }

    public static class ModuleUtils {
        public static void insertModule(World par1World, int par2, int par3, int par4, EnumCustomModules module) {
            ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4)).insertModule(module);
        }

        public static void checkForBlockAndInsertModule(World par1World, int par2, int par3, int par4, String dir, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjecentBlocks) {
            for (int i = 1; i <= range; ++i) {
                if (dir.equalsIgnoreCase("x+")) {
                    if (par1World.func_147439_a(par2 + i, par3, par4) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2 + i, par3, par4)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2 + i, par3, par4)).insertModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2 + i, par3, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("x-")) {
                    if (par1World.func_147439_a(par2 - i, par3, par4) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2 - i, par3, par4)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2 - i, par3, par4)).insertModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2 - i, par3, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("y+")) {
                    if (par1World.func_147439_a(par2, par3 + i, par4) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2, par3 + i, par4)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3 + i, par4)).insertModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2, par3 + i, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("y-")) {
                    if (par1World.func_147439_a(par2, par3 - i, par4) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2, par3 - i, par4)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3 - i, par4)).insertModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2, par3 - i, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("z+")) {
                    if (par1World.func_147439_a(par2, par3, par4 + i) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 + i)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 + i)).insertModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2, par3, par4 + i, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (!dir.equalsIgnoreCase("z-") || par1World.func_147439_a(par2, par3, par4 - i) != blockToCheckFor || ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 - i)).hasModule(CustomizableSCTE.getTypeFromModule(module))) continue;
                ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 - i)).insertModule(module);
                if (!updateAdjecentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(par1World, par2, par3, par4 - i, blockToCheckFor, range, module, updateAdjecentBlocks);
            }
        }

        public static void checkInAllDirsAndInsertModule(World par1World, int par2, int par3, int par4, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjecentBlocks) {
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "x+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "x-", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "y+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "y-", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "z+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndInsertModule(par1World, par2, par3, par4, "z-", blockToCheckFor, range, module, updateAdjecentBlocks);
        }

        public static void checkForBlockAndRemoveModule(World par1World, int par2, int par3, int par4, String dir, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjecentBlocks) {
            for (int i = 1; i <= range; ++i) {
                if (dir.equalsIgnoreCase("x+")) {
                    if (par1World.func_147439_a(par2 + i, par3, par4) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2 + i, par3, par4)).hasModule(module)) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2 + i, par3, par4)).removeModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2 + i, par3, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("x-")) {
                    if (par1World.func_147439_a(par2 - i, par3, par4) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2 - i, par3, par4)).hasModule(module)) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2 - i, par3, par4)).removeModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2 - i, par3, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("y+")) {
                    if (par1World.func_147439_a(par2, par3 + i, par4) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2, par3 + i, par4)).hasModule(module)) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3 + i, par4)).removeModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2, par3 + i, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("y-")) {
                    if (par1World.func_147439_a(par2, par3 - i, par4) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2, par3 - i, par4)).hasModule(module)) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3 - i, par4)).removeModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2, par3 - i, par4, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (dir.equalsIgnoreCase("z+")) {
                    if (par1World.func_147439_a(par2, par3, par4 + i) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 + i)).hasModule(module)) continue;
                    ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 + i)).removeModule(module);
                    if (!updateAdjecentBlocks) continue;
                    ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2, par3, par4 + i, blockToCheckFor, range, module, updateAdjecentBlocks);
                    continue;
                }
                if (!dir.equalsIgnoreCase("z-") || par1World.func_147439_a(par2, par3, par4 - i) != blockToCheckFor || !((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 - i)).hasModule(module)) continue;
                ((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4 - i)).removeModule(module);
                if (!updateAdjecentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(par1World, par2, par3, par4 - i, blockToCheckFor, range, module, updateAdjecentBlocks);
            }
        }

        public static void checkInAllDirsAndRemoveModule(World par1World, int par2, int par3, int par4, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjecentBlocks) {
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "x+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "x-", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "y+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "y-", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "z+", blockToCheckFor, range, module, updateAdjecentBlocks);
            ModuleUtils.checkForBlockAndRemoveModule(par1World, par2, par3, par4, "z-", blockToCheckFor, range, module, updateAdjecentBlocks);
        }

        public static ItemModule getItemFromModule(EnumCustomModules module) {
            if (module == EnumCustomModules.REDSTONE) {
                return mod_SecurityCraft.redstoneModule;
            }
            if (module == EnumCustomModules.WHITELIST) {
                return mod_SecurityCraft.whitelistModule;
            }
            if (module == EnumCustomModules.BLACKLIST) {
                return mod_SecurityCraft.blacklistModule;
            }
            if (module == EnumCustomModules.HARMING) {
                return mod_SecurityCraft.harmingModule;
            }
            if (module == EnumCustomModules.SMART) {
                return mod_SecurityCraft.smartModule;
            }
            if (module == EnumCustomModules.STORAGE) {
                return mod_SecurityCraft.storageModule;
            }
            return null;
        }

        public static List<String> getPlayersFromModule(World par1World, int par2, int par3, int par4, EnumCustomModules module) {
            ArrayList<String> list = new ArrayList<String>();
            CustomizableSCTE te = (CustomizableSCTE)par1World.func_147438_o(par2, par3, par4);
            if (te.hasModule(module)) {
                ItemStack item = te.getModule(module);
                for (int i = 1; i <= 10; ++i) {
                    if (item.field_77990_d == null || item.field_77990_d.func_74779_i("Player" + i) == null || item.field_77990_d.func_74779_i("Player" + i).isEmpty()) continue;
                    list.add(item.field_77990_d.func_74779_i("Player" + i).toLowerCase());
                }
            }
            return list;
        }

        public static boolean checkForModule(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, EnumCustomModules module) {
            TileEntity te = par1World.func_147438_o(par2, par3, par4);
            if (te == null || !(te instanceof CustomizableSCTE)) {
                return false;
            }
            if (te instanceof TileEntityKeypad) {
                if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                    PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.keypad.name"), StatCollector.func_74838_a((String)"messages.module.whitelisted"), EnumChatFormatting.GREEN);
                    BlockKeypad.activate(par1World, par2, par3, par4);
                    return true;
                }
                if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.BLACKLIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                    PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.keypad.name"), StatCollector.func_74838_a((String)"messages.module.blacklisted"), EnumChatFormatting.RED);
                    return true;
                }
            } else if (te instanceof TileEntityKeycardReader) {
                if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                    PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.keycardReader.name"), StatCollector.func_74838_a((String)"messages.module.whitelisted"), EnumChatFormatting.GREEN);
                    BlockKeycardReader.activate(par1World, par2, par3, par4);
                    return true;
                }
                if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.BLACKLIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                    PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.keycardReader.name"), StatCollector.func_74838_a((String)"messages.module.blacklisted"), EnumChatFormatting.RED);
                    return true;
                }
            } else if (te instanceof TileEntityRetinalScanner ? module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase()) : te instanceof TileEntityInventoryScanner && module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(par1World, par2, par3, par4, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                return true;
            }
            return false;
        }
    }

    public static class BlockUtils {
        public static void setBlockInBox(World par1World, int par2, int par3, int par4, Block par5) {
            par1World.func_147449_b(par2 + 1, par3 + 1, par4, par5);
            par1World.func_147449_b(par2 + 1, par3 + 2, par4, par5);
            par1World.func_147449_b(par2 + 1, par3 + 3, par4, par5);
            par1World.func_147449_b(par2 + 1, par3 + 1, par4 + 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 2, par4 + 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 3, par4 + 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 1, par4, par5);
            par1World.func_147449_b(par2 - 1, par3 + 2, par4, par5);
            par1World.func_147449_b(par2 - 1, par3 + 3, par4, par5);
            par1World.func_147449_b(par2 - 1, par3 + 1, par4 + 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 2, par4 + 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 3, par4 + 1, par5);
            par1World.func_147449_b(par2, par3 + 1, par4 + 1, par5);
            par1World.func_147449_b(par2, par3 + 2, par4 + 1, par5);
            par1World.func_147449_b(par2, par3 + 3, par4 + 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 1, par4, par5);
            par1World.func_147449_b(par2 + 1, par3 + 2, par4, par5);
            par1World.func_147449_b(par2 + 1, par3 + 3, par4, par5);
            par1World.func_147449_b(par2, par3 + 1, par4 - 1, par5);
            par1World.func_147449_b(par2, par3 + 2, par4 - 1, par5);
            par1World.func_147449_b(par2, par3 + 3, par4 - 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 1, par4 - 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 2, par4 - 1, par5);
            par1World.func_147449_b(par2 + 1, par3 + 3, par4 - 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 1, par4 - 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 2, par4 - 1, par5);
            par1World.func_147449_b(par2 - 1, par3 + 3, par4 - 1, par5);
        }

        public static void updateAndNotify(World par1World, int par2, int par3, int par4, Block par5, int par6, boolean par7) {
            if (par7) {
                par1World.func_147464_a(par2, par3, par4, par5, par6);
            }
            par1World.func_147441_b(par2, par3, par4, par5, par1World.func_72805_g(par2, par3, par4));
            par1World.func_147460_e(par2 + 1, par3, par4, par1World.func_147439_a(par2, par3, par4));
            par1World.func_147460_e(par2 - 1, par3, par4, par1World.func_147439_a(par2, par3, par4));
            par1World.func_147460_e(par2, par3, par4 + 1, par1World.func_147439_a(par2, par3, par4));
            par1World.func_147460_e(par2, par3, par4 - 1, par1World.func_147439_a(par2, par3, par4));
            par1World.func_147460_e(par2, par3 + 1, par4, par1World.func_147439_a(par2, par3, par4));
            par1World.func_147460_e(par2, par3 - 1, par4, par1World.func_147439_a(par2, par3, par4));
        }

        public static Item getItemFromBlock(Block par1) {
            return Item.func_150898_a((Block)par1);
        }

        public static void destroyBlock(World par1World, int par2, int par3, int par4, boolean par5) {
            par1World.func_147480_a(par2, par3, par4, par5);
        }

        public static boolean isActiveBeacon(World par1World, int beaconX, int beaconY, int beaconZ) {
            if (par1World.func_147439_a(beaconX, beaconY, beaconZ) == Blocks.field_150461_bJ) {
                float f = ((TileEntityBeacon)par1World.func_147438_o(beaconX, beaconY, beaconZ)).func_146002_i();
                return f > 0.0f;
            }
            return false;
        }

        public static boolean blockSurroundedBy(World world, int x, int y, int z, Block blockToCheckFor, boolean checkYAxis) {
            if (!(checkYAxis || world.func_147439_a(x + 1, y, z) != blockToCheckFor && world.func_147439_a(x - 1, y, z) != blockToCheckFor && world.func_147439_a(x, y, z + 1) != blockToCheckFor && world.func_147439_a(x, y, z - 1) != blockToCheckFor)) {
                return true;
            }
            return checkYAxis && (world.func_147439_a(x + 1, y, z) == blockToCheckFor || world.func_147439_a(x - 1, y, z) == blockToCheckFor || world.func_147439_a(x, y, z + 1) == blockToCheckFor || world.func_147439_a(x, y, z - 1) == blockToCheckFor || world.func_147439_a(x, y + 1, z) == blockToCheckFor || world.func_147439_a(x, y - 1, z) == blockToCheckFor);
        }

        public static boolean isOwnerOfBlock(IOwnable block, EntityPlayer player) {
            if (!(block instanceof IOwnable) || block == null) {
                throw new ClassCastException("You must provide an instance of IOwnable when using Utils.isOwnerOfBlock!");
            }
            String uuid = block.getOwnerUUID();
            String owner = block.getOwnerName();
            if (uuid != null && !uuid.matches("ownerUUID")) {
                return uuid.matches(player.func_146103_bH().getId().toString());
            }
            if (owner != null && !owner.matches("owner")) {
                return owner.matches(player.func_70005_c_());
            }
            return false;
        }

        public static boolean isMetadataBetween(World world, int x, int y, int z, int min, int max) {
            return world.func_72805_g(x, y, z) >= min && world.func_72805_g(x, y, z) <= max;
        }
    }

    public static class PlayerUtils {
        public static void setPlayerPosition(EntityPlayer player, double x, double y, double z, float yaw, float pitch) {
            player.func_70080_a(x, y, z, yaw, pitch);
            player.func_70634_a(x, y, z);
        }

        public static EntityPlayer getPlayerFromName(String par1) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                List players = Minecraft.func_71410_x().field_71441_e.field_73010_i;
                for (EntityPlayer tempPlayer : players) {
                    if (!tempPlayer.func_70005_c_().matches(par1)) continue;
                    return tempPlayer;
                }
                return null;
            }
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (EntityPlayer tempPlayer : players) {
                if (!tempPlayer.func_70005_c_().matches(par1)) continue;
                return tempPlayer;
            }
            return null;
        }

        public static boolean isPlayerOnline(String par1) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                    EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i);
                    if (player == null || !player.func_70005_c_().matches(par1)) continue;
                    return true;
                }
                return false;
            }
            return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(par1) != null;
        }

        public static void sendMessageToPlayer(EntityPlayer player, String prefix, String text, EnumChatFormatting color) {
            player.func_146105_b((IChatComponent)new ChatComponentText("[" + color + prefix + EnumChatFormatting.WHITE + "] " + text));
        }

        public static void sendMessageToPlayer(ICommandSender sender, String prefix, String text, EnumChatFormatting color) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("[" + color + prefix + EnumChatFormatting.WHITE + "] " + text));
        }

        public static boolean isHoldingItem(EntityPlayer player, Item item) {
            if (item == null && player.func_71045_bC() == null) {
                return true;
            }
            return player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == item;
        }
    }
}

