/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.imc.versionchecker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.minecraft.nbt.NBTTagCompound;

public class VersionUpdateChecker {
    public static NBTTagCompound getNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        Gson gson = new GsonBuilder().create();
        try {
            URL updateURL = new URL("https://www.github.com/Geforce132/SecurityCraft/raw/master/Updates/1.7.10.json");
            BufferedReader in = new BufferedReader(new InputStreamReader(updateURL.openStream()));
            Update update = (Update)gson.fromJson((Reader)in, Update.class);
            if (update.getVersion().matches("0.0.0") && update.getFileName().matches("test") || update.getVersion().matches("v" + mod_SecurityCraft.getVersion())) {
                mod_SecurityCraft.log("Running the latest version, no new updates avaliable.");
                return null;
            }
            tag.func_74778_a("newVersion", update.getVersion());
            tag.func_74778_a("updateUrl", update.getDownloadURL());
            tag.func_74778_a("changelog", update.getChangelog());
            tag.func_74778_a("newFileName", update.getFileName());
            tag.func_74757_a("isDirectLink", true);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return tag;
    }

    public static class Update {
        private String version;
        private String downloadURL;
        private String fileName;
        private String changelog;

        public Update(String version, String downloadURL, String fileName, String changelog) {
            this.version = version;
            this.downloadURL = downloadURL;
            this.fileName = fileName;
            this.changelog = changelog;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getChangelog() {
            return this.changelog;
        }
    }
}

