/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.crafting;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import mod.lucky.Lucky;
import mod.lucky.item.ItemLuckyBlock;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LuckyCrafting
implements IRecipe {
    public String luckyBlockRecipe = "";
    public Item[] luckyCraftingItems = new Item[1];
    public int[] luckyCraftingItemDamage = new int[1];
    public int[] luckyCraftingLevels = new int[1];
    private int resultLuckLevel;
    private ItemStack resultItemStack;

    public boolean func_77569_a(InventoryCrafting craftingTable, World world) {
        int baseLuckLevel = 0;
        int itemLuckLevelTotal = 0;
        boolean foundLuckyBlock = false;
        boolean foundLuckyCraftingItem = false;
        ItemStack originalLuckyBlock = null;
        for (int a = 0; a < craftingTable.func_70302_i_(); ++a) {
            ItemStack itemStack = craftingTable.func_70301_a(a);
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() == Item.func_150898_a((Block)Lucky.lucky_block)) {
                if (foundLuckyBlock) {
                    return false;
                }
                baseLuckLevel = ItemLuckyBlock.getLuck(itemStack);
                originalLuckyBlock = itemStack.func_77946_l();
                foundLuckyBlock = true;
                continue;
            }
            boolean matchesLuckyItems = false;
            int luckyItemLuck = 0;
            for (int b = 0; b < this.luckyCraftingItems.length; ++b) {
                if (itemStack.func_77973_b() != this.luckyCraftingItems[b] || itemStack.func_77960_j() != this.luckyCraftingItemDamage[b] && this.luckyCraftingItemDamage[b] != -1) continue;
                matchesLuckyItems = true;
                luckyItemLuck = this.luckyCraftingLevels[b];
            }
            if (!matchesLuckyItems) {
                return false;
            }
            foundLuckyCraftingItem = true;
            itemLuckLevelTotal += luckyItemLuck;
        }
        if (!foundLuckyBlock || !foundLuckyCraftingItem || originalLuckyBlock == null) {
            return false;
        }
        originalLuckyBlock.field_77994_a = 1;
        this.resultLuckLevel = baseLuckLevel + itemLuckLevelTotal;
        if (this.resultLuckLevel > 100) {
            this.resultLuckLevel = 100;
        }
        if (this.resultLuckLevel < -100) {
            this.resultLuckLevel = -100;
        }
        this.resultItemStack = originalLuckyBlock;
        if (this.resultLuckLevel != 0) {
            NBTTagCompound tag = originalLuckyBlock.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a("Luck", this.resultLuckLevel);
            this.resultItemStack.func_77982_d(tag);
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting table) {
        return this.resultItemStack.func_77946_l();
    }

    public int func_77570_a() {
        return 10;
    }

    public ItemStack func_77571_b() {
        return this.resultItemStack;
    }

    public void setLuckyBlockRecipe(String recipe) {
        this.luckyBlockRecipe = recipe;
    }

    public void makeLuckyBlockRecipe() {
        try {
            String[] recipePart = this.luckyBlockRecipe.split(",");
            ArrayList<Object> recipeList = new ArrayList<Object>();
            for (String part : recipePart) {
                try {
                    Item item = (Item)Item.field_150901_e.func_82594_a(part);
                    if (item != null) {
                        recipeList.add(item);
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (part.length() == 1) {
                    recipeList.add(Character.valueOf(part.charAt(0)));
                    continue;
                }
                recipeList.add(part);
            }
            ItemStack itemStack = new ItemStack(Lucky.lucky_block);
            GameRegistry.addRecipe((ItemStack)itemStack, (Object[])recipeList.toArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

