//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “yak.cpp” (Yet Another Keyboard)

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A simple echo application.
	(I have no idea about the posix stuff, so don't ask :-)
	[Much more dorumentation needed here.]
*/
//====//====//====//====//====//====//====//====//====//====//

#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <stdlib.h> //atexit
#include <signal.h>
#include <Application.h>

class TApp : public BApplication{
	public:
		TApp();
		~TApp(); //virtual?
		bool QuitRequested();

		void ShowHelp();

		long Watcher();
		static long Caller(void*);//calls watcher

	private:
		thread_id   myth;
		long    wantquit;
};

termios oldt;              //100,4,0,b
long    mt=FALSE;

void RestoreTIO(void);//prototype (!)
void RestoreTIO(){
	if (mt){
		tcsetattr(fileno(stdin),TCSAFLUSH,&oldt);
		mt=FALSE;
	}
}


TApp::TApp():BApplication("application/x-vnd.acid-YAK"){
	wantquit=FALSE;
	myth=spawn_thread(Caller,"TermWatch",B_URGENT_DISPLAY_PRIORITY,NULL);
	resume_thread(myth);    //error checking? whats that?
}

TApp::~TApp(){}

bool TApp::QuitRequested(){
	long temp;

	wantquit=TRUE;
	ungetc('\27',stdin);//!!
	if (myth){
		wait_for_thread(myth,&temp);
	}
	return TRUE;
}

void TApp::ShowHelp(){
	printf("  \"YAK\" - Yet Another Keyboard for YATE\n");
	printf("Load Yate first, then Yak\n");
	printf("Esc <command> where command is :\n");
	printf("\ta: Toggle ASCII Output\n");
	printf("\tq: Quit (Yak)\n");
	printf("\ts: Save Current\n");
	printf("\t!: Activate Destination Window\n");
	printf("\tw#:  Change to Window # (where #=1..9)\n");
	printf("\tm/r: Make (Run)\n");
	printf("\t-/=: Prev/Next Document\n");
	printf("\tg/h: Find Again/Selection\n");
	printf("\tx/c/v/k:  Cut/Copy/Paste/Kill\n");
	printf("\t?: Help (this text)\n");
}

long TApp::Caller(void *){
	return ((TApp*)be_app)->Watcher();
}

long TApp::Watcher(){
	int fd=fileno(stdin);
	printf("Yet Another Keyboard on '%s'\n",ttyname(fd));
	tcgetattr(fd,&oldt);mt=TRUE;
	termios newterm;
	tcgetattr(fd,&newterm);
	newterm.c_cc[VMIN] =1;
	newterm.c_cc[VTIME] =0;
	newterm.c_lflag&=~(ECHO|ICANON);
//	newterm.c_iflag&=~(ICRNL);
	tcsetattr(fd,TCSAFLUSH,&newterm);

	status_t    rr;
	BMessenger mg("application/x-vnd.acid-YATE",-1,&rr);

	BMessage keydownmsg(B_KEY_DOWN+1);
	keydownmsg.AddString("bytes","HAHA");
	keydownmsg.AddInt32("raw_char",0);
	keydownmsg.AddInt32("key",0);
	keydownmsg.AddInt32("yak:window",0);

	printf("Press <Esc> <q> to Quit, <Esc> <?> for Help\n");

	int lkey=0;
	long    doasc=0,lc=0,mywin=0;
	while( !wantquit ){
		long ot=TRUE,j=getc(stdin),key=j;
		int ignore=0;
		if (doasc) printf("chr(%d,%x)[%d]\n",j,j,lc);

		switch  (lc){
			case 10:
				if (j==13){j=-1024;}
				if (j==27){j=-5;}
				break;//dosbox
			case 13:
				if (j==10){j=-1024;}
				if (j==27){j=-5;}
				break;//dosbox
			case -3://ansi code 0x1b, [
				ot=FALSE;
				switch(j){
					case 'A':j=30;break;//up
					case 'B':j=31;break;//down
					case 'C':j=29;break;//right
					case 'D':j=28;break;//left
					case 'G':j=12;break;//pgdn
					case 'I':j=11;break;//pgup
					case '1':j=-8;break;//Bash function key
					default:ot=TRUE;
				}
				break;
			case -4:    //DesqView-X telnet function keys
				switch(j){
					case 'A':j=30;break;
					case 'B':j=31;break;
					case 'C':j=29;break;
					case 'D':j=28;break;
					case 'P':j=16;key=2;break;//f1
					case 'Q':j=16;key=3;break;//f2
					case 'R':j=16;key=4;break;//f3
					case 'S':j=16;key=5;break;//f4
				}
				break;

			case -5://esc key...
				switch (j){
//                    case 27:j=-5;break; //typo?
					case 'q':
					case 'Q':
						ot=FALSE;
						PostMessage(B_QUIT_REQUESTED);
						wantquit=TRUE;j=0;
						break;
					case '[':ot=FALSE;j=-3;break;
					case 'a':doasc=!doasc;j=-1;
						printf("ASCII output %sabled\n",(doasc)?"en":"dis");
						break;
					case 'x':j=260;break;
					case 'c':j=261;break;
					case 'v':j=262;break;
					case 'k':j=263;break;
					case 'g':j=271;break;
					case 'h':j=272;break;
					case 's':j=280;break;
					case '-':j=282;break;
					case '=':j=283;break;
					case '!':j=284;break;
					case 'm':j=285;break;
					case 'r':j=286;break;

					case 'w':j=-6;break;    //choose window
					case '?': ShowHelp();j=-1;break;
					case 'O':j=-4;break;//DVX function key
				}
				break;
			case -6://choose window..
				mywin=j-'1';
				if (mywin<0||mywin>8)mywin=0;
				j=0;
				break;
			case -8: //Bash function key
				lkey=j;
				j=-0;
			case -9: //swallow..
				j=16;
				key=lkey-'1'+2;
				ignore=-10;
				break;
			case -10:
				j=0;
				break;
			default:
				if (j==27)j=-5;
				break;
		}

		if (j>0){
			if (mg.IsValid()){
				char    mys[8];
				mys[0]=j;mys[1]=0;
				keydownmsg.ReplaceString("bytes",mys);
				keydownmsg.ReplaceInt32("raw_char",j);
				keydownmsg.ReplaceInt32("key",key);
				keydownmsg.ReplaceInt32("yak:window",mywin);
				mg.SendMessage(&keydownmsg);
			}else{
				printf("Couldn't connect, Load YATE first\n");
			}
		}
		lc=j;
		if (ignore) lc=ignore;
	}
	printf("YAK: watcher() terminated okay\n");
	return 0;
}


void myhandler(int dd);
void myhandler(int dd){
	printf("^C detected (%x)\n",dd);
	exit(-1);
}

int main(){
	atexit(RestoreTIO);
	signal(SIGINT,myhandler);
	TApp    *ta=new TApp();
	ta->Run();
	delete ta;
	return 0;
}


