/*--------------------------------------------------------*/
/*
  IMPACT - Virtual Reality Workshop
	First implementation by John Henckel on Oct 7, 1993

   Copyright (c) 1993,1995 John Henckel
   Permission to use, copy, modify, distribute and sell this software
   and its documentation for any purpose is hereby granted without fee,
   provided that the above copyright notice appear in all copies.

*/

/*--------------------------------------------------------*/


/*

	 hacked implementation file for the BeOS..

	Note from Chris:
		I was rumaging thru my hard drive and found
	this left over from DR8..  I commented out
	the main menu code and WYSIWYG...

	feel free to pillage from this code, however if you do,
	You have my *deepest* sympathies..

	the original has only been slightly modified
	(I extended it's concept of line to include diagonals..)

	(original available upon request)


	Chris Blackbourn
	blakatz@ihug.co.nz
	Acid Software
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <List.h>
#include <View.h>
#include <Window.h>
#include <Bitmap.h>

#define A_TICK  7274

class TWindow : public BWindow {
//	B_DECLARE_CLASS_INFO(BWindow);
public:
					TWindow(BRect frame, const char *title);
virtual             ~TWindow();

virtual void        MessageReceived(BMessage *msg);
virtual void        FrameMoved(BPoint new_position);
		void        Update(BRect rect);
		void        Update();
		void        DrawOffScreen(BView *);

private:
		class TBitmapView *fMainView;
		BRect       fMyFrame;
		BRect       fPartnerFrame;
		float       fGapStart;
		float       fGapEnd;
		BBitmap     *fBitmap;
		BView       *fOffView;
		long        fSkipFrameMoved;
		long        fSkipDraw;
};

/*--------------------------------------------------------*/

class TBitmapView : public BView {
	//B_DECLARE_CLASS_INFO(BView);

public:
					TBitmapView(BRect frame, BBitmap *bitmap);

virtual void        Draw(BRect updateRect);

private:
		BBitmap     *fBitmap;
};


#define myabs(a) (((a)>0)?(a):-(a))
#define mymax(a,b) (((a)>(b))?(a):(b))
#define mymin(a,b) (((a)<(b))?(a):(b))
#define mylimit(a,b,c) mymin(mymax((a),(b)),(c))


static  int rest=4096;


inline int QWrap(int num,int low,int high)
{
	 while(num<low) num+=(high-low);
	 while(num>=high) num+=(low-high);
	 return(num);
}


inline int mysq(int x){
	return (int)sqrt(x);
}
inline int sqrt12(int x){
	double j;
	j=x;
	j=4096.0*sqrt(j);
	return(int)j;
}

inline int reciproot(int x){
	double j;
	j=x;
	j=4096.0*4096.0/sqrt(j);
	return(int)j;
}

inline int myrecip(int x){
	double j;
	j=x;
	j=4096.0*4096.0/j;
	return(int)j;
}

inline int myatan(int x,int y){
	double jjj;

	jjj=atan2(y,x)*2048.0/3.14159265;
	return(int)jjj;
}

int mycos(int);
int mysin(int);

int mycos(int x){return(int)(cos(x*(3.14159265/2048.0))*4096.5);}
int mysin(int x){return(int)(sin(x*(3.14159265/2048.0))*4096.5);}



typedef struct{
	int     x[3];
	int     nx[3];
	int     v[3];
	int     xx[10][3];
	int     ii[10];
	int     jj[10];
	int     rad;
	int     rdist[10];
	int     dist[10];
	int     rsdist[10];
	short   m[3][3];
	short   nm[3][3];
	short   r[3][3];
	int     rotnum;
	int     idx;
}blob;

blob mypoly[100];
int     nump=10;//6;


void NormMat(short src[3][3]);
void NormMat(short src[3][3]){
	int a,b;
	int i,dista;

	for(i=0;i<3;i++){
		a=src[i][0];
		b=src[i][1];
		dista=reciproot(a*a+b*b);
		src[i][0]=(a*dista)>>12;
		src[i][1]=(b*dista)>>12;
	}
	src[1][0]=-src[0][1]; //cheesy!
	src[1][1]=src[0][0];

}


void MulMat(short src[3][3], short fin[3][3],short res[3][3]);
void MulMat(short src[3][3], short fin[3][3],short res[3][3]){
	short   temp[3][3];
	int i,j;

	for (i=0;i<3;i++){
		for (j=0;j<3;j++){
			temp[i][j]=(src[0][j]*fin[i][0]+src[1][j]*fin[i][1]+src[2][j]*fin[i][2])>>12;
		}
	}


	for (i=0;i<3;i++){
		for (j=0;j<3;j++){
			res[i][j]=temp[i][j];
		}
	}
}



void RotMat(short fin[3][3],int rot);
void RotMat(short fin[3][3],int rot){
	int     qc,qs,i,j;
	short   temp[3][3];

	qc=mycos(rot);//cos(rot/2048.0*3.14159)*4096.0;
	qs=mysin(rot);//sin(rot/2048.0*3.14159)*4096.0;

	temp[0][0]=(fin[0][0]*qc-qs*fin[0][1])>>12;
	temp[0][1]=(fin[0][0]*qs+qc*fin[0][1])>>12;
	temp[1][0]=(fin[1][0]*qc-qs*fin[1][1])>>12;
	temp[1][1]=(fin[1][0]*qs+qc*fin[1][1])>>12;
	for (i=0;i<2;i++){
		for (j=0;j<2;j++){
			fin[i][j]=temp[i][j];
		}
	}
}

void MakeRot(short fin[3][3],int rot);
void MakeRot(short fin[3][3],int rot){
	int     qc,qs,i,j;
	qc=(int)(cos(rot/2048.0*3.14159)*4096.0);
	qs=(int)(sin(rot/2048.0*3.14159)*4096.0);
	for (i=0;i<2;i++){
		for (j=0;j<2;j++){
			fin[i][j]=0;
		}
	}
	fin[0][0]=qc;fin[0][1]=-qs;
	fin[1][0]=qs;fin[1][1]=qc;
	fin[2][2]=4096;

}

void MakeNewPoly(blob *th,int num);
void MakeNewPoly(blob *th,int num){
	int i,j;
	int dx,dy;
	int dist;

	th->idx=num;
	for (i=0;i<3;i++){
		th->x[i]=4096*30;
		th->v[i]=0;
		for (j=0;j<3;j++){
			th->m[i][j]=0;
			th->r[i][j]=0;
		}
		th->m[i][i]=4096;
		th->r[i][i]=4096;
		for (j=0;j<9;j++){
			th->xx[j][i]=0;
		}
	}
	th->xx[0][0]= 4096*20;
	th->xx[1][1]= 4096*12;
	th->xx[2][0]=-4096*14;
	th->xx[3][1]=-4096*12;

	th->rad=0;
	for (i=0;i<4;i++){
		dx=th->xx[3-i][0]=((i&1)*2-1)*( (i&2)-1 )*4096*12;
		dy=th->xx[3-i][1]=((i&2)-1)*4096*5;
		dx=dx>>6;
		dy=dy>>6;
		dist=mysq(dx*dx+dy*dy);//;//>>6;
		if (th->rad<dist) th->rad=dist;
//        printf("%d\n",dist);
	}

	th->xx[4][0]=th->xx[0][0];
	th->xx[4][1]=th->xx[0][1];
	for (j=0;j<9;j++){
		dx=th->xx[j][0]>>6;
		dy=th->xx[j][1]>>6;
		dx=dx*dx+dy*dy;
		th->dist[j]=sqrt12(dx);
//      th->rdist[j]=myrecip(dx);
		th->rdist[j]=reciproot(dx);
	}
	th->x[0]=4096*23;
	th->x[1]=4096*23;

	RotMat(th->r,200);
	th->rotnum=200;
}

#define aaa 0
void BouncePoly(blob *th,int x0,int y0,int dx,int dy);
void BouncePoly(blob *th,int x0,int y0,int dx,int dy){
	int delx,dely;
	int i;
	int ddx,ddy;
	int hit;
	int veli,velj;
	int di,dj;
	int dista,ddi,ddj;
	int ovi,ovj,orot,rotvel;
	int over,minover;

	int ri,y1,x1,w1,v1,a,c1;
	int vvi,vvj;
	int nv;


	delx=th->x[0]-x0;
	dely=th->x[1]-y0;

	hit=0;
	ovi=th->v[0];
	ovj=th->v[1];
	orot=th->rotnum;

	minover=0;
	for (i=0;i<4;i++){
		di=((th->m[0][0]*th->xx[i][0] + th->m[1][0]*th->xx[i][1])>>12);
		dj=((th->m[0][1]*th->xx[i][0] + th->m[1][1]*th->xx[i][1])>>12);
		ddx=(delx+di)>>6;
		ddy=(dely+dj)>>6;
		over=ddx*dx+ddy*dy;
//      printf("%d,%d,(%d,%d)=%d\n",ddx,ddy,dx,dy,over);
		if (over<minover){
			minover=over;
			vvi=(th->m[0][0]*th->xx[i][0] + th->m[1][0]*th->xx[i][1])>>12;
			vvj=(th->m[0][1]*th->xx[i][0] + th->m[1][1]*th->xx[i][1])>>12;

			veli= (vvj*orot*3)>>11;             //veli= mysin(1))>>12;  veli*pi/2)
			velj=-(vvi*orot*3)>>11;
			veli+=ovi;
			velj+=ovj;
			ddi=di;
			ddj=dj;
		}
	}

	minover>>=6;
	if (minover<0){

		ri=4096                     ;// ri = bod[r].ti/bod[r].tm;
		y1=ddj>>4                   ;// y1 = bod[r].ky - y1;
		x1=ddi>>4                   ;
		y1=(y1*dx-x1*dy)>>12;

		w1=orot                     ;//w1 = bod[b1].w;          //angular velocity..
		v1=(veli*dx+velj*dy)>>12    ;//v1 = bod[b1].vx;
		a=(y1*y1/ri)                ;//a = y1*y1/ri;            //relative torque!?

		rotvel=(y1*(4096+rest))>>12;

		c1=((a-rest)*v1- rotvel*w1)/(a+4096);

		nv=(th->v[0]*dx+th->v[1]*dy)>>12;

										;//c1 = ((a-rest)*v1 - y1*(1+rest)*w1)/(a+1);
		th->v[0]+=((c1-nv)*dx)>>12      ;//bod[r].vx = c1;
		th->v[1]+=((c1-nv)*dy)>>12      ;//bod[r].vx = c1;
		rotvel=(y1*(c1-v1)/ri)>>7;      ;// bod[r].w = y1*(c1 - v1)/ri + w1;    // - jw ??
		th->rotnum+=rotvel;

		th->x[0]-=(minover*dx)>>12;     ;// bod[r].cx -= scut*x1;
		th->x[1]-=(minover*dy)>>12;
		dista=minover;
//      printf("[%d],%d,(%d,%d),%d,%d,%d,%d\n",th->idx,a,y1,veli,c1,rotvel,w1,dista);

	}

	return;
}

void MovePoly(blob *th);
void MovePoly(blob *th){
	int i;


	for (i=0;i<3;i++){
		th->x[i]=th->x[i]+th->v[i];
	}
	MakeRot(th->r,th->rotnum);
//  MulMat(th->r,th->m,th->nm);
	MulMat(th->r,th->m,th->m);
	NormMat(th->m);

	BouncePoly(th,4096*140,0,-4096,0);
	BouncePoly(th,4096*2,0,4096,0);
	BouncePoly(th,0,4096*160,0,-4096);
	BouncePoly(th,0,4096*2,0,4096);
	BouncePoly(th,4096*100,4096*100,-3132,-2638);
	return;
}

void BangPoly(blob *th,blob *tr);
void BangPoly(blob *th,blob *tr){
	int     dist,maxdist;
	int     dx,dy;
	int     rad;
	int     i,j;
	int     di1,di2,dj1,dj2;
	int     ddi,ddj;
	int     x0,y0;
	int     hit,adder;
	int     dvi,dvj;
	int     resi,resj;
	int     hx,hy;
	int     a,c;
	int     v1,v2,c1,c2,o1,o2,y1,y2;
	int     pen;

	dx=(th->x[0]-tr->x[0])>>6;
	dy=(th->x[1]-tr->x[1])>>6;
	rad=th->rad+tr->rad;
	hit=0;
	if ((myabs(dx)<rad)&(myabs(dy)<rad)){
//      printf("bang %d,%d  (%d,%d,%d), ",th->idx,tr->idx,dx,dy,rad);
		adder=1;
		for (i=0;i<4;i++){
			di1=((th->m[0][0]*th->xx[i  ][0] + th->m[1][0]*th->xx[i  ][1])>>12);
			dj1=((th->m[0][1]*th->xx[i  ][0] + th->m[1][1]*th->xx[i  ][1])>>12);
			di2=((th->m[0][0]*th->xx[i+1][0] + th->m[1][0]*th->xx[i+1][1])>>12);
			dj2=((th->m[0][1]*th->xx[i+1][0] + th->m[1][1]*th->xx[i+1][1])>>12);
			ddi=di2-di1;
			ddj=dj2-dj1;
			dist=reciproot(ddi*ddi+ddj*ddj);
			ddi=(ddi*dist)>>12;
			ddj=(ddj*dist)>>12;

			x0=(th->x[0]+di1 - tr->x[0])>>4;
			y0=(th->x[1]+dj1 - tr->x[1])>>4;

			for (j=0;j<4;j++){
				di1=((tr->m[0][0]*tr->xx[j][0] + tr->m[1][0]*tr->xx[j][1])>>16);
				dj1=((tr->m[0][1]*tr->xx[j][0] + tr->m[1][1]*tr->xx[j][1])>>16);
				dist=((x0-di1)*ddj-(y0-dj1)*ddi)>>12;
				if (dist>0) hit+=adder;
				adder*=2;
			}
		}
	}
	adder=0;
	if ((hit&0x1111)==0x1111)       adder+=1;
	if ((hit&0x2222)==0x2222)       adder+=2;
	if ((hit&0x4444)==0x4444)       adder+=4;
	if ((hit&0x8888)==0x8888)       adder+=8;
	if (adder==0) return; //no collision..

	resj=-1;
	if (adder==1){resj=0;}
	if (adder==2){resj=1;}
	if (adder==4){resj=2;}
	if (adder==8){resj=3;}
	if (resj==-1){
//        printf("HAHAH you stuffed now boyee!\n");
		resj=0;
	}


	di1=((tr->m[0][0]*tr->xx[resj][0] + tr->m[1][0]*tr->xx[resj][1])>>12);
	dj1=((tr->m[0][1]*tr->xx[resj][0] + tr->m[1][1]*tr->xx[resj][1])>>12);
	hx=tr->x[0]+di1;    //hit point.. (yeah right..)
	hy=tr->x[1]+dj1;

	maxdist=4096*4096;
	resi=-1;
	for (i=0;i<4;i++){
		di1=((th->m[0][0]*th->xx[i  ][0] + th->m[1][0]*th->xx[i  ][1])>>12);
		dj1=((th->m[0][1]*th->xx[i  ][0] + th->m[1][1]*th->xx[i  ][1])>>12);
		di2=((th->m[0][0]*th->xx[i+1][0] + th->m[1][0]*th->xx[i+1][1])>>12);
		dj2=((th->m[0][1]*th->xx[i+1][0] + th->m[1][1]*th->xx[i+1][1])>>12);
		ddi=di2-di1;
		ddj=dj2-dj1;
		dist=reciproot(ddi*ddi+ddj*ddj);
		ddi=(ddi*dist)>>12;
		ddj=(ddj*dist)>>12;

		x0=th->x[0]+di1;
		y0=th->x[1]+dj1;

		dist=((x0-hx)*ddj-(y0-hy)*ddi)>>12;
		if (dist>0) {
			if (dist<maxdist){
				maxdist=dist;
				resi=i;
			}
		}
	}

	if (resi==-1){
		printf("somthien weird happening\n");
		resi=0;
	}

	pen=maxdist;
	i=resi;
	di1=((th->m[0][0]*th->xx[i  ][0] + th->m[1][0]*th->xx[i  ][1])>>12);
	dj1=((th->m[0][1]*th->xx[i  ][0] + th->m[1][1]*th->xx[i  ][1])>>12);
	di2=((th->m[0][0]*th->xx[i+1][0] + th->m[1][0]*th->xx[i+1][1])>>12);
	dj2=((th->m[0][1]*th->xx[i+1][0] + th->m[1][1]*th->xx[i+1][1])>>12);
	ddi=di2-di1;
	ddj=dj2-dj1;
	dist=reciproot(ddi*ddi+ddj*ddj);
	ddi=(ddi*dist)>>12;
	ddj=(ddj*dist)>>12;
	dx=-ddj;
	dy=ddi;


	if (adder){
		dist=reciproot(dx*dx+dy*dy);
		dx=(dx*dist)>>12;
		dy=(dy*dist)>>12;

		dvi=(th->v[0])>>6;
		dvj=(th->v[1])>>6;
		v1=(dvi*dx+dvj*dy)>>6;
		dvi=(tr->v[0])>>6;
		dvj=(tr->v[1])>>6;
		v2=(dvi*dx+dvj*dy)>>6;

		y1=((hx-th->x[0])*dy-(hy-th->x[1])*dx)>>18;//y1 = (hx-bod[b1].ocx)*ny - (hy-bod[b1].ocy)*nx;
		y2=((hx-tr->x[0])*dy-(hy-tr->x[1])*dx)>>18;//y2 = (hx-bod[b2].ocx)*ny - (hy-bod[b2].ocy)*nx;



		c = (y1*th->rotnum - y2*tr->rotnum)>>12;

		a=(y2*y2 + y1*y1)>>12; //relative interia goes here somwehre..
		c1=((a+4096-rest)*v1 + (4096+rest)*(v2-c))/(a + 4096+4096);
		c2=((a+4096-rest)*v2 + (4096+rest)*(v1+c))/(a + 4096+4096);
//        c1 = ((a + m1 - rest*m2)*v1 + (1+rest)*m2*(v2 - c)) / (a + b);
//        c2 = ((a + m2 - rest*m1)*v2 + (1+rest)*m1*(v1 + c)) / (a + b);
		c1=v2;
		c2=v1;

		o1 = (y1*(c1 - v1))>>16;
		o2 = (y2*(c2 - v2))>>16;
		th->rotnum -= o1;
		tr->rotnum -= o2;

		th->v[0]+=((c1-v1)*dx)>>12;
		th->v[1]+=((c1-v1)*dy)>>12;
		tr->v[0]+=((c2-v2)*dx)>>12;
		tr->v[1]+=((c2-v2)*dy)>>12;

		th->x[0]+=(pen*dx)>>13;
		th->x[1]+=(pen*dy)>>13;
		tr->x[0]-=(pen*dx)>>13;
		tr->x[1]-=(pen*dy)>>13;

//      printf("[a],%d,%d (%x,%x),[%d,%d,%d,%d](%d)\n",a,y1,y2,hit,adder,v1,v2,dx,dy,pen);
	}
}

// BeOS code here on in..

void DrawPoly(blob *th,BView *vv);
void DrawPoly(blob *th,BView *vv){
	int bx,by,xx,yy;
	int i,j;

	BPoint dest,nxt;
	bx=th->x[0];
	by=th->x[1];


	i=3;
	for (j=0;j<=4;j++){
		xx=( th->m[0][0]*th->xx[i][0] + th->m[1][0]*th->xx[i][1] )>>12;
		yy=( th->m[0][1]*th->xx[i][0] + th->m[1][1]*th->xx[i][1] )>>12;

//      printf("[%d,%d,%d]\n",j,(bx+xx)>>12,(by+yy)>>12);
		dest=BPoint( (bx+xx)>>12, (by+yy)>>12);
		if (j>0)  vv->StrokeLine(nxt,dest);
		nxt=dest;
		i=j;
	}

	return;
}


/*--------------------------------------------------------*/


void ShowAbout();
void ShowAbout(){
	BList list;
	BRect wpos(120, 40, 321, 241);


	for (int i=0;i<nump;i++){
		MakeNewPoly(&mypoly[i],i);
		mypoly[i].x[0]+=(i*4096*20);
		mypoly[i].x[1]+=((nump-i)*4096*20);
		mypoly[i].v[1]=(i*300)+400;
		mypoly[i].v[0]=(i*300)+400;
//      RotMat(mypoly[i].r,i*10);
		mypoly[i].rotnum=0;//(i-1)*20;
	}

//  mypoly[1].x[0]=4096*70;
//  mypoly[1].v[0]=-600;

	TWindow *fWindow = new TWindow(wpos, "About YATE");

	fWindow->Show();
	fWindow->PostMessage(A_TICK);
}

/*--------------------------------------------------------*/

/*--------------------------------------------------------*/


TWindow::TWindow(BRect frame, const char *title)

	: BWindow(frame, title, B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	Lock();
	BRect b = frame;

	// shift be to window coordinate system
	b.OffsetTo(B_ORIGIN);

	fMyFrame = frame;
	fGapStart = -1.0;
	fGapEnd = -1.0;


	/*
	 The drawing will take place in the view fOffView that
	 will be added to the offscreen bitmap fBitmap. In
	 this way we'll do the drawing offscreen and then just
	 blit the result to the screen.
	*/
	fBitmap = new BBitmap(b, B_COLOR_8_BIT, TRUE);
	fOffView = new BView(b, "", 0, B_WILL_DRAW);

	fBitmap->Lock();
	fBitmap->AddChild(fOffView);

	BFont signfont=be_plain_font;
	signfont.SetFamilyAndStyle("Baskerville","Bold");
	signfont.SetSize(40.0);
	signfont.SetRotation(90.0);
	signfont.SetShear(120.0);
	fOffView->SetHighColor(255,255,0);

	fOffView->SetHighColor(0,0,0);
	fOffView->MovePenTo(177,166);
	fOffView->SetFont(&signfont);
	fOffView->DrawString("YATE");
	fOffView->MovePenBy(-10.0,-8.0);
	fOffView->SetFontSize(26.0);
	fOffView->DrawString("’97");

	signfont.SetSize(15.0);
	signfont.SetFamilyAndStyle("Baskerville","Regular");
	signfont.SetShear(90.0);
	fOffView->SetFont(&signfont);
	fOffView->MovePenTo(193,159);
	char outptr[8192];
	sprintf(outptr,"%s %s",__DATE__,__TIME__);

	fOffView->DrawString(outptr);


	BFont nont=be_plain_font;
	nont.SetFamilyAndStyle("Swis721 BT","Regular");
	nont.SetSize(13.0);
	fOffView->SetFont(&nont);
	fOffView->DrawString("       blakatz@ihug.co.nz",BPoint(4,173));
	fOffView->DrawString("  http://www.geocities.com/",BPoint(4,185));
	fOffView->DrawString("  TimesSquare/Arcade/1783",BPoint(4,197));



	nont.SetFamilyAndStyle("Swis721 BT","Bold");
	nont.SetRotation(atan2(3132,2638)*180.0/3.141592);
	nont.SetSize(17.0);

	fOffView->SetFont(&nont);
	DrawOffScreen(fOffView);    // draw the initial setup

	fOffView->StrokeLine(BPoint(142,2),BPoint(500,2));
	fOffView->StrokeLine(BPoint(142,2),BPoint(142,160));
	fOffView->StrokeLine(BPoint(2,162),BPoint(2,500));


	float mm=b.Width()-2;
	fOffView->StrokeLine(BPoint(142,160),BPoint(mm,160));
	fOffView->StrokeLine(BPoint(2,162),BPoint(mm,162));
	fOffView->StrokeLine(BPoint(mm,  1),BPoint(mm,160));
	fOffView->StrokeLine(BPoint(mm,162),BPoint(mm,500));

	mm=b.Height()-2;
	fOffView->StrokeLine(BPoint(1,mm),BPoint(500,mm));

	fOffView->Sync();


	fBitmap->Unlock();



	/*
	 This view will be added to the visible window. It's
	 only role is to blit the offscreen bitmap to the
	 visible window.
	*/
	fMainView = new TBitmapView(b, fBitmap);
	AddChild(fMainView);

	fSkipFrameMoved = fSkipDraw = 0;

	Unlock();
}

/*--------------------------------------------------------*/

TWindow::~TWindow()
{
	delete fBitmap;
}

/*--------------------------------------------------------*/

void TWindow::FrameMoved(BPoint /*new_pos*/)
{
	/*
	 Override of BWindow::FrameMoved() so that as the
	 window is moved around the screen we can inform our
	 partner of our new location.
	*/

	/*
	 Cheezy flow control. If there are 3 or more WINDOW_MOVED events
	 already in the queue, then skip this one, and, at most the next
	 message.
	*/
	fSkipFrameMoved = 0;
	if ((fSkipFrameMoved < 2) && MessageQueue()->FindMessage(B_WINDOW_MOVED, 2)) {
			fSkipFrameMoved++;
			return;
	}

	fMyFrame = Frame();
}


/*--------------------------------------------------------*/


/*--------------------------------------------------------*/

void TWindow::MessageReceived(BMessage *msg)
{
	int fSkipDraw;

	switch(msg->what){
		case A_TICK:
			{
			/*
			 Cheezy flow control. If there are 3 or more BB_DRAW events
			 already in the queue, then skip this one, and, at most the next
			 message.
			*/
			fSkipDraw=0;
			if ((fSkipDraw < 2) && MessageQueue()->FindMessage(A_TICK, 2)) {
				fSkipDraw++;
				break;
			}
			fSkipDraw = 0;

			// The ball is telling the window to redraw

			Update();//msg->FindRect("update"));
			PostMessage(A_TICK);

			break;
			}
		default:
			//hmmm..
			inherited::MessageReceived(msg);
			break;
	}
}

/*--------------------------------------------------------*/



void TWindow::Update(BRect rect){
	// redraw window, only blitting the given rect.
	DrawOffScreen(fOffView);
	fMainView->Draw(rect);
}

/*--------------------------------------------------------*/

void TWindow::Update(){
	Update(fMainView->Bounds());
}

/*--------------------------------------------------------*/

void TWindow::DrawOffScreen(BView *v){
	int i,j;
	/*
	 Do the actual drawing of the 'room'. The walls will get
	 drawn (with a gap if there is one) and the ball will
	 be placed in the proper position.
	*/
	fBitmap->Lock();

	BRect b = v->Bounds();

	b.right=140;
	b.bottom=160;
	v->FillRect(b, B_SOLID_LOW);



	v->SetHighColor(100,100,0);

	b.bottom -= 1.0;
	b.right -= 1.0;

	v->StrokeRect(v->Bounds());

	v->StrokeLine(BPoint(1,2),BPoint(140,2));
	v->StrokeLine(BPoint(140,2),BPoint(140,160));
	v->StrokeLine(BPoint(2,  1),BPoint(2,160));
	v->StrokeLine(BPoint(2,160),BPoint(140,160));
//      BouncePoly(th,4096*100,4096*100,2638,-3132);
//    v->StrokeLine(BPoint(100-2638,100+3132),BPoint(100+2638,100-3132));
	BPoint stt(100-2638*60.0/3132,160);
	BPoint fin(140,100-3132*40.0/2638);
	v->StrokeLine(stt,fin);

	for (i=0;i<nump;i++){
		MovePoly(mypoly+i);
	}
	for (i=0;i<nump;i++){
		DrawPoly(mypoly+i,v);
	}

	for (i=0;i<(nump-1);i++){
		for (j=i+1;j<nump;j++){
			BangPoly(mypoly+i,mypoly+j);
			BangPoly(mypoly+j,mypoly+i);  //**** UGLY***
		}
	}

	v->DrawString("Chris Blackbourn",BPoint(52,164));
	v->Sync();          // flush all drawing to the bitmap

	fBitmap->Unlock();
}

/*--------------------------------------------------------*/
/*--------------------------------------------------------*/
/*--------------------------------------------------------*/

TBitmapView::TBitmapView(BRect frame, BBitmap *bitmap)
	: BView(frame, "", B_FOLLOW_NONE, B_WILL_DRAW)
{
	/*
	 The only job of this view is to blit the offscreen
	 bits into the onscreen view.
	*/
	fBitmap = bitmap;
}

/*--------------------------------------------------------*/

void TBitmapView::Draw(BRect update)
{
	DrawBitmap(fBitmap, update, update);
}

/*--------------------------------------------------------*/
/*--------------------------------------------------------*/
/*--------------------------------------------------------*/
  /*
	char mybuf[4096];
	char *outptr=mybuf;

	char *ver="Unknown";
	#if DEBBUILD
		ver="Debug";
	#endif
	#if RELBUILD
		ver="Release";
	#endif
	outptr+=sprintf(outptr,"YATE93, %s Version\n",ver);
	outptr+=sprintf(outptr,"Compiled %s %s\n\n",__DATE__,__TIME__);

	outptr+=sprintf(outptr,"Written by:\n");
	outptr+=sprintf(outptr,"  Chris Blackbourn\n");
	outptr+=sprintf(outptr,"  blakatz@ihug.co.nz\n");
	outptr+=sprintf(outptr,"  http://www.geocities.com/TimesSquare/Arcade/1783");

//    outptr+=sprintf(outptr,"\n\nChanges by:\n");
//    outptr+=sprintf(outptr,"  (Insert Your Name Here)");

	BAlert *bal=new BAlert("About",mybuf,"OK");
	bal->Go();
*/
