// wsnote.h
// e.moon 18dec98
// 24dec98: added persistent frame rectangles for each workspace
// 25dec98: added 'Float' option

#ifndef __EMOON_WSNOTE_H__
#define __EMOON_WSNOTE_H__

class App;
class Window;
class View;

class View : public BView {
	typedef BView _inherited;
	
public:
	static const rgb_color		s_bgColor;
	static const rgb_color		s_bgColorHilight;
	static const rgb_color		s_textColor;
	static const rgb_color		s_borderColor;
	static const rgb_color		s_hilightColor;
	
	static const uint32				s_nBorderSize;
	static const uint32				s_nCornerSize;
	static const uint32				s_nScreenSnapThreshold;
	static const uint32				s_nMinWidth;
	static const uint32				s_nMinHeight;

	enum dragtype {
		DRAG_NONE,
		DRAG_MOVE,
		DRAG_UL,
		DRAG_TOP,
		DRAG_UR,
		DRAG_RIGHT,
		DRAG_LR,
		DRAG_BOTTOM,
		DRAG_LL,
		DRAG_LEFT
	};

	char 					buffer[16];
	BFont					m_font;
	font_height		m_fontHeight;
	
	// current drag op
	dragtype			m_drag;
	dragtype			m_dragHilight;
	BPoint				m_dragInitPoint;
	BRect					m_dragInitFrame;
	
	bool						m_bDragInDeskbar;
	BRect					m_deskbarFrame;
	
	// frame resize mech.
	BRect					m_prevBounds;
	bool						m_bSnapEdge;

	// context menu
	BPopUpMenu*		m_pMenu;
	
public:
	View(BRect frame, bool bSnap);
	
	void AllAttached();
	
	void Draw(BRect updateRect);
	void drawDragHilight(BRect b);
	
	void FrameResized(float fWidth, float fHeight);
	
	void MouseDown(BPoint p);
	void MouseUp(BPoint p);
	void MouseMoved(BPoint p, uint32 nTransit,
		const BMessage* pDragMsg);
		
	bool edgeSnap() const { return m_bSnapEdge; }
	void setEdgeSnap(bool bSnap) {
		m_bSnapEdge = bSnap;
	}

protected:
	// update drag operation
	void dragUpdate(BPoint p);
	// given hilight style, display a hint
	void updateDragHilight(dragtype t);
	// given point, figure drag type
	dragtype dragType(BPoint p);
	
	// set & remember new window frame rect
	void setFrame(BRect newFrame);
	
	// given current window frame rect,
	// 'snap' to screen edge if within threshold
	void snapToScreenEdge(BRect frame, BPoint& oDelta);
	
	// given window frame & delta, constrain resize
	// operation to minimum window size
	void constrainResize(BRect frame, BPoint& ioDelta);
	
	// show the 'About' box
	void doAbout();
	
	// find the frame rectangle of the deskbar tray view,
	// in screen coordinates
	bool getDeskbarFrame(BRect& r);
};

// -------------------------------------------------- //
// bare-bones window class
// -------------------------------------------------- //


class Window : public BWindow {
	typedef BWindow _inherited;

public:
	View*				m_pView;

public:
	Window(BRect frame, bool bSnap, bool bFloat) :
		BWindow(frame, "wsnote", B_NO_BORDER_WINDOW_LOOK,
			bFloat ? B_FLOATING_ALL_WINDOW_FEEL : B_NORMAL_WINDOW_FEEL,
			B_WILL_ACCEPT_FIRST_CLICK,
			B_ALL_WORKSPACES) {
		m_pView = new View(Bounds(), bSnap); 
		AddChild(m_pView);
	}
	
	bool QuitRequested();
	
	void WorkspaceActivated(int32 nWorkspace, bool bActive);
	void MessageReceived(BMessage* pMsg);
	void FrameMoved(BPoint p);
	void FrameResized(float width, float height);
	
	bool isFloating();

protected:
	void doAbout();
	void toggleSnap(BMessage* pMsg);
	void toggleFloat(BMessage* pMsg);
};

// -------------------------------------------------- //
// app class
// -------------------------------------------------- //

class App : public BApplication {
public:
	App();
	~App();

	void fetchSettings(bool& bSnap, bool& bFloat);
	
	BRect fetchFrame(int nWorkspace);
	void storeFrame(int nWorkspace, BRect r);
	void storeSettings(bool bSnap, bool bFloat);

public:
	static const int32 s_nDefWndWidth;
	static const int32 s_nDefWndHeight;
	
	BWindow*		m_pWnd;

	// stored frame rects for each workspace
	BRect*			m_pFrames;
	int					m_nFrames;
};



#endif /* __EMOON_WSNOTE_H__ */