/*
#define _WIN_32
#define _DOS_32
#define _UNIX
*/

/* use portable code */
#define NON_INTEL_BYTE_ORDER

#define FM_NORMAL   0x00
#define FM_RDONLY   0x01
#define FM_HIDDEN   0x02
#define FM_SYSTEM   0x04
#define FM_LABEL    0x08
#define FM_DIREC    0x10
#define FM_ARCH     0x20


#ifdef _WIN_32

typedef unsigned char    UBYTE;
typedef unsigned short   UWORD;
typedef unsigned long    UDWORD;

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <dos.h>
#include <io.h>
#include <time.h>
#include <sys/stat.h>
#include <signal.h>
#include <dos.h>
#include <dir.h>
#include <dirent.h>
#include <share.h>

#define ENABLE_ACCESS

#define HOST_OS     WIN_32

#define PATHDIVIDER  "\\"
#define CPATHDIVIDER '\\'
#define MASKALL      "*.*"

#define READBINARY   "rb"
#define READTEXT     "rt"
#define UPDATEBINARY "r+b"
#define CREATEBINARY "w+b"
#define APPENDTEXT   "at"

#endif


#ifdef _DOS_32
#define _WIN_32

typedef unsigned char    UBYTE;
typedef unsigned short   UWORD;
typedef unsigned long    UDWORD;

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <dos.h>
#include <io.h>
#include <time.h>
#include <sys/stat.h>
#include <signal.h>
#include <dos.h>
#if defined(__WATCOMC__)
#include <direct.h>
#elif defined(__DJGPP__)
#include <dirent.h>
#include <unistd.h>
#elif defined(__EMX__)
#include <dirent.h>
#include <unistd.h>
#else
#include <dir.h>
#endif

#define ENABLE_ACCESS

#define HOST_OS     MS_DOS

#define PATHDIVIDER  "\\"
#define CPATHDIVIDER '\\'
#define MASKALL      "*.*"

#define READBINARY   "rb"
#define READTEXT     "rt"
#define UPDATEBINARY "r+b"
#define CREATEBINARY "w+b"
#define APPENDTEXT   "at"

#endif


#ifdef _UNIX

typedef unsigned char    UBYTE;
typedef unsigned short   UWORD;
typedef unsigned long    UDWORD;

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <time.h>
#include <sys/stat.h>
#include <signal.h>
#include <utime.h>

UDWORD UnixTimeToDos(time_t UnixTime);
time_t DosTimeToUnix(UDWORD DosTime);

#define ENABLE_ACCESS

#define HOST_OS     UNIX

#define PATHDIVIDER  "/"
#define CPATHDIVIDER '/'
#define MASKALL      "*.*"

#define READBINARY   "r"
#define READTEXT     "r"
#define UPDATEBINARY "r+"
#define CREATEBINARY "w+"
#define APPENDTEXT   "a"

#endif
