/* 

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    linux_audio.c

    Functions to play sound on the VoxWare audio driver (Linux or FreeBSD)

*/

#include <Sound.h>
#include <SoundPlayer.h>
#include <scheduler.h>

#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include "config.h"
#include "output.h"
#include "controls.h"

static int open_output(void); /* 0=success, 1=warning, -1=fatal error */
static void close_output(void);
static void output_data(int32 *buf, int32 count);
static void flush_output(void);
static void purge_output(void);

/* export the playback mode */
#define dpm beos_play_mode_2

PlayMode dpm =
{
	DEFAULT_RATE,
	PE_16BIT | PE_SIGNED,
	-1,
	{0,0,0,0,0}, /* default: get all the buffer fragments you can */
	"BeOS Audio Device", 'h',
	"/dev/audio/raw/awe64/1",
	open_output,
	close_output,
	output_data,
	flush_output,
	purge_output  
};

/*************************************************************************/

static int open_output(void)
{
	int32 priority = suggest_thread_priority(B_LIVE_AUDIO_MANIPULATION);
	set_thread_priority(find_thread(0), priority);

	dpm.fd = open(dpm.name, O_WRONLY);
	if (dpm.fd<0)
	{
		printf("%s\n", strerror(errno));
		return -1;
	}

	return 0;
}


static void output_data(int32 *buf, int32 count)
{
	if (!(dpm.encoding & PE_MONO))
		count*=2; 		// Stereo samples

	/* Convert data to signed 16-bit PCM */
	s32tos16(buf, count); /* Little-endian data */
      
	while ((-1==write(dpm.fd, buf, count * 2)) && errno==EINTR);
}

static void close_output(void)
{
	set_thread_priority(find_thread(0), B_NORMAL_PRIORITY);
	close(dpm.fd);
}

static void flush_output(void)
{
}

static void purge_output(void)
{
}
