/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#ifndef _T2P_H
#define _T2P_H
#include "constant.h"

#define SP  ' '
#define TAB '\t'
#define CR  0x0d
#define LF  0x0a

class t2s
{
    private :
        char onechar ;
        int  position ;
        int  tab_pos ;
        
        char outchar[ OUTPUT_CHARS ] ;
        int  outcharc ;
        
        char sparry[ TABSTOP_MAX ] ;

        char *internalDestbuff ;

        int _getinterbuffsize( char src[], int tab_stop ) ;

    public :
        t2s() ;
        ~t2s() ;
        int tabtospace( FILE *out, 
                        FILE *in, 
                        const int   tab_stop ) ;

        int tabtospace( FILE *out, 
                        const char  src[], 
                        const int   srclen, 
                        const int   tab_stop ) ;

        int tabtospace(       char dest[],
                        const char src[], 
                        const int  srclen, 
                        const int  tab_stop ) ;
} ;

#endif