/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "convert.h"

convert::convert( entry_ref *openref, 
                  entry_ref *saveref, 
                  char      *savename ) 
       :fileUtil( openref, saveref, savename ), t2s()
{
}


convert::convert():fileUtil(), t2s()
{
}


convert::~convert()
{
}


char *convert::readSorceFile( entry_ref *openref )
{
    retmsg = openread( openref ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


char *convert::createSaveFile( entry_ref *saveref, char *savename )
{
    retmsg = savecreate( saveref, savename ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


void convert::tabTospace( int tabstop )
{
    buff = ( char * )filebuff( &buflen ) ;
    tabtospace( retsavefilep(), buff, buflen, tabstop ) ;
}
/*
 * End.
 */