/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "T2SWindow.h" 

T2SWindow::T2SWindow( BRect frame ) 
    :BWindow( frame, PGMNAME, B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE | B_DRAW_ON_CHILDREN ) 
{ 
    BRect viewFrame = Bounds() ; 
    
    view = new T2SView( viewFrame ) ; 
    if( find_directory( B_USER_SETTINGS_DIRECTORY, &path, true ) == B_OK ){
		path.Append( USER_SETTINGS ) ;
		ref = open( path.Path(), O_RDONLY ) ;
		if( ref >= 0 ){
		    read( ref, ( char * )&tabstop, sizeof( short ) ) ;
		    read( ref, (char *)&lefttop, sizeof( BPoint ) ) ;
		    view->setTabstop( tabstop ) ;
		    this->MoveTo( lefttop ) ;
		}
		else{
		    view->setTabstop( DEFAULT_TABSTOP ) ;
		}
    }
    AddChild( view ) ; 
} 


bool T2SWindow::QuitRequested() 
{
    if( find_directory( B_USER_SETTINGS_DIRECTORY, &path, true ) == B_OK ){
        path.Append( USER_SETTINGS ) ;
        ref = creat( path.Path(), 0777 ) ;
        if( ref >= 0 ){
            tabstop = view->retTabstop() ;
            write( ref, (char *)&tabstop, sizeof( short ) ) ;
            lefttop = Frame().LeftTop() ;
            write( ref, (char *)&lefttop, sizeof( BPoint ) ) ;
            close( ref ) ;
        }
    } 
    be_app->PostMessage( B_QUIT_REQUESTED ) ; 
    return true ; 
} 


void T2SWindow::MessageReceived( BMessage* msg ) 
{ 
    switch ( msg->what ){ 
        case MSG_OPEN_PRESSED :
            view->openpanel() ;	
            break ;
        case MSG_SAVE_PRESSED :
            view->savepanel() ;	
            break ;
        case MSG_EXEC_PRESSED :
            view->convertTab() ;
            view->resetSaveFname() ;
            break ;
        case MSG_QUIT_PRESSED :
            QuitRequested() ; // exit
            break ;
        case B_SIMPLE_DATA :    //Get open file name
            view->getOpenfname( msg ) ;
            break ;
        case B_SAVE_REQUESTED : //Get save file name
            view->getSavefname( msg ) ;
            break ;
        case MSG_TABSTOP_SLID :
            view->tabstopSlid( msg ) ;
            break ;
        default: 
            inherited::MessageReceived( msg ) ;
            break ; 
    } 
} 
/*
 * End.
 */