#include "addon.h"

// The main function isn't normally used by Tracker add-ons.
// I use it to pop up an alert telling the user how to
// use the add-on, in case they double-click on the icon.
// 
int main(void)
{
	new BApplication(kAppSig);
	BAlert *alert  = new BAlert("",
			"Run-R:\nI am a Tracker add-on!\n\n"
			"I like to live in home/config/add-ons/Tracker/. \n"
			"Put me there, and activate me through the Tracker's Add-ons "
			"menu, or by typing Alt-Opt-R or Command-Opt-R in a Tracker "
			"window. Thanks!", "OK");
	alert->SetShortcut(0,B_ESCAPE);
	alert->Go();
	delete be_app;
	return 0;
}

// This is the function called by the Tracker
// when the add-on is loaded. I'm only interested
// in dir_ref, which is an entry_ref to the current
// Tracker window. The BMessage contains entries
// for each icon that's selected; I ignore those.
// 
// Thank you to Pierre Brua for his TermHire source,
// which is an excellent Tracker add-on example. 
// 
void process_refs(entry_ref dir_ref, BMessage* msg, void*)
{
	BEntry theEntry(&dir_ref);
	BPath path;
	theEntry.GetPath(&path);
	
	RunWindow *theWindow = new RunWindow(path.Path());
	theWindow->Show();
	
	// Wait for the window to quit before returning.
	// The tracker unloads the add-on from memory as soon
	// as process_refs() returns. We don't want that to
	// happen with the window still around.
	//
	wait_for_thread(theWindow->Thread(), NULL);
	
	return;
}