//	ClockModule.cpp

#include "ClockModule.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <MenuItem.h>

#include <Beep.h>

const char *ClockModule::moduleName = "ClockModule";

const uint32 ClockModule::fontCmd = 'CMfn';
const uint32 ClockModule::sizeCmd = 'CMsz';
const char *ClockModule::fontMsg_family = "family";

const char *ClockModule::fontMenuName = "Font";
const char *ClockModule::sizeMenuName = "Size";
const char *ClockModule::sizeChoices[] = { "9", "10", "12", "14", "18", NULL };

ClockModule::ClockModule(const char *name, BEntry *entry)
	: StripModule(name,entry)
{
	menu = new BPopUpMenu("who cares?");
	menu->AddItem(makeFontMenu());
	menu->AddItem(makeSizeMenu());
	changeFont();
}

ClockModule::~ClockModule()
{
	delete menu;
}

void ClockModule::AttachedToWindow(void)
{
	setMenuTargets(menu);
}

void ClockModule::Draw(BRect clipRect)
{
	time_t theTime;
	char timeString[16];

	theTime = time(NULL);
	strftime(timeString,sizeof(timeString),"%H:%M",localtime(&theTime));
	DrawString(timeString,BPoint(0,fontHeight.ascent-fontHeight.leading));
}

void ClockModule::MessageReceived(BMessage *message)
{
	status_t err;
	BMenuItem *item;
	char *family;
	int size;

	switch (message->what)
	{
		case fontCmd:
			err = message->FindPointer("source",&item);
			if (err != B_OK)
				break;
			err = message->FindString("family",&family);
			if (err != B_OK)
				break;
			font.SetFamilyAndStyle(family,item->Label());
			changeFont();
			break;
		case sizeCmd:
			err = message->FindPointer("source",&item);
			if (err != B_OK)
				break;
			size = atoi(item->Label());
			font.SetSize(size);
			changeFont();
			break;
	}
}

void ClockModule::MouseDown(BPoint where)
{
	menu->Go(ConvertToScreen(where),true);
}

void ClockModule::Pulse(void)
{
	Invalidate();
}

BMenu *ClockModule::makeFontMenu(void)
{
	status_t err;
	uint32 flags;
	int32 i, numFonts, j, numStyles;
	font_family family;
	font_style style;
	BMenu *subMenu;
	BMenu *theMenu;
	BMessage *message;

	theMenu = new BMenu(fontMenuName);
	numFonts = count_font_families();
	for (i = 0; i < numFonts; i++)
	{
		err = get_font_family(i,&family,&flags);
		if (err == B_OK)
		{
			subMenu = new BMenu(family);
			numStyles = count_font_styles(family);
			for (j = 0; j < numStyles; j++)
			{
				err = get_font_style(family,j,&style,&flags);
				if (err == B_OK)
				{
					message = new BMessage(fontCmd);
					message->AddString(fontMsg_family,family);
					subMenu->AddItem(new BMenuItem(style,message));
				}
			}
			theMenu->AddItem(subMenu);
		}
	}
	return theMenu;
}

BMenu *ClockModule::makeSizeMenu(void)
{
	BMenu *theMenu;
	int i;

	theMenu = new BMenu(sizeMenuName);
	for (i = 0; sizeChoices[i]; i++)
		theMenu->AddItem(new BMenuItem(sizeChoices[i],new BMessage(sizeCmd)));
	theMenu->SetTargetForItems(this);
	return theMenu;
}

void ClockModule::changeFont(void)
{
	int width, height;

	SetFont(&font);
	font.GetHeight(&fontHeight);
	width = font.StringWidth("88:88");
	height = fontHeight.ascent+fontHeight.descent+fontHeight.leading;
	ResizeTo(width,height);
}

void ClockModule::setMenuTargets(BMenu *theMenu)
{
	int n, i;
	BMenuItem *item;

	if (theMenu)
	{
		n = theMenu->CountItems();
		for (i = 0; i < n; i++)
		{
			item = theMenu->ItemAt(i);
			item->SetTarget(this);
			setMenuTargets(item->Submenu());
		}
	}
}

BView *create_module(BEntry *entry)
{
	return new ClockModule(ClockModule::moduleName,entry);
}
