// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
//PierApp.cpp ----------------------------------------------------------------
#include "PierApp.h"
#include "PierSignature.h"
#include "PierAnchored.h"
#include "PierPane.h"  //Development only.
#include "PierStackPane.h"
#include "PierClock.h"
#include "PierWork.h"

//#include "PierWork.h"

// Constructor
PierApp::PierApp() : BApplication(PIER_SIGNATURE) {
	// Should read saved (archive) file.  If that isn't available, or if the
	// open for that fails, then should open with a default window...
	
	// Default configuration: PierAnchored with plain PierPane
	status_t stat;
	BRect rect(0.,0.,PIER_WIDTH,200.);
	PierAnchored  *rightPier = new PierAnchored("Pier",PIER_RIGHT);
	rightPier->AddPane(new PierWork()); //Workspaces pane
	rightPier->AddPane(new PierClock());
	PierStackPane *stack = new PierStackPane(rect,"Stack 2");
	stack->AddPane(new PierWork()); //Workspaces pane
	stack->AddPane(new PierPane(rect,"Bogus 2"));
	stack->AddPane(new PierPane(rect,"Bogus 3"));
	stack->AddPane(new PierClock());
	stack->AddPane(new PierPane(rect,"Bogus 4"));
	float width, height;
	stack->GetPreferredSize(&width,&height);
	stack->ResizeTo(width,height);
	stack->SetAutoGrow(true);
	rightPier->AddPane(stack);
	rightPier->AddPane(new PierPane(rect,"Bogus 1"));
	rightPier->Show();	
	
	// PulseRate
	SetPulseRate(500000);
}

// Pulse
void
PierApp::Pulse(void) {
	// There's probably a better way to do this...
	if (CountWindows() == 0) 
		PostMessage(B_QUIT_REQUESTED);
}