// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierAnchored.h ------------------------------------------------------------
#pragma once

#include "PierWindow.h"
#include "PierStackPane.h"

class PierAnchored : public PierWindow {
public:
	PierAnchored(const char* title, pier_loc anchor);
	PierAnchored(BMessage* archive);
	
	//Hook Functions
	virtual status_t	Archive(BMessage * archive, bool deep = true) const;
	static  PierAnchored*	Instantiate(BMessage* archive);
	virtual void	ScreenChanged(BRect frame, color_space mode);
	virtual void	WorkspaceActivated(int32 workspace, bool active);

	// Pane handling functions
	virtual status_t	AddPane(PierPane* pane);
	virtual status_t	RemovePane(PierPane* pane);
	virtual void		PaneResized(PierPane* pane, float dwidth, float dheight);
	virtual BRect		PaneResizeLimits(void);

protected:
	PierStackPane*	stack;
	//Window location and sizing
	void			SetGapSize(pier_size gapSize);
	void			Reanchor(BRect screenFrame = BRect());
	pier_loc		anchor;
	pier_loc		gapLoc;
	pier_size		gapSize;
	float			gap;
	float			customGap;
};

