/*
 * NS2NP - Converts Netscape Bookmarks 
 *         to NetPositive-"Bookmarks"
 *         i.e. creates the corresponding directories and files
 *
 * small, but useful utility :)
 * (C)opyleft 1998 by Rosso
 * <http://www.bigfoot.com/~mcrosso>
 *
 * Version HISTORY:
 *
 * Date		Version		Comments
 *
 * 21.2.99	1.1.0		+ option '-l' implemented (limits length of bookmark-names)
 *						+ the above feature finally pushed me to rewrite the argument-parser
 *						  to use the standard UNIX-"getopt" -> much more flexible and extensible now
 *						+ made the proggy a bit faster ? (seems so here)
 *						+ some code-cleanup and small (possible) bug-fixes
 *						R SECOND public release
 * 19.2.99	1.0.5		+ UFT-8-conversion works -> special characters are treated right now :)
 *						+ raised string-size (again too small!)
 * 13.1.99	1.0.4		+ BUG found: wrong parameter-types for File->Read (now using ssize_t !)
 						+ Summary with total number of urls and dirs is now displayed at the end
 						+ if the destination-path does not exist, the directory will be created
 						R FIRST public release (my FIRST BeWare !) :-)
 						# PROBLEM: special characters are not converted correctly :(
 * 12.1.99  1.0.2		+ argument-checking, brushed up source, small documentation
 						# BUG: crashes the first time it is run, but works ?!
 * 10.1.99	1.0.0		+ dir-structure build correctly, parser-bug found (URL/TOKEN was too small),
 						+ "/" is recognised as forbidden character and replaced by a "\"
 * 3.1.99	0.0.5		+ engine works, urls parsed correctly
 						# dir-structure wrong, parser gets quite crazy after some 50% of my Bookmarks-
 						  file (ca. 700 Links)
 */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>

#include <storage/Directory.h>
#include <storage/Entry.h>
#include <storage/File.h>
#include <storage/Node.h>
#include <storage/Path.h>

#include <support/UTF8.h>

#define LEN_BUF   1024
#define LEN_TOKEN 511	// must be able to hold long URLs like in <A HREF="...">
#define LEN_DATA  511	// lets stay on the safe side here, too

#ifndef true 
	#define true  1
	#define false 0
#endif

const char	*VERSION = "1.1.0";

// TODO:+ File-Check: Is a Netscape-bookmark-file ? (-> else: warning)
//		+ ExploDer-Bookmarks ? -> on request
//		+ make this a real BeApp with a nice GUI ...!

int strmod(char source[LEN_DATA], char filter, char mod)
{
	int  c = 0, mod_count = 0;
	
	while (source[c] != '\0')
	{
		if (source[c] == filter)
		{
			source[c] = mod;
			mod_count++;
		}
		
		c++;
	}
	return mod_count;
}

void USAGE(char *progname)
{
	printf("%s %s (C)opyright 1999 by Gregor B. Rosenauer (mcrosso@bigfoot.com)\n", progname, VERSION);
	printf("JoyWare - Use and Enjoy ;) And if you like it, please send me a note :-)\n\n");

	printf("Usage: %s [-h] [-v] [-l <length>] <Netscape-Bookmark-File> [Be-Bookmark-Path]\n\n", progname);
	
	printf("-h\t shows this help\n");
	printf("-v\t turns on verbose mode (shows files and directories created)\n");
	printf("-l\t limits the length of the created bookmark-files to <length>, default is 32\n\n");
	
	printf("<Netscape-Bookmark-File> specifies where your Bookmarkfile is located.\n");
	printf("<Be-Bookmark-Path>       specifies the root of the Be-Bookmark-directory.\n");
	printf("       It defaults to NetPositive's settings-directory and you should not\n");
	printf("       need to change it unless you use another browser (BeZilla finally ?:).\n\n");
	
	printf("Note 1:\t Currently only Netscape Bookmarkfiles are supported.\n");
	printf("Note 2:\t Bookmark-files are OVERWRITTEN and updated, so please back up\n");
	printf("       \t your old bookmarkfiles to go sure nothing unwanted happens.\n");
	printf("       \t NetPositive's Bookmark-directory normally is:\n");
	printf("       \t \"/boot/home/config/settings/NetPositive/Bookmarks/\"\n");
}

int main(int argc, char **argv)
{
	const char	bookmark[B_ATTR_NAME_LENGTH] = "application/x-vnd.Be-bookmark";
	const char	pref_app[B_ATTR_NAME_LENGTH] = "application/x-vnd.Be-NPOS";

	BFile		*fileBookmarks;		// Input and
	BFile		*fileNewBookmarks;	// output file(s)
	BPath		*pathBookmarks;
	BDirectory	*dirBookmarks;
	BNode		*bookNode = NULL;
	ssize_t		buf_read = 0;
	char		opt, buffer[LEN_BUF], token[LEN_TOKEN], data[LEN_DATA], new_name[LEN_DATA];
	enum		num_mode {MOD_COMMENT = 0, MOD_TOKEN, MOD_DATA, MOD_PROCESS};			// parse-modes
	enum		num_FLAG {FLG_HELP = 0, FLG_ERR, FLG_LENGTH, FLG_OK};
	uint		ch, mode = MOD_COMMENT, pos_buf = 0, pos_token = 0, pos_data = 0,		// initialise parser
				total_urls = 0, total_dirs = 0, MAX_LENGTH = LEN_DATA, FLAG = FLG_OK;
	int32		slength, dlength, state = 0, arg;
	char		*c = NULL, *url = NULL;
	bool		VERBOSE = false;
	status_t 	err;
	
	// BApplication app("application/x-whatever");
	
	// ********* Handle Args

	if (argc == 1)
	{
		USAGE(argv[0]);				// print Usage
		return 1;
	}
	
	FLAG = FLG_OK;
	
	while ( ( opt = getopt (argc, argv, "hvl:") ) != EOF)
	{
		switch (opt)
		{
			case 'v':
				VERBOSE = true;
				break;
			case 'h':
				USAGE(argv[0]);
				FLAG = FLG_HELP;
				break;
			case 'l':
				MAX_LENGTH = atoi (optarg);
				if (MAX_LENGTH == 0)			// no argument to "-l" given
				{								// -> we accept that and set the default
					MAX_LENGTH = 32;
					FLAG = FLG_LENGTH;			// -> so we have to adjust optind later
				}
				break;
			case '?':			// unknown arg
				printf("%s %s: Unknown option !\n", argv[0], VERSION);
				FLAG = FLG_ERR;
		}
	}
	
	if (FLAG == FLG_LENGTH)
	{
		optind--;		// work around getop's limitation of not accepting default-values for options
		FLAG = FLG_OK;
	}
	
	if (optind > argc-1) FLAG = FLG_ERR;	// only options were given - input-file MUST be specified !

	if (FLAG != FLG_OK)
	{
		USAGE ( argv[0] );
		return FLAG;
	}

	arg = optind;
	
	// open input file
	fileBookmarks = new BFile(argv[arg], B_READ_ONLY);
	
	if ((err = fileBookmarks->InitCheck()) != B_NO_ERROR)
	{
		fprintf(stderr, "%s: Error opening file %s: %s\n", argv[0], argv[arg], strerror(err));
		return 1;
	}

	arg++;
	
	if (arg > argc-1)								// no path specified -> use default path
		pathBookmarks = new BPath("/boot/home/config/settings/NetPositive/Bookmarks");
	else
		pathBookmarks = new BPath(argv[arg]);		// use user-path
		
	dirBookmarks  = new BDirectory(pathBookmarks->Path());

	err = dirBookmarks->CreateDirectory(pathBookmarks->Path(), dirBookmarks);
	if (err != B_OK)
	{
		if (err != B_FILE_EXISTS)
		{
			fprintf(stderr, "%s: Error creating directory \"%s\": %s !\n", argv[0], data, strerror(err));
			return 1;
		}
	}
	else printf("[Destination-Directory created.]\n");


	// ********* Parse bookmark-file	

	token[0] = '\0'; data[0] = '\0';
	
 	// read as long as there is data...
	while ((buf_read = fileBookmarks->Read((void *)buffer, LEN_BUF)) > 0)
	{
		//printf("Reading from file...\n");	// DB

		for (pos_buf = 0; pos_buf < LEN_BUF; pos_buf++)
		{
			// read next char
			ch = buffer[pos_buf];

			// '<' - beginning of token ?
			if (ch == '<')
			{
				if (mode == MOD_DATA)
					mode = MOD_PROCESS;
				else
					mode = MOD_TOKEN;
			}
			else if (ch == '>')
				{
					if (mode != MOD_COMMENT) mode = MOD_DATA;
				}
			else
			{
				switch (mode)
				{				
					case MOD_TOKEN:
						if (pos_token == 3)			// check for comment
						{
							if (token[0]=='!' && token[1]=='-' && token[2]=='-')
							{
								mode = MOD_COMMENT;			// ignore rest of comment
								pos_token = pos_data = 0;
								token[0] = data[0] = '\0';
							}
						}
						if (mode != MOD_COMMENT)
						{
							token[pos_token++] = ch;
						}
						
						break;
						
					case MOD_DATA:
						data [pos_data++]  = ch;
						
						break;
						
					case MOD_PROCESS:
						// data should not be null (for files/dirs)
						if (pos_data == 0) data[pos_data++] = ' ';
						
						token[pos_token] = '\0';
						data [pos_data]  = '\0';

						// we assume that the text is imported from Windows-Netscape
						// maybe make this a switch ?

						slength = pos_data;
						dlength = MAX_LENGTH;		// gets modified by convert_to_utf8 !
						state = 0;
						
						err = convert_to_utf8(B_MS_WINDOWS_CONVERSION, data, &slength, new_name, &dlength, &state);
						if (err != B_OK)
						{
							printf("ERROR: Couldn't convert URL \"%s\": %s.\n", data, strerror(err));
						}
						else
						{
							new_name[dlength] = '\0';
						}
						
						if ( strcmp(token, "/H3") != 0)
						{	if (strstr(token, "H3") != 0)				// new tree
							{
								(void) strmod(new_name, '/', '\\');			// '/' in the name would specify a directory and must be changed !
								
								pathBookmarks->Append(new_name);
								
								if (VERBOSE)
								{
									printf("Creating DIR \"%s\"\n", pathBookmarks->Path());
								}
								delete(dirBookmarks);
								dirBookmarks = new BDirectory(pathBookmarks->Path());
								
								err = dirBookmarks->CreateDirectory(pathBookmarks->Path(), dirBookmarks);
								if ((err != B_OK) && (err != B_FILE_EXISTS))
								{
									fprintf(stderr, "%s: Error creating directory \"%s\": %s !\n", argv[0], new_name, strerror(err));
								}
								else total_dirs++;
							}
						}
						if ( strcmp(token, "/DL") == 0)				// End of (Sub-)Tree
						{
							pathBookmarks->GetParent(pathBookmarks);
							///printf("--- Parent Path: %s\n", pathBookmarks->Path());			// DB
						}
						else if ( (c = strstr(token, "A HREF")) != NULL)
						{
							if (  (c = strstr(token, "\"")) != NULL)
							{
								int counter = 0;

								url = c;
								
								while ((url[counter] = *++c) != '\"')
									counter++;
								url[counter] = '\0';
								
								// build new (absolute) filename
								(void) strmod(new_name, '/', '\\');		// '/' in the name would specify a directory and must be changed !
								///printf("-> Normalized Path is : %s\n", new_name);	// DB
								
								pathBookmarks->Append(new_name);

								if (VERBOSE)
								{
									printf("\tAdding Bookmark \"%s\"\n", new_name);
								}
								fileNewBookmarks = new BFile(pathBookmarks->Path(), B_READ_WRITE);

								err = dirBookmarks->CreateFile(pathBookmarks->Path(), fileNewBookmarks, false);
								if (err != B_NO_ERROR)
								{
									/* The Bookmark-file could not be created */
									fprintf(stderr, "%s: File \"%s\" could not be created: %s !\n", argv[0], new_name, strerror(err));
								}
								else
								{
									// transform the file into a node so we can write the attributes									
									bookNode = new BNode(pathBookmarks->Path());
									
									// write attributes
									// this might look a bit hacky but I doubt NetPositive does it differently ;)
									bookNode->WriteAttr("BEOS:TYPE",     B_STRING_TYPE, 0, bookmark, B_ATTR_NAME_LENGTH);
									bookNode->WriteAttr("BEOS:PREF_APP", B_STRING_TYPE, 0, pref_app, B_ATTR_NAME_LENGTH);
									bookNode->WriteAttr("META:url",      B_STRING_TYPE, 0, url, B_ATTR_NAME_LENGTH);
									bookNode->WriteAttr("META:title",    B_STRING_TYPE, 0, new_name, B_ATTR_NAME_LENGTH);

									delete(bookNode);
									total_urls++;
								}

								delete(fileNewBookmarks);
								pathBookmarks->GetParent(pathBookmarks);  // get "parent" from file!
							///	printf("\t  Path (Parent):%s\n", pathBookmarks->Path());	// DB
							}
							else
								fprintf(stderr, "%s: Malformed Link !\n", argv[0]);
						}
							
						pos_token = pos_data = 0;
						data[pos_data]	= '\0';
						new_name[0]		= '\0';

						mode = MOD_TOKEN;
						token[pos_token++] = ch;
						
						break;
						
					case MOD_COMMENT:
						
						break;
				}
			}
		}
	}

	delete fileBookmarks;
	if (dirBookmarks  != NULL) delete dirBookmarks;
	if (pathBookmarks != NULL) delete pathBookmarks;
	
	if (VERBOSE) printf("\nSummary: %d dirs and %d urls created.\n", total_dirs, total_urls);	

	return 0;
}
