#include "ScrollConfig.h"

// Scrolling StringView
class ScrollerView : public BView
{
public:
	ScrollerView(BRect bounds,
		const char *name, 
		const char *text,
		ulong resizeFlags =
			B_FOLLOW_LEFT | B_FOLLOW_TOP,
		ulong flags = B_WILL_DRAW);
	virtual ~ScrollerView();
	virtual void AttachedToWindow();
	virtual void MessageReceived(BMessage *message);
	virtual void Draw(BRect);

private:
	static long scroller_thread(void* viewptr);
	float step;
	double delay;
	float pos;
	thread_id thread;
	char* text;
	float baseoffset;
	float width;
	float vwidth;
};


#define SCROLL_IT 1

ScrollerView::ScrollerView(BRect bounds,
								const char *name, 
								const char *atext,
								ulong resizeFlags,
								ulong flags)
	: BView(bounds, name, resizeFlags, flags),
	  step(1),
	  pos(0),
	  delay(30000),
	  thread(-1)
{
	text = new char [::strlen(atext)]; 
	::strcpy(text, atext);
}

ScrollerView::~ScrollerView()
{
	if (thread != -1)
		kill_thread(thread);
	delete [] text;
}

void ScrollerView::AttachedToWindow()
{
	BView::AttachedToWindow();

	SetViewColor(Parent()->ViewColor());

	BFont font;
	font_height info;

	width = StringWidth(text);
	vwidth = Frame().Width();	

	GetFont(&font);
	font.GetHeight(&info);

	baseoffset = info.descent;
	
	// Start the thread
	thread = spawn_thread(scroller_thread, 
	                       "Scroller", 
	                       B_LOW_PRIORITY, 
	                       this);
	resume_thread(thread);
}

void ScrollerView::MessageReceived(BMessage *message)
{
	if (message && (message->what == SCROLL_IT))
	{	
		if (pos > (width + vwidth))
		{
			pos = 0;
		}
			
		ScrollTo(pos, 0);
	
		pos += step;		
	}
}

void ScrollerView::Draw(BRect updaterect)
{
#pragma unused (updaterect)
	BPoint textpos(Frame().Width(), Frame().Height() - baseoffset);

	DrawString(text, textpos);
}
		
long ScrollerView::scroller_thread(void* viewptr)
{
	if (viewptr)
	{
		ScrollerView* view = (ScrollerView*)viewptr;
		
		for(;;)
		{
			::snooze(view->delay);
			BWindow* w = view->Window();
			if (w)	
				w->PostMessage(SCROLL_IT, view);
		}
	}
	return 0;
}



ScrollConfig::ScrollConfig(BlanketModule* owner, BView* view, const char* scrolltext)
 : BlanketModule::Config(owner, view, true)
{
	if(view->Window()->Lock())
	{
		BRect vrect = view->Bounds();

		// Create string view for credits
		BFont font;
		font_height info;
	
		view->GetFont(&font);
		font.GetHeight(&info);

		float lineheight = info.ascent + info.descent + info.leading;
		lineheight = lineheight * 1.3;
	
		BRect srect(vrect.left, vrect.bottom - (lineheight - 1), vrect.right, vrect.bottom);
		view->AddChild(new ScrollerView(srect, B_EMPTY_STRING, scrolltext));				

		// Display preview
		BRect crect(vrect.left, vrect.top, vrect.right, vrect.bottom - (lineheight + 1));
		view->AddChild(GetPreview(crect, B_FOLLOW_ALL, B_WILL_DRAW));
		view->Window()->Unlock();
	}
}
