//	JuliaDomna.cc

#include "JuliaDomna.h"
#include "ScrollConfig.h"
#include <math.h>

#define		JD_ABOUT_STRING				"JuliaDomna version 1.0.1, by E. Tomlinson"

double random_double(double, double);

DomnaSaver::DomnaSaver(BlanketModule *owner, BView *view)
	: BlanketModule::Saver(owner,view)
{
	srand(time(NULL));
	side = 3.0;
	iterations = 100;
	started = false;
	thread = -1;
}

DomnaSaver::~DomnaSaver()
{
	BWindow *window = View()->Window();
	if (window)
		window->Lock();
	kill_thread(thread);
	if (window)
		window->Unlock();
}

void DomnaSaver::Tick(void)
{
	int32 result;
	
	if (!started)
	{
		wait_for_thread(thread,&result);
		thread = spawn_thread(threadHook,"DomnaSaverThread",B_NORMAL_PRIORITY,this);
		resume_thread(thread);
		started = true;
	}
}

int32 DomnaSaver::threadHook(void *arg)
{
	BView *view;
	BWindow *window;
	BRect bounds;
	int width, height, s, p, q, i, ix;
	double a, b, x, xx, y, x0, y0, t, f, inc, size, last, ss;
	rgb_color color = { 0x00, 0x00, 0x00, 0x00 };
	rgb_color black = { 0x00, 0x00, 0x00, 0x00 };
	const color_map *clut = system_colors();
	DomnaSaver *obj = (DomnaSaver *)arg;
	
	view = obj->View();
	window = view->Window();
	if (window)
		window->Lock();
	bounds = view->Bounds();
	if (window)
		window->Unlock();
	width = bounds.IntegerWidth();
	height = bounds.IntegerHeight();
	s = (width < height) ? width : height;
	inc = obj->side/s;
	a = random_double(-2.0,0.5);
	b = random_double(-1.25,1.25);
	x0 = -(width/2)*inc;
	t = -(height/2)*inc;
	for (p = 0; p <= width; p++)
	{
		y0 = t;
		for (q = 0; q <= height; q++)
		{
			x = x0;
			y = y0;
			last = x*x+y*y;
			for (i = 0; i < 256; i++)
			{
				size = x*x+y*y;
				if (size > 100.0)
					break;
				last = size;
				xx = x*x - y*y + a;
				y = 2*x*y + b;
				x = xx;
			}
			if (i == 256)
				color = black;
			else
			{
				ss = sqrt(last);
				f = (10.0-ss)/(sqrt(size)-ss);
				ix = 20*(i+f);
				color.red = (ix % 256);
				color.green = (color.red*color.red)/256;
			}
			if (window)
				window->Lock();
			view->SetHighColor(color);
			view->StrokeLine(BPoint(p,q),BPoint(p,q));
			if (window)
				window->Unlock();	
			y0 += inc;
		}
		x0 += inc;
	}
	
	obj->started = false;
	return 0;
}

JuliaDomna::JuliaDomna(BMessage *message)
	: BlanketModule(message)
{
}

status_t JuliaDomna::Archive(BMessage *message, bool deep) const
{
	status_t err;
	
	err = BlanketModule::Archive(message,deep);
	if (err != B_OK)
		return err;
		
	return B_OK;
}

BlanketModule::Saver *JuliaDomna::InstantiateSaver(BView *view, bool wantPreview)
{
	return new DomnaSaver(this,view);
}

BlanketModule::Config *JuliaDomna::InstantiateConfig(BView *view)
{
	return new ScrollConfig(this,view,JD_ABOUT_STRING);
}

BArchivable *BlanketModule::Instantiate(BMessage *message)
{
	return new JuliaDomna(message);
}

double random_double(double min, double max)
{
	double f;
	double range = max-min;
	
	f = (double)rand() / (double)RAND_MAX;
	f = range*f + min;
	
	return f;
}
