/*
 *  Plasma.cpp - Simple plasma fire
 *
 *  Written by Christian Bauer in 1998. Public domain.
 */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <TranslationKit.h>
#include <StorageKit.h>

#include "Demo.h"


// Global variables

uint32 *buffer[2];
int draw_buffer = 1;


/*
 *  Initialize effect
 */

void DemoWindow::init_demo(void)
{
	theEngine = new idx3d(DISPLAY_X, DISPLAY_Y);
	back->setIdx3d(theEngine);

	BBitmap *env = LoadBitmap("env.png");
	if (env != NULL)
		theEngine->setEnvironment(env);
	BBitmap *map = LoadBitmap("map.jpg");
	if (map != NULL)
		theEngine->addTexture(map);
	BBitmap *back = LoadBitmap("back.png");
	if (back != NULL)
		theEngine->setBackground(back);

	addObject();
	addLights();

	theEngine->ambient=48;
	theEngine->setPhong(40);
	theEngine->reflectivity=240;
	theEngine->setStatic();
	theEngine->rotateWorld(26.,-200.,0);
	theEngine->scaleWorld(1.2);

	// Allocate buffers
	buffer[0] = new uint32[DISPLAY_X * DISPLAY_Y];
	buffer[1] = new uint32[DISPLAY_X * DISPLAY_Y];
	memset(buffer[0], 0, DISPLAY_X * DISPLAY_Y);
	memset(buffer[1], 0, DISPLAY_X * DISPLAY_Y);
}


/*
 *  Main calculation
*/

bool DemoWindow::redraw_demo (void *bits, int32 bytes_per_row, color_space pixel_format)
{

	if (pixel_format != B_RGB32)
		return false;


	theEngine->rotateObject(1,4,9,-1);
	theEngine->rotateWorld(3,-5,2);
	theEngine->renderScene();
	
	// Blit buffer to screen
	uint32 *p = (uint32 *)theEngine->TargetPixel;
	uint32 *q = (uint32 *)bits;
	for (int y=0; y<DISPLAY_Y; y++) {
		for (int x=0; x<DISPLAY_X; x++) {
			q[x] = *p++;
		}
		q += (bytes_per_row/4);
	}

	// Blit buffer to screen
//	memcpy ((uint8 *)bits, buffer[draw_buffer], DISPLAY_X * DISPLAY_Y);


	// Switch to other buffer
	draw_buffer ^= 1;
	return true;
}


/*
 *  Deinitialize effect
 */

void DemoWindow::exit_demo(void)
{
	// Delete buffers
	delete[] buffer[0];
	delete[] buffer[1];
}


void DemoWindow::addObject()
{
		theEngine->addObject(4, theEngine->getIntColor(20,96,250));

//cone
		theEngine->addNode(1,(float)0.4,(float)0.0,(float)-1.0);
		theEngine->addNode(1,(float)0.6,(float)0.3,(float)-1.0);
		theEngine->addNode(1,(float)0.8,(float)0.4,(float)-1.0);
		theEngine->addNode(1,(float)0.9,(float)0.3,(float)-1.0);
		theEngine->addNode(1,(float)1.0,(float)0.0,(float)-1.0);
		theEngine->addNode(1,(float)0.9,(float)-0.3,(float)-1.0);
		theEngine->addNode(1,(float)0.8,(float)-0.4,(float)-1.0);
		theEngine->addNode(1,(float)0.6,(float)-0.3,(float)-1.0);
		theEngine->addNode(1,(float)0.4,(float)0.0,(float)-1.0);
		theEngine->addNode(1,(float)0.0,(float)0.0,(float)1.0);
		
		theEngine->addTriangle(1, 1, 2, 10);
		theEngine->addTriangle(1, 2, 3, 10);
		theEngine->addTriangle(1, 3, 4, 10);
		theEngine->addTriangle(1, 4, 5, 10);
		theEngine->addTriangle(1, 5, 6, 10);
		theEngine->addTriangle(1, 6, 7, 10);
		theEngine->addTriangle(1, 7, 8, 10);
		theEngine->addTriangle(1, 8, 9, 10);

		theEngine->generateNodeNormals(1);

		theEngine->scaleObject(1,(float)0.68);
		theEngine->rotateObject(1,-32,40,25);
		theEngine->object[1]->color = 0x00d4aa14;
		theEngine->object[1]->texture=1;


 // tore
		theEngine->addObject(5, theEngine->getIntColor(20,96,250));

		theEngine->addNode(2,(float)0.4,(float)0.0,(float)0.0);
		theEngine->addNode(2,(float)0.6,(float)0.300001,(float)0.0);
		theEngine->addNode(2,(float)0.8,(float)0.4,(float)0.0);
		theEngine->addNode(2,(float)0.9,(float)0.3,(float)0.0);
		theEngine->addNode(2,(float)1.0,(float)0.0,(float)0.0);
		theEngine->addNode(2,(float)0.9,(float)-0.3,(float)0.0);
		theEngine->addNode(2,(float)0.8,(float)-0.4,(float)0.0);
		theEngine->addNode(2,(float)0.6,(float)-0.30001,(float)0.0);
		theEngine->addNode(2,(float)0.4,(float)0.0,(float)0.0);
		
		theEngine->generateRotationObject(2,20);

		theEngine->generateNodeNormals(2);

		theEngine->scaleObject(2,(float)0.88);
		theEngine->rotateObject(2,-90,0,0);
		theEngine->object[2]->color = 45452014;
//		theEngine->object[1]->color = 0x252525;
		theEngine->object[2]->texture=1;
}

void DemoWindow::addLights()
{
		idx3d_vector *v = new idx3d_vector((float)3,(float)-4,(float)-1);
		theEngine->addLight(v,1,60);
		v = new idx3d_vector((float)-2,(float)3,(float)4);
		theEngine->addLight(v,1,200);
}

BBitmap *DemoWindow::LoadBitmap(char *filename)
{
	BBitmap *result = NULL; 						// The translated bitmap
	BBitmapStream *bstream=new BBitmapStream(); 		// Bitstream 
	BTranslatorRoster *roster = BTranslatorRoster::Default();	// Get the default roster
	BFile ifile(filename, B_READ_ONLY); 				// Open bitmap file

	// Check that file was opened nicely
	if ( ifile.InitCheck()!=B_OK ) {
		printf("Error when opening input\n");
		return NULL;
	} else {

		// Translate inputfil 
		roster->Translate(&ifile, NULL, NULL, bstream, 
			B_TRANSLATOR_BITMAP);
	
		// Hand us a convenient BBitmap
		bstream->DetachBitmap(&result); 

		delete bstream;
		return result; 
	}
}
