// Connection.cpp
// e.moon 25jun99

#include "Connection.h"
#include "NodeManager.h"
#include "NodeRef.h"

#if CORTEX_XML
	#include "ExportContext.h"
	#include "MediaFormatIO.h"
	#include "xml_export_utils.h"
#endif /*CORTEX_XML*/

#include <Debug.h>

// -------------------------------------------------------- //

__USE_CORTEX_NAMESPACE
	
// -------------------------------------------------------- //
// ctor/dtor
// -------------------------------------------------------- //

Connection::~Connection() {

//	PRINT(("~Connection(): '%s'->'%s'\n",
//		outputName(), inputName()));
//	
	// deallocate hints	
	if(m_outputHint) delete m_outputHint;
	if(m_inputHint) delete m_inputHint;
}

Connection::Connection() :
	m_disconnected(true),
	m_id(0),
	m_outputHint(0),
	m_inputHint(0) {}

Connection::Connection(
	uint32										id,
	media_node								srcNode,
	const media_source&				src,
	const char*								outputName,
	media_node								destNode,
	const media_destination&	dest,
	const char*								inputName,
	const media_format&				format,
	uint32										flags) :

	m_disconnected(false),
	m_id(id),
	m_sourceNode(srcNode),
	m_source(src),
	m_outputName(outputName),
	m_outputHint(0),
	m_destinationNode(destNode),
	m_destination(dest),
	m_inputName(inputName),
	m_inputHint(0),
	m_format(format),
	m_flags(flags) {

	ASSERT(id);	
}

Connection::Connection(
	const Connection&					clone) {
	operator=(clone);
}
	
Connection& Connection::operator=(
	const Connection&					clone) {

	m_disconnected = clone.m_disconnected;
	m_id = clone.m_id;
	m_sourceNode = clone.m_sourceNode;
	m_source = clone.m_source;
	m_outputName = clone.m_outputName;
	m_outputHint = 0;
	m_destinationNode = clone.m_destinationNode;
	m_destination = clone.m_destination;
	m_inputName = clone.m_inputName;
	m_inputHint = 0;
	m_format = clone.m_format;
	m_flags = clone.m_flags;

	return *this;
}

// input/output access [e.moon 14oct99]

status_t Connection::getInput(
	media_input*							outInput) {
	
	if(!isValid())
		return B_ERROR;

	outInput->node = m_destinationNode;
	strcpy(outInput->name, m_inputName.String());
	outInput->format = format();
	outInput->source = m_source;
	outInput->destination = m_destination;
	return B_OK;
}


status_t Connection::getOutput(
	media_output*							outOutput) {
	
	if(!isValid())
		return B_ERROR;

	outOutput->node = m_sourceNode;
	strcpy(outOutput->name, m_outputName.String());
	outOutput->format = format();
	outOutput->source = m_source;
	outOutput->destination = m_destination;
	return B_OK;
}

	
void Connection::setOutputHint(
	const char*									origName,
	const media_format&				origFormat) {

	if(m_outputHint) delete m_outputHint;
	m_outputHint = new endpoint_hint(origName, origFormat);
}

void Connection::setInputHint(
	const char*									origName,
	const media_format&				origFormat) {

	if(m_inputHint) delete m_inputHint;
	m_inputHint = new endpoint_hint(origName, origFormat);
}

// -------------------------------------------------------- //
// *** IPersistent
// -------------------------------------------------------- //

//// !
//#if CORTEX_XML
//// !
//
//
//void Connection::xmlExportBegin(
//	ExportContext& context) const {
//	
//	context.beginElement(s_element);
//}
//
//void Connection::xmlExportAttributes(
//	ExportContext& context) const {
//
//	context.writeAttr("id", m_id);
//	
//	ASSERT(m_sourceNode);
//	context.writeAttr("sourceNodeID", m_sourceNode->id());
//	
//	media_output* o = m_sourceNode->findOutput(m_source);
//	ASSERT(o);
//	context.writeAttr("outputName", o->name);
//
//	ASSERT(m_destinationNode);
//	context.writeAttr("destinationNodeID", m_destinationNode->id());
//	
//	media_input* i = m_destinationNode->findInput(m_destination);
//	ASSERT(o);
//	context.writeAttr("inputName", i->name);
//}
//			
//void Connection::xmlExportContent(
//	ExportContext& context) const {
//	
//	bool begun = false;
//	
//	if(m_outputHint) {
//		if(!begun)
//			context.beginContent();
//		begun = true;
//		
//		context.beginElement(s_outputHintElement);
//		context.writeAttr("origOutputName", m_outputHint->name.String());
//		context.beginContent();
//		MediaFormatIO io(m_outputHint->format);
//		context.writeObject(&io);
//		context.endElement();
//	}
//
//	if(m_inputHint) {
//		if(!begun)
//			context.beginContent();
//		begun = true;
//		
//		context.beginElement(s_inputHintElement);
//		context.writeAttr("origInputName", m_inputHint->name.String());
//		context.beginContent();
//		MediaFormatIO io(m_inputHint->format);
//		context.writeObject(&io);
//		context.endElement();
//	}
//}
//	
//void Connection::xmlExportEnd(
//	ExportContext& context) const {
//
//	context.endElement();
//}
//	
//void Connection::xmlImportBegin(
//	ImportContext&		context); //nyi
//	
//void Connection::xmlImportAttribute(
//	const char*					key,
//	const char*					value,
//	ImportContext&		context); //nyi
//		
//void Connection::xmlImportChild(
//	IPersistent*			child,
//	ImportContext&		context); //nyi
//		
//void Connection::xmlImportComplete(
//	ImportContext&		context); //nyi
//
//void Connection::xmlImportChildBegin(
//	const char*					name,
//	ImportContext&		context); //nyi
//
//void Connection::xmlImportChildAttribute(
//	const char*					key,
//	const char*					value,
//	ImportContext&		context); //nyi
//
//void Connection::xmlImportChildComplete(
//	const char*					name,
//	ImportContext&		context); //nyi
	
//// !
//#endif /*CORTEX_XML*/
//// !


// END -- Connection.cpp --
