// WireSegment.h
// e.moon 6may99
//
// PURPOSE
// - represents a single wire segment (line)
// - wires are drawn by the grid view, in the 'draw on children'
//   phase
// - stores two vertex locators
//
// HISTORY
//   e.moon 6may99: created

#ifndef __WIRESEGMENT_H__
#define __WIRESEGMENT_H__

#include "WireVertex.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class Wire;

class WireSegment {
public:					// ctor/dtor/accessors
	WireSegment() {}
	WireSegment(
		Wire* _pWire,
		const WireVertex& _from,
		const WireVertex& _to) :
		pWire(_pWire),
		from(_from),
		to(_to) {}
		
public:					// members
	Wire*					pWire;
	WireVertex		from;
	WireVertex		to;
	
	// +++++ 21may99: cache bounding rect?
};

inline bool operator==(const WireSegment& a, const WireSegment& b) {
	return a.pWire == b.pWire && a.from == b.from && a.to == b.to;
}

// comparison: spacial, comparing 'from' location, then 'to'
inline bool operator<(const WireSegment& a, const WireSegment& b) {
	if(a.from < b.from)
		return true;
	else if(b.from < a.from)
		return false;
	else
		return (a.to < b.to);
}

__END_CORTEX_NAMESPACE
#endif /* __WIRESEGMENT_H__ */