// Wire.h
// e.moon 6may99
//
// PURPOSE
//   contains all the info needed for a graphical representation
//   of a connection between two Media Kit nodes
//
// HISTORY
//  e.moon 11aug99		Bound to Connection.
//  e.moon 6may99:		created

#ifndef __WIRE_H__
#define __WIRE_H__

#include <list>
#include <vector>

#include <MediaDefs.h>
#include <MediaNode.h>

#include "WireSegment.h"

#include "Connection.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class Wire {
	friend class MediaRoutingView;

public:													// the connection this wire represents
	const Connection							connection;

protected:											// segments (accessible to MediaRoutingView)
	vector<WireSegment>						m_segments;

public:													// ctor/dtor/accessors
	virtual ~Wire();

	Wire();
	Wire(
		const Connection&						_connection);

	bool isValid() const;
	
public:													// operations

	// returns true if one or more segments of the given wire
	// touch the given column
	bool inColumn(
		uint32											column);
	
	// returns true if one or more segments of the given wire
	// touch the given row
	bool inRow(
		uint32											row);

	// fetches all segments of the given wire that touch the given column
	void getSegmentsInColumn(
		uint32											column,
		vector<WireSegment>&				segments);

	// fetches all segments of the given wire that touch the given row
	void getSegmentsInRow(
		uint32											row,
		vector<WireSegment>&				segments);

	bool isSelected() const;
	void select();
	void deselect();

private:												// selection
	bool													m_selected;
};

__END_CORTEX_NAMESPACE	
#endif /* __WIRE_H__ */
