// Wire.cpp
// e.moon 6may99

#include "Wire.h"

#include <Debug.h>

#include <float.h>

__USE_CORTEX_NAMESPACE

const BPoint WireVertex::s_noPointCached(FLT_MIN, FLT_MIN);

// -------------------------------------------------------- //
// ctor/dtor/accessors
// -------------------------------------------------------- //

Wire::~Wire() {}

Wire::Wire() : connection( Connection( ) ) {}

Wire::Wire(
	const Connection&						_connection) :
	connection(_connection),
	m_selected(false) {

	ASSERT(connection.isValid());	
}


bool Wire::isValid() const { return connection.isValid(); }

// -------------------------------------------------------- //
// operations
// -------------------------------------------------------- //

// returns true if one or more segments of the given wire
// touch the given column

bool Wire::inColumn(uint32 column) {
	for(vector<WireSegment>::iterator it = m_segments.begin();
		it != m_segments.end(); it++)
		if((*it).from.nodeColumn == column ||
			(*it).to.nodeColumn == column)
			return true;
	return false;
}

// returns true if one or more segments of the given wire
// touch the given row

bool Wire::inRow(uint32 row) {

	for(vector<WireSegment>::iterator it = m_segments.begin();
		it != m_segments.end(); it++)	
		if((*it).from.nodeRow == row ||
			(*it).to.nodeRow == row)
			return true;

	return false;
}


// fetch all segments of the given wire that cross the given column
void Wire::getSegmentsInColumn(
	uint32 column,
	vector<WireSegment>& segments) {

	for(vector<WireSegment>::iterator it = m_segments.begin();
		it != m_segments.end(); it++) {
	
		if((*it).from.nodeColumn == column ||
			(*it).to.nodeColumn == column)
			segments.push_back(*it);
	}
}

// fetch all segments of the given wire that cross the given row
void Wire::getSegmentsInRow(
	uint32 row,
	vector<WireSegment>& segments) {

	for(vector<WireSegment>::iterator it = m_segments.begin();
		it != m_segments.end(); it++) {
	
		if((*it).from.nodeRow == row ||
			(*it).to.nodeRow == row)
			segments.push_back(*it);
	}
}

bool Wire::isSelected() const { return m_selected; }
void Wire::select() { m_selected = true; }		
void Wire::deselect() { m_selected = false; }

// END -- Wire.cpp --
