// InspectorWindow.h
//
// * PURPOSE
//   Standalone window container for the group/node inspectors.
// * HISTORY
//   e.moon		18aug99		Begun

#ifndef __InspectorWindow_H__
#define __InspectorWindow_H__

#include <Window.h>

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class GroupInspector;
class NodeManager;
class RouteWindow;

class InspectorWindow :
	public	BWindow {
	typedef	BWindow _inherited;
	
public:											// *** ctors/dtor
	virtual ~InspectorWindow();
	
	InspectorWindow(
		NodeManager*						manager,
		RouteWindow*						routeWindow,
		const char*							name,
		BView*									inspector);
		
	BMessenger inspector() const;
	BView* view() const;
	
	BMessenger routeWindow() const;

public:											// *** BWindow		
	virtual bool QuitRequested();
	
private:
	BView*										m_inspector;
	RouteWindow*							m_routeWindow;
};

__END_CORTEX_NAMESPACE
#endif /*__InspectorWindow_H__*/
