// GroupInspector.h
// * PURPOSE
//   UI component (view) providing access to a selected
//   NodeGroup's properties.
// * HISTORY
//   e.moon		18aug99		Begun.

#ifndef __GroupInspector_H__
#define __GroupInspector_H__

#include <list>

#include <View.h>

class BButton;
class BStringView;
class BTextControl;
class BMenuField;
class BMenu;

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class NodeManager;
class NodeGroup;

class NumericValControl;

class _GroupInfoView;

class GroupInspector :
	public	BView {
	typedef	BView _inherited;

public:											// *** messages
	enum message_t {
		// groupID: int32
		M_SELECT_GROUP					= GroupInspector_message_base,

		// _value: string
		M_SET_NAME
	};
	
public:											// *** ctors/dtor
	virtual ~GroupInspector(); //nyi
	
	GroupInspector(
		NodeManager*						nodeManager,
		const char*							name); //nyi
	
public:											// *** BView
	virtual void AttachedToWindow();
	virtual void AllAttached();
	virtual void FrameResized(
		float										width,
		float										height);
	virtual void MouseDown(
		BPoint									where);
		
public:											// *** BHandler
	virtual void MessageReceived(
		BMessage*								message); //nyi
		
private:										// *** BHandler impl.
	void _handleSelectGroup(
		BMessage*								message);
		
protected:									// *** internal operations

	// select the given group; initialize controls
	// (if 0, gray out all controls)
	void _selectGroup(
		uint32									groupID);

	void _observeGroup();
	void _releaseGroup();
	
	void _initTimeSources();

protected:									// *** controls

	void _constructControls(); //nyi
	
	void _disableControls();
	void _enableControls();

	void _updateTransportButtons();
	void _updateTimeSource();
	void _updateRunMode();
	
	// convert a position control's value to bigtime_t
	// [e.moon 11oct99]
	bigtime_t _scalePosition(
		double									value);
	
	void _populateRunModeMenu(
		BMenu*									menu);
	void _populateTimeSourceMenu(
		BMenu*									menu);
		
	// add the given invoker to be retargeted to this
	// view (used for controls whose messages need a bit more
	// processing before being forwarded to the NodeGroup.)
	void _addLocalTarget(
		BInvoker*								invoker);

	void _addGroupTarget(
		BInvoker*								invoker);
		
protected:									// *** layout

	void _initLayout();
	void _updateLayout();

private:
	friend _GroupInfoView;

	// logical
	NodeManager*							m_manager;
	NodeGroup*								m_group;

	media_node*								m_timeSourcePresets;
	
	// controls
	_GroupInfoView*						m_infoView;
//	BStringView*							m_nameView;
	BMenuField*								m_runModeView;
	BMenuField*								m_timeSourceView;
	//BTextControl*							m_regionStartView;
	//BTextControl*							m_regionEndView;

	BStringView*							m_fromLabel;
	NumericValControl*				m_regionStartView;
	BStringView*							m_toLabel;
	NumericValControl*				m_regionEndView;
	
	BButton*									m_startButton;
	BButton*									m_stopButton;
	BButton*									m_prerollButton;
	
	typedef list<BInvoker*>		target_set;
	target_set								m_localTargets;
	target_set								m_groupTargets;
	
	// layout
	class _layout_state;
	_layout_state*						m_layout;
		
//	// physical: title/ID row
//	BRect											m_nameViewRect;
//	
//	// physical: content rows
//	// - x position to align BMenuField/BTextControl fields against
//	float											m_fieldOffset;
//	BRect											m_
//	
//	BRect											m_startPosViewRect;
//	BRect											m_endPosViewRect;
};

__END_CORTEX_NAMESPACE
#endif /*__GroupInspector_H__*/
