// BookwormWindow.cpp
// Copyright 1997 by Brad Ackerman.  All Rights Reserved.
//
// Main window; includes menubar setup &c.

#include <Alert.h>
#include <Application.h>
#include <FilePanel.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <Messenger.h>
#include <ScrollBar.h>
#include <ScrollView.h>
#include <TextView.h>
#include <Window.h>
#include <string.h>
#include "BookwormConverter.h"
#include "BookwormWindow.h"
#include "BookwormConsts.h"

BookwormWindow::BookwormWindow(BRect frame)
				: BWindow(frame, "Bookworm", B_TITLED_WINDOW, B_NOT_ZOOMABLE )
{
	BRect		aRect, ourBounds, textRect, textFrame, scrollViewRect;
	BMenuBar	*menuBar;
	BMenu		*aMenu;
	
	Lock();
	// create menu bar
	aRect.Set(0, 0, 1000, 15);
	menuBar = new BMenuBar(aRect, "Menu");
	// add menus
	aMenu = new BMenu("File");
	aMenu->AddItem(new BMenuItem("Open...", new BMessage(FILE_OPEN), 'O'));
	aMenu->AddSeparatorItem();
	aMenu->AddItem(new BMenuItem("About", new BMessage(FILE_ABOUT)));
	aMenu->AddSeparatorItem();
	aMenu->AddItem(new BMenuItem("Quit", new BMessage(FILE_QUIT), 'Q'));
	menuBar->AddItem(aMenu);
	
	AddChild(menuBar);
	
	// create rects for TextView and ScrollView construction
	ourBounds = Bounds();
	textFrame.Set(ourBounds.left + STATUS_LEFT_MARGIN,
					ourBounds.top + STATUS_TOP_MARGIN,
					ourBounds.right - (STATUS_RIGHT_MARGIN + B_V_SCROLL_BAR_WIDTH),
					ourBounds.bottom - STATUS_BOTTOM_MARGIN);
	textRect = textFrame;
	textRect.OffsetTo(0, 0);
	textRect.left += STATUS_TEXT_L_MARGIN;
	textRect.right -= STATUS_TEXT_R_MARGIN;
	textRect.top += STATUS_TEXT_T_MARGIN;
	
	// now make our scrolling status view.
	textView = new BTextView( textFrame, "Status TextView", textRect,
								B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	
	scrollView = new BScrollView("Status ScrollView", textView, B_FOLLOW_ALL_SIDES,
								0, false, true, B_FANCY_BORDER);
	
	textView->MakeEditable(false);
	AddChild(scrollView);	
	
	// construct our open and save panel for later
	// don't allow multiple selections for now
	openPanel = new BFilePanel(B_OPEN_PANEL, NULL, 0, false);
	savePanel = new BFilePanel(B_SAVE_PANEL);
	savePanel->Window()->SetTitle("Bookworm: Enter folder name to save as");
	// show the main window and unlock it
	Show();
	Unlock();
}

BookwormWindow::~BookwormWindow() {
	// kill our file panels
	delete openPanel;
	delete savePanel;
}

bool BookwormWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}

void BookwormWindow::MessageReceived(BMessage *event) {
	BAlert *alert;
	long result;
	
	switch (event->what) {
		case FILE_OPEN:
			// show the open panel
			openPanel->Show();
			break;
		case FILE_ABOUT:
			// display about box
			alert = new BAlert("About Bookworm...",
				"Bookworm v0.95\n© 1997 by Brad Ackerman. All rights reserved.", "OK");
			result = alert->Go();
			break;
		case FILE_QUIT:
			// quit
			be_app->PostMessage(B_QUIT_REQUESTED);
			break;
		default:
			inherited::MessageReceived(event);
			break;
		case B_SIMPLE_DATA:
			if (event->WasDropped)
				be_app->RefsReceived(new BMessage(event));
			break;

	}
}

void BookwormWindow::PrintStatusMsg(const char *text) {
	Lock();
	textView->Insert(textView->TextLength(), text, strlen(text));
	textView->ScrollToOffset(textView->TextLength());
	Unlock();
}

void BookwormWindow::FrameResized(float width, float height) {
	BRect newRect = textView->Frame();
	
	// resize textRect of status text to new correct size
	newRect.left += STATUS_TEXT_L_MARGIN;
	newRect.right -= STATUS_TEXT_R_MARGIN;
	newRect.top += STATUS_TEXT_T_MARGIN;
	textView->SetTextRect(newRect);
}