//:  BeOSIconFactory.java

package com.be.swing.plaf.beos;

import java.io.*;
import java.awt.*;
import java.net.*;
import javax.swing.*;

/**
 * Factory class for creating Icon resources for the
 * BeOS Look and Feel.  If the colors of any of these
 * icons are dependent on BeOS system preferences (the
 * color of the check in the check box, for example?),
 * the Icon should be created in code instead of loading
 * from a gif file.
 *
 * @author  Michael Heuer
 * @version $Id: BeOSIconFactory.java,v 1.4 1999/11/10 04:01:19 heuermh Exp $
 */
public class BeOSIconFactory {

	static Icon radioButtonIcon;
	static Icon checkBoxIcon;

	/**
	 * Factory method that returns the icon
	 * for a radio button.
	 */
	static Icon getRadioButtonIcon() {
		if (radioButtonIcon == null) {
			radioButtonIcon = new RadioButtonIcon();
		}
		return radioButtonIcon;
	}

	/**
	 * Factory method that returns the icon
	 * for a check box.
	 */
	static Icon getCheckBoxIcon() {
		if (checkBoxIcon == null) {
			checkBoxIcon = new CheckBoxIcon();
		}
		return checkBoxIcon;
	}

	/**
	 * Dynamic RadioButton icon that changes appearance
	 * based on the state of the button and of the button model.
	 */
	static class RadioButtonIcon implements Icon, Serializable {
		public void paintIcon( Component c, Graphics g, int x, int y ) {

			AbstractButton b = (AbstractButton) c;
			ButtonModel model = b.getModel();

			if (model.isEnabled()) {
				if (model.isSelected()) {
					if (model.isPressed() && model.isArmed()) {
						UIManager.getIcon("RadioButton.pressedOn").paintIcon(c,g,x,y);
						return;
					} else {
						UIManager.getIcon("RadioButton.on").paintIcon(c,g,x,y);
						return;
					}
				} else {
					if (model.isPressed() && model.isArmed()) {
						UIManager.getIcon("RadioButton.pressedOff").paintIcon(c,g,x,y);
						return;
					} else {
						UIManager.getIcon("RadioButton.off").paintIcon(c,g,x,y);
						return;
					}
				}
			} else {
				if (model.isSelected()) {
					UIManager.getIcon("RadioButton.disabledOn").paintIcon(c,g,x,y);
					return;
				} else {
					UIManager.getIcon("RadioButton.disabledOff").paintIcon(c,g,x,y);
					return;
				}
			}
		}
		public int getIconWidth() {
			return 13;
		}
		public int getIconHeight() {
			return 13;
		}
	}

	/**
	 * Dynamic CheckBox icon that changes appearance
	 * based on the state of the button and of the button model.
	 */
	static class CheckBoxIcon implements Icon, Serializable {
		public void paintIcon( Component c, Graphics g, int x, int y ) {

			AbstractButton b = (AbstractButton) c;
			ButtonModel model = b.getModel();

			if (model.isEnabled()) {
				if (model.isSelected()) {
					if (model.isPressed() && model.isArmed()) {
						UIManager.getIcon("CheckBox.pressedOn").paintIcon(c,g,x,y);
						return;
					} else {
						UIManager.getIcon("CheckBox.on").paintIcon(c,g,x,y);
						return;
					}
				} else {
					if (model.isPressed() && model.isArmed()) {
						UIManager.getIcon("CheckBox.pressedOff").paintIcon(c,g,x,y);
						return;
					} else {
						UIManager.getIcon("CheckBox.off").paintIcon(c,g,x,y);
						return;
					}
				}
			} else {
				if (model.isSelected()) {
					UIManager.getIcon("CheckBox.disabledOn").paintIcon(c,g,x,y);
					return;
				} else {
					UIManager.getIcon("CheckBox.disabledOff").paintIcon(c,g,x,y);
					return;
				}
			}
		}
		public int getIconWidth() {
			return 12;
		}
		public int getIconHeight() {
			return 12;
		}
	}       

	static Icon horizontalThumbIcon = new ImageIcon("com/be/swing/plaf/beos/icons/SliderHorizontalThumb.gif");

	/**
	 * Factory method that returns the icon
	 * for a slider's horizontal thumb.
	 */
	static Icon getHorizontalThumbIcon() {
//		if (horizontalThumbIcon==null) {
//			Object ignore = new Object();
//			URL url = ignore.getClass().getResource();
//			
//			horizontalThumbIcon = new ImageIcon(url);
//		}
		return horizontalThumbIcon;
	}

	static Icon verticalThumbIcon = new ImageIcon("com/be/swing/plaf/beos/icons/SliderVerticalThumb.gif");

	/**
	 * Factory method that returns the icon
	 * for a slider's horizontal thumb.
	 */
	static Icon getVerticalThumbIcon() {
//		if (verticalThumbIcon==null) {
//			Object ignore = new Object();
//			URL url = ignore.getClass().getResource();
//			
//			verticalThumbIcon = new ImageIcon(url);
//		}
		return verticalThumbIcon;
	}
	

/**
Here's how to do everything in code

// radio button icons
static Icon radioButtonDisabledOnIcon;
static Icon radioButtonDisabledOffIcon;
static Icon radioButtonEnabledOnIcon;
static Icon radioButtonEnabledOffIcon;
static Icon radioButtonPressedOnIcon;
static Icon radioButtonPressedOffIcon;

// radio button accessor methods
static Icon getRadioButtonDisabledOnIcon() {
if (radioButtonDisabledOnIcon == null) {
radioButtonDisabledOnIcon = new RadioButtonDisabledOnIcon();
}
return radioButtonDisabledOnIcon;
}
static Icon getRadioButtonDisabledOffIcon() {
if (radioButtonDisabledOffIcon == null) {
radioButtonDisabledOffIcon = new RadioButtonDisabledOffIcon();
}
return radioButtonDisabledOffIcon;
}
static Icon getRadioButtonEnabledOnIcon() {
if (radioButtonEnabledOnIcon == null) { 
radioButtonEnabledOnIcon = new RadioButtonEnabledOnIcon();
}
return radioButtonEnabledOnIcon;
}
static Icon getRadioButtonEnabledOffIcon() {
if (radioButtonEnabledOffIcon == null) {
radioButtonEnabledOffIcon = new RadioButtonEnabledOffIcon();
}
return radioButtonEnabledOffIcon;
}
static Icon getRadioButtonPressedOnIcon() {
if (radioButtonPressedOnIcon == null) {
radioButtonPressedOnIcon = new RadioButtonPressedOnIcon();
}
return radioButtonPressedOnIcon;
}
static Icon getRadioButtonPressedOffIcon() {
if (radioButtonPressedOffIcon == null) {
radioButtonPressedOffIcon = new RadioButtonPressedOffIcon();
}
return radioButtonPressedOffIcon;
}

// radio button class defs
static class RadioButtonDisabledOnIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
static class RadioButtonDisabledOffIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
static class RadioButtonEnabledOnIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
static class RadioButtonEnabledOffIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
static class RadioButtonPressedOnIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
static class RadioButtonPressedOffIcon implements Icon, Serializable {
public void paintIcon( Component c, Graphics g, int x, int y ) {
g.translate(x,y);

// draw on g

g.translate(-x, -y);
}
public int getIconWidth() {
return 0;
}
public int getIconHeight() {
return 0;
}
}
*/

}