/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public abstract class BasicURLConnection
extends URLConnection {
    protected static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "date", "expiration", "If-Modified-Since", "lastModified"};
    protected static final int ContentEncoding = 0;
    protected static final int ContentLength = 1;
    protected static final int ContentType = 2;
    protected static final int Date = 3;
    protected static final int Expiration = 4;
    protected static final int IfModifiedSince = 5;
    protected static final int LastModified = 6;
    protected String[] headersValue = new String[headers.length];

    public abstract void connect() throws IOException;

    public String getHeaderField(String string) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equals(string)) {
                return this.getHeaderField(n);
            }
            ++n;
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }

    protected void setHeaderField(String string, String string2) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equals(string)) {
                this.headersValue[n] = string2;
                break;
            }
            ++n;
        }
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return null;
        }
        if (this.headersValue[0].startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return null;
    }

    protected void setContentTypeFromName() {
        String string;
        this.headersValue[2] = string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.headersValue[0] = string;
    }

    public BasicURLConnection(URL uRL) {
        super(uRL);
    }
}

