/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private static final String newline = System.getProperty("line.separator");
    protected Writer out;
    private boolean flsh;
    private boolean error;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() {
        try {
            this.out.flush();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    protected void setError() {
        this.error = true;
    }

    public void write(int n) {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] cArray, int n, int n2) {
        try {
            this.out.write(cArray, n, n2);
            return;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string, int n, int n2) {
        if (string == null) {
            this.write(String.valueOf(string));
        } else {
            this.write(string.toCharArray(), n, n2);
        }
    }

    public void write(String string) {
        if (string == null) {
            this.write(String.valueOf(string));
        } else {
            this.write(string.toCharArray(), 0, string.length());
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int n) {
        this.write(Integer.toString(n));
    }

    public void print(long l) {
        this.write(Long.toString(l));
    }

    public void print(float f) {
        this.write(Float.toString(f));
    }

    public void print(double d) {
        this.write(Double.toString(d));
    }

    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void print(String string) {
        this.write(string);
    }

    public void print(Object object) {
        this.print(String.valueOf(object));
    }

    public void println() {
        this.write(newline);
        if (this.flsh) {
            this.flush();
        }
    }

    public void println(boolean bl) {
        this.println(bl ? "true" : "false");
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.write(c);
            this.println();
        }
    }

    public void println(int n) {
        this.println(Integer.toString(n));
    }

    public void println(long l) {
        this.println(Long.toString(l));
    }

    public void println(float f) {
        this.println(Float.toString(f));
    }

    public void println(double d) {
        this.println(Double.toString(d));
    }

    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.write(cArray, 0, cArray.length);
            this.println();
        }
    }

    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.write(string);
            this.println();
        }
    }

    public void println(Object object) {
        this.println(String.valueOf(object));
    }

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl) {
        this.out = writer;
        this.flsh = bl;
        this.error = false;
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this.out = new OutputStreamWriter(outputStream);
        this.flsh = bl;
        this.error = false;
    }
}

