#include "clone_ptr.hh"

template <typename Class> 
clone_ptr<Class>::clone_ptr(const clone_ptr<Class> &other) {
  if (other.own) 
    ptr = other.ptr->clone();
  else
    ptr = other.ptr;
  own = other.own;
}

template <typename Class>
  clone_ptr<Class> & 
  clone_ptr<Class>::operator= (const clone_ptr<Class> & other) 
{
  if (own) delete ptr;
  if (other.own) 
    ptr = other.ptr->clone();
  else
    ptr = other.ptr;
  own = other.own;
  return *this;
}

template <typename Class>
clone_ptr<Class>::~clone_ptr() {
  if (own) delete ptr;
}
