//scrolling window

#include "windowGuts.h"
#include "mainWindow.h"
#include <memory>
#include "scrollView.h"
#include "layoutMatrix.h"
#include "intGadg.h"
#include "myButtonGadg.h"
#include "myButtonGadgA.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"
#include "colorWellGadg.h"

//ctor just initializing
WindowGuts	::	WindowGuts(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				BWindow(	paramBound, 
							ccpparamWindowTitle, 
							B_DOCUMENT_WINDOW, 
							B_WILL_ACCEPT_FIRST_CLICK), 
				baseView(NULL), 
				scrollView(NULL),
				pMenuBar(new BMenuBar(BRect(0, 0, 1000, 15), "WindowGutsMenuBar")),
				scrollViewName(new char[strlen(ccpparamScrollViewName) + 1]),
				ccpNamePrefFrame(ccpparamNamePrefFrame),
				pLayoutMatrixList(new BList()),
				font(new BFont(((MyApp *)be_app)->GetPreferredFont()))
{
strcpy(scrollViewName, ccpparamScrollViewName);
}//end


//dtor
WindowGuts	::	~WindowGuts() 
{
	delete pLayoutMatrixList;
	delete font;
	delete [] scrollViewName;
}//end


//do all the real work of construction so we can fail gracefully
bool 
WindowGuts	::	Initialize(	void) 
{
	AddChild(pMenuBar);
	float mb_height = pMenuBar->Bounds().Height();
	LayoutMatrix * tempLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->LastItem();//dynamic cast??
//printf("debug tempLayoutMatrix->right %f\n", tempLayoutMatrix->right);
printf("debug tempLayoutMatrix\n");
//debug need the above printf() for timing when race occurs and I need to run from terminal
	float maxRight = tempLayoutMatrix->right;
	float maxBottom = tempLayoutMatrix->bottom;
	maxRight += MATRIXHORIZONTALOFFSETGUTS;
	maxBottom += MATRIXVERTICALOFFSETGUTS;
	//need a bit of pad spacing between the items and the view edge
	
	float newWindowWidth = maxRight;
	float newWindowHeight = maxBottom;
	ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH, 
				newWindowHeight + B_H_SCROLL_BAR_HEIGHT + 18);
	//insure the widow is appropriately sized--as small as
	//needed, or if need be (underlaying view larger than screen
	//resolution) as large as will fit on the screen nicely

	underViewWidth = maxRight;
	underViewHeight = maxBottom;
	
	try 
	{
		//this is the view into which we will place our buttons
		//notice the "mb_height + 1", in the second element
		baseView = new ScrollView(	BRect(	0, 
											mb_height + 1, 
											maxRight, 
											maxBottom + mb_height - 1));
		if (font) 
		{
			baseView->SetFont(font);
		}
	}
	catch(...) 
	{
		warning("New failed.\n");
		return false;
	}
	try 
	{
		//this is the scroll bar stuff:
		scrollView = new BScrollView(	scrollViewName, 
										(BView *)baseView, 
										B_FOLLOW_ALL, 
										B_WILL_DRAW, 
										true, 
										true, 
										B_NO_BORDER);
	}
	catch(...) 
	{
		warning("New failed.\n");
		return false;
	}
	AddChild(scrollView);
	//to the older sized window
	
	scrollView->ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH + 1, 
							newWindowHeight + B_H_SCROLL_BAR_HEIGHT - 1);
	//BScrollViews get thier initial size from the underlaying BView (baseView)
	
	//now we have a baseView with permenent homes for the created buttons:
	int32 numLayoutMatrixListItems = pLayoutMatrixList->CountItems();
	for (int32 j = 0; j < numLayoutMatrixListItems; j++)
	{
		LayoutMatrix * holdLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(j);
		int32 numItems = holdLayoutMatrix->mpChildrenToAdd->CountItems();
		for (int32 i = 0; i < numItems; i++)
		{
			BView * child = (BView *)holdLayoutMatrix->mpChildrenToAdd->ItemAt(i);
			ColorWellGadg * cwg = dynamic_cast<ColorWellGadg *> (child);
			if (cwg)
			{
				cwg->MoveTo(cwg->GetLeft(), cwg->GetTop());
				baseView->AddChild(child);
			}
			else
			{
				MyButtonGadg * mbg = dynamic_cast<MyButtonGadg *> (child);
				if (mbg)
				{
					BButton * button = dynamic_cast<BButton *> (child);
					if (button)
					{
						baseView->AddChild(button);
						button->SetTarget(this);
					}
					else
					{
						baseView->AddChild(child);
					}
				}
				else
				{
					IntGadg * intGadg = dynamic_cast<IntGadg *> (child);
					if (intGadg)
					{
						BTextControl * textControl = dynamic_cast<BTextControl *> (child);
						if (textControl)
						{
							baseView->AddChild(textControl);
							textControl->SetTarget(this);
						}
						else
						{
							baseView->AddChild(child);
						}
					}
					else
					{
						baseView->AddChild(child);
					}
				}
			}
		}
		numItems = holdLayoutMatrix->mpItemsToDraw->CountItems();
		for (int32 i = 0; i < numItems; i++)
		{
			baseView->pmTextItemList->AddItem(holdLayoutMatrix->mpItemsToDraw->ItemAt(i));
		}
	}
	UpdateScrollBars();//adjust knobs position and proportions
	Show();
	return true;
}//end


//adjust scroll bars to reflect new situation
void 
WindowGuts	::	UpdateScrollBars() 
{
	//puts the scroll bars in the proper perspective
	//this code was grabbed from the mandx sample
	//and converted from BBitMap to BView stuff
	
	BScrollView * scrollview;
	BScrollBar * scrollbar;
	BRect visibleExtent;
	BRect totalExtent;
	BRect bound;
	BRect myBounds;
	long max;
	
	Lock();
	scrollview = (BScrollView *)FindView(scrollViewName);
	if (scrollview) 
	{
		bound.Set(0, 0, underViewWidth, underViewHeight);
		myBounds = Bounds();
	
		visibleExtent = bound & myBounds;
		totalExtent = bound | myBounds;
	
		scrollbar = scrollview->ScrollBar(B_HORIZONTAL);
		max = bound.Width() - myBounds.Width();
		if (max < 0) 
		{
			max = 0;
		}
		scrollbar->SetRange(0, max);
		scrollbar->SetProportion(visibleExtent.Width() / totalExtent.Width());
	
		scrollbar = scrollview->ScrollBar(B_VERTICAL);
		max = bound.Height() - myBounds.Height();
		if (max < 0) 
		{
			max = 0;
		}
		scrollbar->SetRange(0, max);
		scrollbar->SetProportion(visibleExtent.Height() / totalExtent.Height());
		baseView->Invalidate(baseView->Bounds());
	}
	else 
	{
		warning("No scrollView!\n");
	}
	Unlock();
}//end


void 
WindowGuts	::	FrameResized(	float, /*note that by NOT naming these we avoid the "unused parameter" warning*/
								float) 
{
	UpdateScrollBars();
}//end


bool
WindowGuts	::	QuitRequested(	void) 
{
	/*	save our position	*/
	bool allSetsOK = true;
	BRect frame = Frame();
	if (((MyApp *)be_app)->appsPreferenceSet.SetData(ccpNamePrefFrame, &frame, sizeof(frame), B_RECT_TYPE))
	{
		warning("Cannot set frame preference.\n");
		allSetsOK = false;
	}
	if (allSetsOK)
	{
		if (((MyApp *)be_app)->appsPreferenceSet.Save())
		{
			warning("Prefs cannot save settings.\n");
		}
	}
	if (((MyApp *)be_app)->bPrefChangesMade)
	{
		((MyApp *)be_app)->pMainWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(true);
}//end


void
WindowGuts	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_WINDOWGUTS:	
		{
			warning("about gutsy window\n");
		break;
		}
		default:
			BWindow::MessageReceived(pparamMessage);
		break;
	}
}//end


void
WindowGuts	::	AddToLayoutMatrixList(	LayoutMatrix * pparamLayoutMatrix)
{
	pLayoutMatrixList->AddItem((void *)pparamLayoutMatrix);
}//end