//functions of ScrollView

#include "scrollView.h"
#include "textItem.h"
#include "layoutMatrix.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"

ScrollView	::	ScrollView(	BRect area) 
			: 	BView(	area, 
						"target", 
						B_FOLLOW_ALL, 
						B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE),
				pmTextItemList(new BList())
{
	SetViewColor(B_TRANSPARENT_32_BIT);
}//end


ScrollView	::	~ScrollView() 
{
	delete pmTextItemList;
}//end


void 
ScrollView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	((MyApp *)be_app)->GetPreferredHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	((MyApp *)be_app)->GetPreferredLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	((MyApp *)be_app)->GetPreferredViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ScrollView	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	DrawAllTextItems();
}//end


void 
ScrollView	::	DrawAllTextItems(	void)
{
	//need to learn how to DoForEach(), need to understand pointers to functions
	int32 numItems = pmTextItemList->CountItems();
	for (uint32 i = 0; i < numItems; i++)
	{
		TextItem * textItem = (TextItem *)pmTextItemList->ItemAt(i);
		MovePenTo(textItem->left, textItem->top);
		rgb_color originalColor(HighColor());
		rgb_color newColor;
		((MyApp *)be_app)->GetPreferredHighColor(&newColor);
		SetHighColor(newColor);
		DrawString(textItem->text);
		SetHighColor(originalColor);
	}
}//end


void
ScrollView	::	MessageReceived(	BMessage * pparamMessage) 
{
	BView::MessageReceived(pparamMessage);
}//end