#ifndef _path_monitor_incl
#define _path_monitor_incl

#include "NodeMonitorHelpers.h"
#include <Path.h>

/**
 A PathMonitor just follows the path of a class.
*/
class PathMonitor :
	public NodeMonitor {
public:
	/** Begins monitoring the path of a BEntry.
	    Recall that BEntry is the ancestor to BDirectory, BSymLink, and BFile.
		The entry that is passed in must be valid and concrete, which is to say
		that it must point to an entry that exists in the file system.
		BEntry::Exists() must return true.
	*/
	PathMonitor(BEntry &toWatch);
	
	/// Stops watching the BEntry.
	virtual ~PathMonitor();

	/// Returns the current path of the monitored file system node.	
	void GetPath(BPath *newPath);

	/// Override this to get notifications when the path changes.
	virtual void PathChanged();
	
protected:
	/** Derived classes can get the current path by using this data member.
	@see mPathLocker
	*/
	BPath mPath;

	/**
		This protects the mPath object.  Lock it only while you need to use it.
		@see BAutoLocker in the storage kit
	*/
	BLocker mPathLocker;

private:
	void EntryMoved(node_ref &from_directory, node_ref &to_directory, const char *newName);

};



#endif