#include "PathMonitor.h"
#include <Path.h>
#include <stdio.h>
#include <Autolock.h>

PathMonitor::PathMonitor(BEntry &toWatch)
	: NodeMonitor(toWatch) {
	if (InitCheck() == B_NO_ERROR) {
		toWatch.GetPath(&mPath);
	}
}

PathMonitor::~PathMonitor() {
}

void PathMonitor::GetPath(BPath *toFill) {
	BAutolock lock(mPathLocker);
	*toFill = mPath;
}

void PathMonitor::EntryMoved(node_ref &from_directory, node_ref &to_directory, const char *newName) {
	{
		BAutolock lock(mPathLocker);
		
		BDirectory newdir(&to_directory);
		mPath.SetTo(&newdir, newName);
		if (sNodeMonitorDebugging)
			printf("Path Monitor says: my new path is %s\n", mPath.Path());
	}
	PathChanged();
}

void PathMonitor::PathChanged() {
}
