/* AmVelocityFilter.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 06.02.00		hackborn
 * Created this file
 */

#include <be/app/Message.h>
#include <be/interface/View.h>
#include "AmPublic/AmFilterI.h"

/*****************************************************************************
 * ARP-VELOCITY-FILTER
 * This filter reassigns the velocity of all note events that come through.
 * It can be configured to:
 *		Set all velocities to an absolute value
 *		Scale all velocities by a percent
 *****************************************************************************/
class ArpVelocityFilterAddOn;

class ArpVelocityFilter : public AmFilterI
{
public:
	ArpVelocityFilter(	ArpVelocityFilterAddOn* addon,
						AmFilterHolderI* holder,
						const BMessage* config);
	virtual ~ArpVelocityFilter();
	
	virtual AmEvent* HandleEvent(AmEvent* event, const am_filter_params* params = NULL);
	virtual BView* NewEditView(BPoint requestedSize) const;
	
	// The ArpConfigurableI implementation.
	virtual status_t GetConfiguration(BMessage* values) const;
	virtual status_t PutConfiguration(const BMessage* values);
	virtual status_t Configure(ArpVectorI<BView*>& panels);

	enum {
		ABSOLUTE_MODE	= 1,
		SCALE_MODE		= 2
	};

private:
	ArpVelocityFilterAddOn*	mAddOn;
	AmFilterHolderI*		mHolder;

	int32					mMode;
	uchar					mAbsolute;
	float					mScale;
};

/*****************************************************************************
 * ARP-VELOCITY-FILTER-ADDON
 *****************************************************************************/
class ArpVelocityFilterAddOn : public AmFilterAddOn
{
public:
	ArpVelocityFilterAddOn(const void* cookie)
		: AmFilterAddOn(cookie)
	{
	}
	
	virtual VersionType Version(void) const				{ return VERSION_CURRENT; }
	virtual const char* Name() const					{ return "Velocity"; }
	virtual const char* ClassName() const				{ return "arp:Velocity"; }
	virtual const char* ShortDescription() const		{ return "Set the velocity of note events"; }
	virtual const char* Author() const					{ return "Eric Hackborn"; }
	virtual void		GetVersion(int32* major, int32* minor) const;
	virtual type Type() const							{ return NORMAL_FILTER; }
	virtual BBitmap* Image(BPoint requestedSize) const;
	virtual AmFilterI* NewInstance(	AmFilterHolderI* holder,
									const BMessage* config = 0);
};
